/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.eso.dfs.gui.SwingFileChooser;
import org.eso.gasgano.gui.GUIUtils;

public class FileListChooser
extends JPanel
implements ActionListener {
    private Vector currentList = new Vector();
    private JButton deleteButton = null;
    private JButton addButton = null;
    private static final String deleteLabel = "Remove Selected Files";
    private static final String addLabel = "Add File";
    private JFileChooser fileChooser = new SwingFileChooser();
    private JList fileList = null;
    private boolean emergencyBrake = false;
    private int maxRecursiveDirs = 100;

    public static void main(String[] args) {
        JFrame frame = new JFrame("FileListChooser");
        FileListChooser fc = new FileListChooser();
        Vector vec = new Vector();
        vec.addElement(new String("/data/raw"));
        vec.addElement(new String("/data/raw/1999-05-06"));
        vec.addElement(new String("/data/reduced"));
        fc.setFileList(vec);
        if (JOptionPane.showConfirmDialog(frame, fc, "Edit directory set", 2, -1) == 0) {
            vec = fc.getFileList();
        }
        for (int i = 0; i < vec.size(); ++i) {
            System.out.println(vec.elementAt(i).toString());
        }
        System.exit(0);
    }

    public FileListChooser() {
        this.fileChooser.addActionListener(this);
        this.fileChooser.setFileSelectionMode(2);
        this.fileChooser.setApproveButtonText(addLabel);
        this.fileChooser.setMultiSelectionEnabled(true);
        this.fileChooser.setDragEnabled(true);
        this.fileList = new JList();
        this.fileList.setListData(this.currentList);
        this.setLayout(new BorderLayout());
        this.deleteButton = new JButton(deleteLabel);
        this.deleteButton.addActionListener(this);
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.setBorder(new EmptyBorder(5, 5, 0, 5));
        buttonPanel.add((Component)this.deleteButton, "East");
        this.addButton = new JButton(addLabel);
        this.addButton.addActionListener(this);
        buttonPanel.add((Component)this.addButton, "West");
        JPanel listPanel = new JPanel(new BorderLayout());
        listPanel.add((Component)new JLabel("Data Directories and Files:"), "North");
        listPanel.add((Component)new JScrollPane(this.fileList, 22, 32), "Center");
        listPanel.add((Component)buttonPanel, "South");
        listPanel.setBorder(new CompoundBorder(new LineBorder(Color.black, 1), new EmptyBorder(5, 10, 5, 10)));
        listPanel.setPreferredSize(new Dimension(450, 200));
        this.add((Component)listPanel, "Center");
    }

    public void setFileList(Vector files) {
        this.currentList = files;
        this.fileList.setListData(this.currentList);
    }

    public Vector getFileList() {
        ListModel lm = this.fileList.getModel();
        Vector<String> rc = new Vector<String>(lm.getSize());
        for (int i = 0; i < lm.getSize(); ++i) {
            String filePath = lm.getElementAt(i).toString();
            if (filePath == null || filePath.length() <= 0) continue;
            String fp2 = "";
            try {
                File f = new File(filePath);
                fp2 = f.getCanonicalPath();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            filePath = fp2;
            rc.addElement(filePath);
        }
        return rc;
    }

    public void setFileChooser(JFileChooser fc) {
        this.fileChooser = fc;
    }

    public JFileChooser getFileChooser() {
        return this.fileChooser;
    }

    @Override
    public void actionPerformed(ActionEvent a2) {
        if (a2.getActionCommand() == addLabel) {
            this.addFile();
        } else if (a2.getActionCommand() == deleteLabel) {
            this.deleteSelectedFiles();
        }
    }

    private void deleteSelectedFiles() {
        ListModel lm = this.fileList.getModel();
        Vector<String> files = new Vector<String>(lm.getSize());
        for (int i = 0; i < lm.getSize(); ++i) {
            String filePath = lm.getElementAt(i).toString();
            if (this.fileList.isSelectedIndex(i) || filePath == null || filePath.length() <= 0) continue;
            files.addElement(filePath);
        }
        this.setFileList(files);
    }

    private void addFile() {
        JFileChooser fChooser = this.getFileChooser();
        fChooser.setMultiSelectionEnabled(true);
        if (fChooser.showOpenDialog(this) == 0) {
            File[] selectedFiles = null;
            selectedFiles = fChooser.getSelectedFiles();
            for (int f = 0; f < selectedFiles.length; ++f) {
                Object[] fileSet;
                if (selectedFiles[f].isDirectory()) {
                    Vector allTheDirs = new Vector();
                    if (this.getAllTheDirectories(selectedFiles[f], allTheDirs)) {
                        fileSet = new File[allTheDirs.size()];
                        allTheDirs.copyInto(fileSet);
                    } else {
                        fileSet = new File[]{};
                    }
                } else {
                    fileSet = new File[]{selectedFiles[f]};
                }
                Object lm = null;
                Vector files = this.getFileList();
                for (int i = 0; i < fileSet.length; ++i) {
                    if (fileSet[i] == null) continue;
                    String selectedFile = null;
                    selectedFile = ((File)fileSet[i]).getPath();
                    if (files.contains(selectedFile)) continue;
                    files.addElement(selectedFile);
                }
                this.setFileList(files);
            }
        }
    }

    private boolean getAllTheDirectories(File father, Vector allTheDirs) {
        allTheDirs.removeAllElements();
        this.rec_traverse(father, allTheDirs);
        if (this.emergencyBrake) {
            GUIUtils.userMessage(this, "Too many directories under " + father + ".\nSelection aborted");
            allTheDirs.removeAllElements();
            this.emergencyBrake = false;
            return false;
        }
        return true;
    }

    private void rec_traverse(File father, Vector allTheDirs) {
        File tmpFile = null;
        String[] childrenFiles = null;
        String[] childrenDirs = null;
        childrenFiles = father.list();
        if (childrenFiles == null || this.emergencyBrake) {
            return;
        }
        allTheDirs.addElement(father);
        if (allTheDirs.size() > this.maxRecursiveDirs) {
            this.emergencyBrake = true;
            return;
        }
        childrenDirs = father.list(new DirsOnlyFilter());
        if (childrenDirs == null) {
            return;
        }
        for (int i = 0; i < childrenDirs.length; ++i) {
            try {
                tmpFile = new File(father.getCanonicalPath() + File.separator + childrenDirs[i]);
            }
            catch (IOException ioe) {
                continue;
            }
            this.rec_traverse(tmpFile, allTheDirs);
        }
    }

    protected class DirsOnlyFilter
    implements FilenameFilter {
        protected DirsOnlyFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            if (name.startsWith(".")) {
                return false;
            }
            return new File(dir.toString() + File.separator + name).isDirectory();
        }
    }
}

