/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.properties;

import jal.String.Sorting;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.eso.cpl.Recipe;
import org.eso.cpl.jni.LTDLException;
import org.eso.cpl.jni.LibraryLoader;
import org.eso.cpl.jni.PluginLibrary;
import org.eso.gasgano.keyword.Keyword;
import org.eso.gasgano.properties.GasPropListener;
import org.eso.gasgano.properties.PropertyDB;
import org.eso.gasgano.properties.PropertySource;
import org.eso.gasgano.tools.DirUtils;

public class GasProp
extends Properties
implements PropertySource {
    private static GasProp properties;
    private static int safeEnv;
    public static int periodMin;
    public static int periodMax;
    public static final String UNKNOWN_PROGRAM_ID = "Unknown Program";
    public static final String UNKNOWN_OBSERVATION_ID = "Unknown Observation";
    public static final String UNKNOWN_TELESCOPE_ID = "Unknown Telescope";
    public static final int TREE_DEFAULT = 0;
    public static final int TREE_DIRECTORY = 1;
    public static final int TREE_TELESCOPE = 2;
    public static final String SHOW_EXTENSIONS_KEY = "SHOW_EXTENSIONS";
    public static final String AUTO_DISPLAY_FILE = "AUTO_DISPLAY";
    public static final String KEYWORDLIST_DIR = "gasgano/keywords";
    public static final String SCRIPTS_DIR = "gasgano/scripts";
    public static final String FILTER_FILE = "gasgano/config/filter.rul";
    public static final String CLASSRULE_FILE = "gasgano/config/VLT.oca";
    public static final String PRODUCT_DIR = "";
    public static final String TFITS_TO_VIEWER = "";
    public static final String FITS_TO_VIEWER = "";
    public static final String CUBE_TO_VIEWER = "";
    public static final String TEXTFILE_EXTENSIONS = "ascii;paf;longlog;log";
    public static final String FRAME_BOUNDS = "8,100,920,650";
    public static String VERBOSE_LEVEL;
    public static String PRINT_FONT;
    public static String PRINT_ORIENTATION;
    public static String COMPONENT_FONT;
    public static String DATA_FILES;
    public static String UPDATE_TIMER;
    public static String DISPLAY_COLUMNS;
    public static String DISPLAY_COLUMNS_SIZE;
    public static String OB_STATUS_FROM_DB_REQUIRED;
    public static String OBSTATUS_MAPPING;
    public static String DB_SERVER_URL;
    public static String DB_USER_NAME;
    public static final String RADEC_CONVERSION = "true";
    public static final String SHORT_FILENAME = "true";
    public static final String DBOBS_REQUIRED = "false";
    public static final String DBOBS_SERVER_URL = "";
    public static final String DBOBS_SERVER_ID = "";
    public static final String DBOBS_USERID = "";
    public static final String DBOBS_PERIOD = "66";
    public static final String MENU_CUSTOM1 = "";
    public static final String MENU_CUSTOM2 = "";
    public static final String MENU_CUSTOM3 = "";
    public static final String MENU_CUSTOM4 = "";
    public static final String MENU_CUSTOM1_LBL = "Custom  Menu1";
    public static final String MENU_CUSTOM2_LBL = "Custom  Menu2";
    public static final String MENU_CUSTOM3_LBL = "Custom  Menu3";
    public static final String MENU_CUSTOM4_LBL = "Custom  Menu4";
    public static final String MENU_RETRIEVE = "dpclient  -renameschema ARCFILE -outpath ";
    public static final String DBOBS_INSTRUMENT = "All";
    public static final String INSTRUMENT_GROUPING = "ISAAC=;FORS1=;FORS2=;UVES=;VIMOS=;NAOS+CONICA=;EFOSC=;CES=;SUSI=;SOFI=;EMMI=;WFI=;VINCI=;MIDI=";
    public static String DBOBS_DISPLAY_COLUMNS;
    public static String DBOBS_DISPLAY_COLUMNS_SIZE;
    public static String SHORTEN_FILES_PATH;
    public static String MJD_SORTING;
    public static String SHOW_EXTENSIONS;
    public static String PRINTER_NAME;
    public static String DBOBS_INSTRUMENTS;
    public static final String RECIPE_SET = "RECIPE_SET";
    private static Vector changeListeners;
    private String sourceFile = null;
    private boolean debug = false;
    public Vector obsStatus = new Vector();
    public Vector obsStatusMeaning = new Vector();
    public Vector fsDisplayColumns;
    public Vector fsDisplayColumnsSize;
    public Vector dbDisplayColumns;
    public Vector dbDisplayColumnsSize;
    public Vector dataFiles;
    public Vector textFileExtensions;
    private Map recipeSet;
    public Vector instruments;
    public Vector instrumentGrouping;
    public Vector dbInstruments;

    public GasProp() {
        this.put("KEYWORDLIST_DIR", KEYWORDLIST_DIR);
        this.put("SCRIPTS_DIR", SCRIPTS_DIR);
        this.put("FILTER_FILE", FILTER_FILE);
        this.put("CLASSRULE_FILE", CLASSRULE_FILE);
        this.put("TFITS_TO_VIEWER", "");
        this.put("FITS_TO_VIEWER", "");
        this.put("CUBE_TO_VIEWER", "");
        this.put("TEXTFILE_EXTENSIONS", TEXTFILE_EXTENSIONS);
        this.put("VERBOSE_LEVEL", VERBOSE_LEVEL);
        this.put("DISPLAY_COLUMNS", DISPLAY_COLUMNS);
        this.put("DISPLAY_COLUMNS_SIZE", DISPLAY_COLUMNS_SIZE);
        this.put("OB_STATUS_FROM_DB_REQUIRED", OB_STATUS_FROM_DB_REQUIRED);
        this.put("DB_SERVER_URL", DB_SERVER_URL);
        this.put("DB_USER_NAME", DB_USER_NAME);
        this.put("PRINT_FONT", PRINT_FONT);
        this.put("PRINT_ORIENTATION", PRINT_ORIENTATION);
        this.put("COMPONENT_FONT", COMPONENT_FONT);
        this.put("FRAME_BOUNDS", FRAME_BOUNDS);
        this.put("DATA_FILES", DATA_FILES);
        this.put("RADEC_CONVERSION", "true");
        this.put("SHORT_FILENAME", "true");
        this.put("UPDATE_TIMER", UPDATE_TIMER);
        this.put("DBOBS_REQUIRED", DBOBS_REQUIRED);
        this.put("DBOBS_SERVER_URL", "");
        this.put("DBOBS_SERVER_ID", "");
        this.put("DBOBS_USERID", "");
        this.put("DBOBS_PERIOD", DBOBS_PERIOD);
        this.put("MENU_CUSTOM1", "");
        this.put("MENU_CUSTOM2", "");
        this.put("MENU_CUSTOM3", "");
        this.put("MENU_CUSTOM4", "");
        this.put("MENU_CUSTOM1_LBL", MENU_CUSTOM1_LBL);
        this.put("MENU_CUSTOM2_LBL", MENU_CUSTOM2_LBL);
        this.put("MENU_CUSTOM3_LBL", MENU_CUSTOM3_LBL);
        this.put("MENU_CUSTOM4_LBL", MENU_CUSTOM4_LBL);
        this.put("MENU_RETRIEVE", MENU_RETRIEVE);
        this.put("INSTRUMENT_GROUPING", INSTRUMENT_GROUPING);
        this.put("DBOBS_INSTRUMENT", DBOBS_INSTRUMENT);
        this.put("DBOBS_DISPLAY_COLUMNS", DBOBS_DISPLAY_COLUMNS);
        this.put("DBOBS_DISPLAY_COLUMNS_SIZE", DBOBS_DISPLAY_COLUMNS_SIZE);
        this.put("SHORTEN_FILES_PATH", SHORTEN_FILES_PATH);
        this.put("MJD_SORTING", MJD_SORTING);
        this.put(SHOW_EXTENSIONS_KEY, SHOW_EXTENSIONS);
        this.put("PRINTER_NAME", PRINTER_NAME);
        this.put("OBSTATUS_MAPPING", OBSTATUS_MAPPING);
        this.put("DBOBS_INSTRUMENTS", DBOBS_INSTRUMENTS);
        this.put(AUTO_DISPLAY_FILE, DBOBS_REQUIRED);
        this.buildVectors();
    }

    public GasProp(String filePath) {
        this();
        this.loadProperties(filePath);
    }

    public GasProp(GasProp gp) {
        this.copyFrom(gp);
    }

    public void copyFrom(GasProp source) {
        this.sourceFile = source.sourceFile;
        this.debug = source.debug;
        this.clear();
        Enumeration<?> e2 = source.propertyNames();
        while (e2.hasMoreElements()) {
            String p = new String((String)e2.nextElement());
            this.put(p, new String(source.getProperty(p)));
        }
        this.buildVectors();
        this.fsDisplayColumnsSize = (Vector)source.fsDisplayColumnsSize.clone();
        this.dbDisplayColumnsSize = (Vector)source.dbDisplayColumnsSize.clone();
    }

    public static Vector stringScanner(String property, char sep) {
        if (property == null) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        int i = 0;
        while (i < property.length()) {
            int colonpos = property.indexOf(sep, i);
            if (colonpos == -1) {
                colonpos = property.length();
            }
            v.addElement(property.substring(i, colonpos).trim());
            i = colonpos + 1;
        }
        return v;
    }

    public static String stringBuilder(Vector property, char sep) {
        StringBuffer sb = new StringBuffer("");
        if (property == null) {
            return sb.toString();
        }
        for (int i = 0; i < property.size(); ++i) {
            sb.append(property.elementAt(i).toString());
            if (i == property.size() - 1) continue;
            sb.append(String.valueOf(sep));
        }
        return sb.toString();
    }

    public boolean loadProperties(String filePath) {
        boolean debug = false;
        FileInputStream fileStream = null;
        this.sourceFile = filePath;
        try {
            fileStream = new FileInputStream(filePath);
            this.load(fileStream);
        }
        catch (IOException ioe) {
            return false;
        }
        if (this.getProperty("FRAME_BOUNDS") == null) {
            this.put("FRAME_BOUNDS", FRAME_BOUNDS);
        }
        Enumeration<?> e2 = this.propertyNames();
        while (e2.hasMoreElements()) {
            String p = new String((String)e2.nextElement());
        }
        String period = this.getProperty("DBOBS_PERIOD");
        try {
            if (!(period.equals(DBOBS_INSTRUMENT) || periodMin < Integer.parseInt(period) && Integer.parseInt(period) < periodMax)) {
                this.put("DBOBS_PERIOD", String.valueOf(periodMin));
            }
        }
        catch (NumberFormatException nfe) {
            this.put("DBOBS_PERIOD", String.valueOf(periodMin));
        }
        this.buildVectors();
        return true;
    }

    private void buildVectors() {
        int i;
        this.instrumentGrouping = null;
        this.obsStatus = new Vector();
        this.obsStatusMeaning = new Vector();
        this.fsDisplayColumns = null;
        this.fsDisplayColumnsSize = null;
        this.dbDisplayColumns = null;
        this.dataFiles = null;
        this.textFileExtensions = null;
        this.recipeSet = new HashMap();
        String prop = null;
        if (this.getProperty("OBSTATUS_MAPPING") != null && !this.getProperty("OBSTATUS_MAPPING").equals("")) {
            int colonpos;
            int i2;
            prop = new String(this.getProperty("OBSTATUS_MAPPING"));
            char curr = prop.charAt(0);
            for (i2 = 0; i2 < prop.length() && (colonpos = prop.indexOf(":", i2)) != 0; ++i2) {
                int colonpos2 = prop.indexOf(":", colonpos + 1);
                if (colonpos2 == -1) {
                    colonpos2 = prop.length() + 1;
                }
                this.obsStatus.addElement(new Character(prop.charAt(colonpos - 1)));
                this.obsStatusMeaning.addElement(prop.substring(colonpos + 1, colonpos2 - 2));
                i2 = colonpos2 - 1;
            }
            if (this.debug) {
                for (i2 = 0; i2 < this.obsStatus.size(); ++i2) {
                    System.out.println(this.obsStatus.elementAt(i2).toString() + "+" + this.obsStatusMeaning.elementAt(i2).toString());
                }
            }
        }
        if (this.getProperty("DATA_FILES") != null) {
            prop = this.getProperty("DATA_FILES");
            this.dataFiles = GasProp.stringScanner(prop, ';');
        }
        prop = this.getProperty("DISPLAY_COLUMNS");
        this.fsDisplayColumns = GasProp.stringScanner(prop, ':');
        prop = this.getProperty("DISPLAY_COLUMNS_SIZE");
        this.fsDisplayColumnsSize = GasProp.stringScanner(prop, ':');
        if (this.fsDisplayColumnsSize.size() != this.fsDisplayColumns.size()) {
            if (this.debug) {
                System.out.println("Extending the Size vector to " + this.fsDisplayColumns.size());
            }
            this.fsDisplayColumnsSize = new Vector();
            for (i = 0; i < this.fsDisplayColumns.size(); ++i) {
                this.fsDisplayColumnsSize.addElement(new Integer(0));
            }
        }
        prop = this.getProperty("DBOBS_DISPLAY_COLUMNS");
        this.dbDisplayColumns = GasProp.stringScanner(prop, ':');
        prop = this.getProperty("DBOBS_DISPLAY_COLUMNS_SIZE");
        this.dbDisplayColumnsSize = GasProp.stringScanner(prop, ':');
        if (this.dbDisplayColumnsSize.size() != this.dbDisplayColumns.size()) {
            System.out.println("Extending the Size vector to " + this.dbDisplayColumns.size());
            this.dbDisplayColumnsSize = new Vector(this.dbDisplayColumns.size());
            for (i = 0; i < this.dbDisplayColumns.size(); ++i) {
                this.dbDisplayColumnsSize.setElementAt(new Integer(0), i);
            }
        }
        prop = this.getProperty("TEXTFILE_EXTENSIONS");
        this.textFileExtensions = GasProp.stringScanner(prop, ';');
        prop = this.getProperty(RECIPE_SET);
        if (prop != null) {
            Vector librarySet = GasProp.stringScanner(prop, ';');
            LibraryLoader libLoader = null;
            try {
                libLoader = new LibraryLoader();
            }
            catch (LTDLException e1) {
                System.out.println("Cannot create library loader (reason: " + e1.getMessage() + "). It will not be possible to " + "verify any of the recipes listed in the " + "configuration file.");
            }
            for (int i3 = 0; i3 < librarySet.size(); ++i3) {
                String tmpString = (String)librarySet.get(i3);
                int equalIndex = tmpString.indexOf(61);
                if (equalIndex == -1) continue;
                String libName = tmpString.substring(equalIndex + 1, tmpString.length());
                String recipeName = tmpString.substring(0, equalIndex);
                if (libLoader != null) {
                    try {
                        PluginLibrary pluginLib = libLoader.getLibrary(libName);
                        boolean verified = false;
                        for (Recipe recipe : pluginLib.getRecipes()) {
                            if (!recipeName.equals(recipe.getName())) continue;
                            if (this.debug) {
                                System.out.println("Recipe " + recipeName + " found and successfully verified.");
                            }
                            verified = true;
                            break;
                        }
                        if (!verified) {
                            System.out.println("Recipe " + recipeName + " not found. Any attempt to load " + "the recipe will generate an error.");
                        }
                    }
                    catch (Exception e2) {
                        System.out.println("Cannot verify recipe " + recipeName + ". Reason: " + e2.getMessage());
                    }
                }
                this.recipeSet.put(DirUtils.convertAbsoluteDir(libName), tmpString.substring(0, equalIndex));
            }
        }
        prop = this.getProperty("INSTRUMENT_GROUPING");
        this.instrumentGrouping = GasProp.stringScanner(prop, ';');
        this.instruments = new Vector();
        for (i = 0; i < this.instrumentGrouping.size(); ++i) {
            String tmpString = (String)this.instrumentGrouping.elementAt(i);
            int equalIndex = tmpString.indexOf(61);
            if (equalIndex == -1) {
                this.instrumentGrouping.removeElementAt(i);
                continue;
            }
            String inst = tmpString.substring(0, equalIndex);
            if (this.instruments.contains(inst)) {
                this.instrumentGrouping.removeElementAt(i);
                continue;
            }
            this.instruments.addElement(inst);
            this.instrumentGrouping.setElementAt(tmpString.substring(equalIndex + 1, tmpString.length()), i);
        }
        prop = this.getProperty("DBOBS_INSTRUMENTS");
        this.dbInstruments = GasProp.stringScanner(prop, ';');
    }

    public void dumpVectors() {
        int i;
        boolean debug = false;
        StringBuffer t = new StringBuffer("");
        for (i = 0; i < this.obsStatus.size(); ++i) {
            t.append(this.obsStatus.elementAt(i).toString() + ":" + this.obsStatusMeaning.elementAt(i).toString() + " ");
        }
        if (debug) {
            System.out.println(t);
        }
        this.put("OBSTATUS_MAPPING", t.toString());
        this.put("DISPLAY_COLUMNS", GasProp.stringBuilder(this.fsDisplayColumns, ':'));
        this.put("DBOBS_DISPLAY_COLUMNS", GasProp.stringBuilder(this.dbDisplayColumns, ':'));
        this.put("DISPLAY_COLUMNS_SIZE", GasProp.stringBuilder(this.fsDisplayColumnsSize, ':'));
        this.put("DBOBS_DISPLAY_COLUMNS_SIZE", GasProp.stringBuilder(this.dbDisplayColumnsSize, ':'));
        t = new StringBuffer("");
        for (i = 0; i < this.instruments.size(); ++i) {
            t.append(this.instruments.elementAt(i) + "=" + this.instrumentGrouping.elementAt(i) + ";");
        }
        this.put("INSTRUMENT_GROUPING", t.toString());
        this.put("DBOBS_INSTRUMENTS", GasProp.stringBuilder(this.dbInstruments, ';'));
    }

    public boolean saveProperties() {
        return this.saveProperties(this.sourceFile);
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public boolean saveProperties(String filePath) {
        Vector tmpVect = new Vector();
        Object[] tmpArray = null;
        FileWriter fileOutputStream = null;
        this.sourceFile = filePath;
        if (filePath == null) {
            return false;
        }
        this.dumpVectors();
        Enumeration<?> e2 = this.propertyNames();
        while (e2.hasMoreElements()) {
            tmpVect.addElement(e2.nextElement());
        }
        tmpArray = new String[tmpVect.size()];
        tmpVect.copyInto(tmpArray);
        Sorting.sort((String[])tmpArray, 0, tmpArray.length);
        try {
            fileOutputStream = new FileWriter(filePath);
            String header = "# Gasgano Application Properties \n# Date: " + new Date() + "\n";
            fileOutputStream.write(header, 0, header.length());
            for (int i = 0; i < tmpArray.length; ++i) {
                String value = GasProp.escape((String)this.get(tmpArray[i]));
                String line = (String)tmpArray[i] + "=" + value + "\n";
                fileOutputStream.write(line, 0, line.length());
            }
            fileOutputStream.close();
            return true;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public static void addChangeListener(GasPropListener l) {
        changeListeners.add(l);
    }

    public static void removeChangeListener(GasPropListener l) {
        changeListeners.remove(l);
    }

    private static void notifyListeners(boolean dataModelChange) {
        for (int i = 0; i < changeListeners.size(); ++i) {
            ((GasPropListener)changeListeners.elementAt(i)).newProperties(dataModelChange);
        }
    }

    public static void setProperties(GasProp prop) {
        GasProp.setProperties(prop, false);
    }

    public static void setProperties(GasProp prop, boolean dataModelChange) {
        properties = prop;
        if (dataModelChange) {
            properties.buildVectors();
        }
        PropertyDB.getInstance().setPropertySource(properties);
        GasProp.notifyListeners(dataModelChange);
    }

    public static GasProp getProperties() {
        return properties;
    }

    public static void setEnvironmentUnsafe() {
        if (safeEnv == -1) {
            safeEnv = 0;
        }
    }

    public static boolean isEnvironmentSafe() {
        boolean rc;
        boolean bl = rc = safeEnv != 0;
        if (safeEnv == -1) {
            Class<?> t;
            safeEnv = 1;
            try {
                t = Class.forName("org.eso.gasgano.datamodel.OBStatusDictionary");
            }
            catch (Exception cnfe) {
                safeEnv = 0;
                GasProp.getProperties().put("OB_STATUS_FROM_DB_REQUIRED", DBOBS_REQUIRED);
            }
            try {
                t = Class.forName("org.eso.gasgano.datamodel.database.DBDataModel");
            }
            catch (Exception cnfe) {
                safeEnv = 0;
                GasProp.getProperties().put("DBOBS_REQUIRED", DBOBS_REQUIRED);
            }
            boolean bl2 = rc = safeEnv != 0;
            if (rc) {
                System.out.println("Gasgano running in 'safe' environment.");
            }
        }
        return rc;
    }

    public static void columnSizeChanged(int code, String columnName, int newSize) {
        Vector displayCols;
        Vector columnSize = null;
        int pos = 0;
        if (code == 0) {
            displayCols = GasProp.getProperties().fsDisplayColumns;
            columnSize = GasProp.getProperties().fsDisplayColumnsSize;
        } else if (code == 1) {
            displayCols = GasProp.getProperties().dbDisplayColumns;
            columnSize = GasProp.getProperties().dbDisplayColumnsSize;
        } else {
            System.out.println("gasgano internal error in Application::columnSizeChanged");
            return;
        }
        pos = displayCols.indexOf(columnName);
        if (pos != -1) {
            Integer nSize = new Integer(newSize);
            columnSize.setElementAt(nSize, pos);
        } else {
            System.out.println("gasgano internal error: " + columnName + " is not in the displayed keywords preferences");
        }
    }

    public Keyword[] getInstrumentGrouping(String instrument) {
        String tmpString;
        Keyword[] rc = null;
        int instIdx = this.instruments.indexOf(instrument);
        if (instIdx != -1 && (tmpString = (String)this.instrumentGrouping.elementAt(instIdx)).length() > 0) {
            String[] kwords = tmpString.split(",");
            ArrayList<Keyword> kwVec = new ArrayList<Keyword>();
            for (int i = 0; i < kwords.length; ++i) {
                String kw = kwords[i].trim();
                if (kw.length() <= 0) continue;
                kwVec.add(new Keyword(kw, "null"));
            }
            rc = new Keyword[kwVec.size()];
            kwVec.toArray(rc);
        }
        return rc;
    }

    public boolean hasInstrumentGrouping(String instrument) {
        return this.instruments.indexOf(instrument) != -1;
    }

    private static String escape(String value) {
        StringBuffer escapedValue = new StringBuffer();
        if (value != null) {
            for (int i = 0; i < value.length(); ++i) {
                if (value.charAt(i) == '\\') {
                    escapedValue.append('\\');
                }
                escapedValue.append(value.charAt(i));
            }
        }
        return escapedValue.toString();
    }

    public Iterator getRecipeLibraryNames() {
        return this.recipeSet.keySet().iterator();
    }

    public List getRecipesForLibrary(String libName) {
        String recipeList = (String)this.recipeSet.get(libName);
        Vector rc = recipeList != null ? GasProp.stringScanner(recipeList, ',') : null;
        return rc;
    }

    static {
        safeEnv = -1;
        periodMin = 63;
        periodMax = 80;
        VERBOSE_LEVEL = "0";
        PRINT_FONT = "Monospaced:16";
        PRINT_ORIENTATION = "P";
        COMPONENT_FONT = "Dialog:14";
        DATA_FILES = "";
        UPDATE_TIMER = "0";
        DISPLAY_COLUMNS = "CLASSIFICATION:TPL.ID:ORIGFILE:TPL.EXPNO:TPL.NEXP";
        DISPLAY_COLUMNS_SIZE = "0:0:0:0:0";
        OB_STATUS_FROM_DB_REQUIRED = DBOBS_REQUIRED;
        OBSTATUS_MAPPING = "P:Partially defined D:Defined Q:queued for scheduling I:Initiated S:Started p:Paused during execution A:Aborted X:Executed R:Reduced C:Completed L:released K:Cancelled ";
        DB_SERVER_URL = "";
        DB_USER_NAME = "qc";
        DBOBS_DISPLAY_COLUMNS = "CLASSIFICATION:RA:DEC:TPL.EXPNO:TPL.NEXP";
        DBOBS_DISPLAY_COLUMNS_SIZE = "0:0:0:0:0";
        SHORTEN_FILES_PATH = "true";
        MJD_SORTING = DBOBS_REQUIRED;
        SHOW_EXTENSIONS = "true";
        PRINTER_NAME = "lp";
        DBOBS_INSTRUMENTS = "ISAAC;FORS1;FORS2;UVES;VIMOS;CONICA;EFOSC;CES;SUSI;SOFI;EMMI;WFI;VINCI;MIDI";
        changeListeners = new Vector();
    }
}

