/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.properties;

import org.eso.gasgano.keyword.Keyword;
import org.eso.gasgano.properties.GasProp;
import org.eso.gasgano.properties.PropertyTableModel;

public class InstGroupTableModel
extends PropertyTableModel {
    private GasProp gpx = null;
    private String[] menuLabels = new String[4];
    private String[] menuCommands = new String[4];
    private Boolean[] numbering = null;

    public InstGroupTableModel(GasProp gp) {
        this.loadProperties(gp);
    }

    public void loadProperties(GasProp gp) {
        this.gpx = gp;
        if (this.gpx.instruments.size() == 0) {
            this.insertRow(0);
        }
        this.numbering = new Boolean[this.gpx.instruments.size()];
        for (int i = 0; i < gp.instruments.size(); ++i) {
            this.numbering[i] = new Boolean(false);
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.gpx.instruments.size();
    }

    public int getColumnWidth(int column) {
        if (column == 0 || column == 2) {
            return 20;
        }
        return 50;
    }

    @Override
    public Object getValueAt(int row, int col) {
        Boolean rc = null;
        if (col == 0) {
            rc = (Boolean)this.gpx.instruments.elementAt(row);
        }
        if (col == 1) {
            rc = (Boolean)this.gpx.instrumentGrouping.elementAt(row);
        }
        if (col == 2) {
            rc = this.numbering[row];
        }
        return rc;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col != 2 || !this.gpx.instrumentGrouping.elementAt(row).equals("");
    }

    @Override
    public String getColumnName(int column) {
        String rc = null;
        if (column == 0) {
            rc = "instrument";
        }
        if (column == 1) {
            rc = "keyword(s) defining group";
        }
        if (column == 2) {
            rc = "auto-num.";
        }
        return rc;
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        switch (column) {
            case 0: {
                this.gpx.instruments.setElementAt(aValue, row);
                break;
            }
            case 1: {
                String val = (String)aValue;
                val = val.replace(';', ',');
                String[] kwords = val.split(",");
                boolean valid = true;
                for (int i = 0; valid && i < kwords.length; ++i) {
                    String kw = kwords[i].trim();
                    if (kw.length() <= 0) continue;
                    valid = Keyword.validName(kw);
                }
                if (!valid) break;
                this.gpx.instrumentGrouping.setElementAt(val, row);
                break;
            }
            case 2: {
                this.numbering[row] = (Boolean)aValue;
            }
        }
    }

    public Class getColumnClass(int col) {
        Class cl = null;
        switch (col) {
            case 0: {
                cl = String.class;
                break;
            }
            case 1: {
                cl = String.class;
                break;
            }
            case 2: {
                cl = Boolean.class;
            }
        }
        return cl;
    }

    @Override
    public void removeRow(int rowNum) {
        block2: {
            try {
                this.gpx.instruments.removeElementAt(rowNum);
                this.gpx.instrumentGrouping.removeElementAt(rowNum);
                this.fireTableStructureChanged();
            }
            catch (ArrayIndexOutOfBoundsException e2) {
                if (!this.isDebug()) break block2;
                System.out.println("GasPropEditor: array out of bound");
            }
        }
    }

    @Override
    public void insertRow(int rowNum) {
        block2: {
            try {
                this.gpx.instruments.insertElementAt("", rowNum);
                this.gpx.instrumentGrouping.insertElementAt("", rowNum);
                this.fireTableStructureChanged();
            }
            catch (ArrayIndexOutOfBoundsException e2) {
                if (!this.isDebug()) break block2;
                System.out.println("GasPropEditor: array out of bound");
            }
        }
    }

    public Boolean[] getNumbering() {
        return this.numbering;
    }

    public void setNumbering(Boolean[] numbering) {
        this.numbering = numbering;
    }

    public static void main(String[] args) {
        int i;
        String t1 = "1,2,3,456,7";
        System.out.println("\n<<<" + t1 + ">>>\n");
        String[] split = t1.split(",");
        for (i = 0; i < split.length; ++i) {
            System.out.println("<" + split[i] + ">");
        }
        t1 = "1, 2, 3  , 456 ,7";
        System.out.println("\n<<<" + t1 + ">>>\n");
        split = t1.split(",");
        for (i = 0; i < split.length; ++i) {
            System.out.println("<" + split[i] + ">");
        }
        t1 = "1,,t2,  ,t3,t456,7,";
        System.out.println("\n<<<" + t1 + ">>>\n");
        split = t1.split(",");
        for (i = 0; i < split.length; ++i) {
            System.out.println("<" + split[i] + ">");
        }
        t1 = "1";
        System.out.println("\n<<<" + t1 + ">>>\n");
        split = t1.split(",");
        for (i = 0; i < split.length; ++i) {
            System.out.println("<" + split[i] + ">");
        }
        t1 = ",";
        System.out.println("\n<<<" + t1 + ">>>\n");
        split = t1.split(",");
        for (i = 0; i < split.length; ++i) {
            System.out.println("<" + split[i] + ">");
        }
        t1 = "";
        System.out.println("\n<<<" + t1 + ">>>\n");
        split = t1.split(",");
        for (i = 0; i < split.length; ++i) {
            System.out.println("<" + split[i] + ">");
        }
    }
}

