/*
 * Decompiled with CFR 0.152.
 */
package org.eso.oca.backend;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.eso.oca.backend.ABVisitor;
import org.eso.oca.backend.ABVisitorException;
import org.eso.oca.backend.AssociationBlock;
import org.eso.oca.fits.OCAFile;

public class ABFileWriter
implements ABVisitor {
    private String dir;
    private static Map<String, Integer> currentAbIndex = new HashMap<String, Integer>();
    static final String SEPARATOR = "\t";
    static final String EOL = System.getProperty("line.separator");
    static final String UNDEFINED = "UNDEFINED";
    static final String NONE = "NONE";
    static final String RB_CONTENT = "RB_CONTENT";
    static final String SOF_CONTENT = "SOF_CONTENT";
    static final String RAWFILE = "RAWFILE";
    static final String RASSOC = "RASSOC";
    static final String MASSOC = "MASSOC";
    static final String MCALIB = "MCALIB";
    static Logger logger = Logger.getLogger(ABFileWriter.class);

    public ABFileWriter(String dir) {
        if (dir == null) {
            throw new IllegalArgumentException("null AB dir");
        }
        this.dir = dir;
    }

    @Override
    public void visit(AssociationBlock ab) throws ABVisitorException {
        try {
            BigDecimal modifiedMjdObs;
            BigDecimal mjdObs;
            String obsId;
            String obsProgId;
            String packDir;
            String rawType;
            String dprCatg;
            String instrume;
            OCAFile abExemplar = ab.getExemplar();
            String abEvent = ab.getGroupEvent();
            if (abEvent == null) {
                abEvent = "SINGLE";
            }
            String abRootName = ab.getABName();
            String osname = System.getProperty("os.name");
            if (osname.indexOf("Windows") >= 0) {
                abRootName = abRootName.replace(':', '_');
            }
            File abFile = this.createUniqueFile(abRootName);
            FileWriter out = new FileWriter(abFile);
            try {
                instrume = ab.getInstrument();
            }
            catch (Exception e3) {
                instrume = UNDEFINED;
            }
            String dfoDate = System.getProperty("DFO_DATE");
            String abDate = dfoDate == null ? NONE : dfoDate;
            String configVersion = System.getProperty("CONFIG_VERSION");
            String toolVersion = System.getProperty("VERSION");
            out.write("# general information" + EOL);
            out.write("TOOL_VERSION\t" + toolVersion + EOL);
            out.write("CONFIG_VERSION\t" + configVersion + EOL);
            out.write("INSTRUMENT\t" + instrume + EOL);
            out.write("DATE\t\t" + abDate + EOL);
            out.write(EOL);
            try {
                dprCatg = abExemplar.getDprCatg();
            }
            catch (Exception e4) {
                dprCatg = NONE;
            }
            try {
                rawType = abExemplar.getRawType();
            }
            catch (Exception e5) {
                rawType = NONE;
            }
            try {
                packDir = abExemplar.getPackDir();
            }
            catch (Exception e5) {
                packDir = NONE;
            }
            out.write("DPR_CATG\t" + dprCatg + EOL);
            out.write("RAW_TYPE\t" + rawType + EOL);
            out.write("RECIPE\t\t" + ab.getRecipe() + EOL);
            out.write("DRS_TYPE\t" + System.getProperty("DRS_TYPE") + EOL);
            out.write("PACK_DIR\t" + packDir + EOL);
            out.write(EOL);
            out.write("AB_NAME\t\t" + abFile.getName() + EOL);
            out.write("AB_EVENT\t" + abEvent + EOL);
            out.write("COMPLETENESS\t" + (ab.isValid() ? "" : "IN") + "COMPLETE" + EOL);
            out.write("PROCESS_STATUS\tCREATED" + EOL);
            out.write(EOL);
            try {
                obsProgId = abExemplar.getKeywordValue("OBS.PROG.ID");
            }
            catch (Exception e6) {
                obsProgId = UNDEFINED;
            }
            try {
                obsId = abExemplar.getKeywordValue("OBS.ID");
            }
            catch (Exception e7) {
                obsId = UNDEFINED;
            }
            out.write("OBS_PROG_ID\t" + obsProgId + EOL);
            out.write("OBS_ID\t\t" + obsId + EOL);
            out.write(EOL);
            try {
                mjdObs = abExemplar.getMjdObs();
            }
            catch (Exception e8) {
                mjdObs = new BigDecimal(0.0);
            }
            try {
                modifiedMjdObs = ab.getModifiedMjdObs();
            }
            catch (Exception e9) {
                modifiedMjdObs = new BigDecimal(0.0);
            }
            out.write("MJD-OBS\t\t" + mjdObs.setScale(8, 6) + EOL);
            out.write("MJD-OBS_MOD\t" + modifiedMjdObs.setScale(8, 6) + EOL);
            out.write(EOL);
            String prodRootName = "r." + abRootName;
            out.write("PROD_ROOT_NAME\t" + prodRootName + EOL);
            out.write(EOL);
            out.write("RB_NAME\t\tNONE" + EOL);
            out.write("LOG_NAME\tNONE" + EOL);
            out.write(EOL);
            String prodDate = dfoDate == null ? "" : dfoDate;
            String prodRoot = ab.getProductDir();
            String prodPath = prodRoot + File.separator + rawType + File.separator + prodDate;
            out.write("PROD_PATH\t" + prodPath + EOL);
            out.write(EOL);
            out.write("# raw match key" + EOL);
            String[] matchKeys = ab.getMatchKeywords();
            if (matchKeys.length == 0) {
                out.write("RAW_MATCH_KEY\tNONE" + EOL);
            }
            for (int i = 0; i < matchKeys.length; ++i) {
                String matchVal;
                String matchKey = matchKeys[i];
                try {
                    matchVal = abExemplar.getKeywordValue(matchKey);
                }
                catch (Exception e11) {
                    matchVal = UNDEFINED;
                }
                out.write("RAW_MATCH_KEY\t" + matchKey + "=" + matchVal + EOL);
            }
            out.write(EOL);
            StringBuffer rawFileBuffer = new StringBuffer();
            StringBuffer rassocBuffer = new StringBuffer();
            StringBuffer rbRawBuffer = new StringBuffer();
            StringBuffer rbCalibBuffer = new StringBuffer();
            StringBuffer sofBuffer = new StringBuffer();
            OCAFile[] rawFiles = ab.getInputFiles();
            for (int i = 0; i < rawFiles.length; ++i) {
                String doClass;
                String rawFilename;
                try {
                    rawFilename = rawFiles[i].getFilename();
                }
                catch (Exception e11) {
                    rawFilename = UNDEFINED;
                }
                try {
                    doClass = rawFiles[i].getDoClass();
                }
                catch (Exception e12) {
                    doClass = UNDEFINED;
                }
                sofBuffer.append("SOF_CONTENT\t" + rawFilename + " " + doClass + " RAW" + EOL);
                rawFileBuffer.append("RAWFILE\t\t" + rawFilename + SEPARATOR + doClass + EOL);
                rbRawBuffer.append("RB_CONTENT\t" + rawFilename + " " + doClass + EOL);
            }
            OCAFile[] calibFiles = ab.getAssociatedFiles();
            StringBuffer mcalibBuffer = new StringBuffer();
            StringBuffer massocBuffer = new StringBuffer();
            TreeSet<String> virtualABs = new TreeSet<String>();
            for (int i = 0; i < calibFiles.length; ++i) {
                String calibABName;
                String calibPipefile;
                String calibRawType;
                String calibProCatg;
                String calibDoClass;
                String qcCalibFilename;
                try {
                    qcCalibFilename = calibFiles[i].getFilename();
                }
                catch (Exception e11) {
                    qcCalibFilename = UNDEFINED;
                }
                try {
                    calibDoClass = calibFiles[i].getDoClass();
                }
                catch (Exception e12) {
                    calibDoClass = UNDEFINED;
                }
                try {
                    calibProCatg = calibFiles[i].getProCatg();
                }
                catch (Exception e12) {
                    calibProCatg = UNDEFINED;
                }
                try {
                    calibRawType = calibFiles[i].getRawType();
                }
                catch (Exception e12) {
                    calibRawType = UNDEFINED;
                }
                try {
                    calibPipefile = calibFiles[i].getPipefile();
                }
                catch (Exception e12) {
                    calibPipefile = UNDEFINED;
                }
                try {
                    calibABName = calibFiles[i].getABName();
                    if (calibFiles[i].isVirtual()) {
                        virtualABs.add(calibABName);
                    }
                }
                catch (Exception e12) {
                    calibABName = UNDEFINED;
                }
                BigDecimal deltaT = null;
                try {
                    deltaT = ab.getModifiedMjdObs().subtract(calibFiles[i].getMjdObs());
                }
                catch (Exception e2) {
                    deltaT = new BigDecimal(-9999.0);
                }
                String realOrVirtual = "REAL";
                if (calibFiles[i].isVirtual()) {
                    String calibDate;
                    realOrVirtual = "VIRTUAL";
                    try {
                        calibDate = calibFiles[i].getDate();
                    }
                    catch (Exception e12) {
                        calibDate = UNDEFINED;
                    }
                    qcCalibFilename = ab.getProductDir() + File.separator + calibRawType + File.separator + calibDate + File.separator + calibPipefile;
                }
                boolean isMassoc = false;
                boolean isRassoc = false;
                try {
                    isMassoc = calibFiles[i].getAlias().toUpperCase().indexOf(MASSOC) > 0;
                }
                catch (Exception e13) {
                    // empty catch block
                }
                try {
                    isRassoc = calibFiles[i].getAlias().toUpperCase().indexOf(RASSOC) > 0;
                }
                catch (Exception e13) {
                    // empty catch block
                }
                if (isRassoc) {
                    rassocBuffer.append("RASSOC\t\t" + qcCalibFilename + SEPARATOR + calibDoClass + EOL);
                    continue;
                }
                if (isMassoc) {
                    massocBuffer.append("MASSOC\t\t" + realOrVirtual + SEPARATOR + qcCalibFilename + SEPARATOR + calibProCatg + SEPARATOR + calibABName + SEPARATOR + deltaT.setScale(3, 6) + EOL);
                    continue;
                }
                rbCalibBuffer.append("RB_CONTENT\t" + qcCalibFilename + " " + calibProCatg + EOL);
                sofBuffer.append("SOF_CONTENT\t" + qcCalibFilename + " " + calibProCatg + " CALIB" + EOL);
                mcalibBuffer.append("MCALIB\t\t" + realOrVirtual + SEPARATOR + qcCalibFilename + SEPARATOR + calibProCatg + SEPARATOR + calibABName + SEPARATOR + deltaT.setScale(3, 6) + EOL);
            }
            out.write("# input file(s)" + EOL);
            if (rawFileBuffer.length() == 0) {
                out.write("RAWFILE\t\tNONE" + EOL);
            } else {
                out.write(rawFileBuffer.toString());
            }
            out.write(EOL);
            out.write("# associated raw file(s) (only for SCIENCE; taken from same night only!)" + EOL);
            if (rassocBuffer.length() == 0) {
                out.write("RASSOC\t\tNONE" + EOL);
            } else {
                out.write(rassocBuffer.toString());
            }
            out.write(EOL);
            out.write("# product file(s)" + EOL);
            out.write("PRODUCTS\tNONE\tNONE" + EOL);
            out.write(EOL);
            out.write("# associated mcalib file(s), used for processing" + EOL);
            if (mcalibBuffer.length() == 0) {
                out.write("MCALIB\t\tNONE" + EOL);
            } else {
                out.write(mcalibBuffer.toString());
            }
            out.write(EOL);
            out.write("# associated mcalib file(s), used for packing" + EOL);
            if (massocBuffer.length() == 0) {
                out.write("MASSOC\t\tNONE" + EOL);
            } else {
                out.write(massocBuffer.toString());
            }
            out.write(EOL);
            String[] params = ab.getRecipeParams();
            out.write("# parameters for processing" + EOL);
            if (params.length == 0) {
                out.write("PARAM\t\tNONE" + EOL);
            } else {
                for (int i = 0; i < params.length; ++i) {
                    out.write("PARAM\t\t" + params[i] + EOL);
                }
            }
            out.write(EOL);
            out.write("# defined waitfors (for CONDOR)" + EOL);
            if (virtualABs.size() == 0) {
                out.write("WAITFOR\t\tNONE" + EOL);
            } else {
                Iterator it = virtualABs.iterator();
                while (it.hasNext()) {
                    out.write("WAITFOR\t\t" + it.next() + EOL);
                }
            }
            out.write(EOL);
            out.write("# associated QC1 parameters are stored in the following QC1 database table" + EOL);
            out.write("QC1_DB\t\tNONE" + EOL);
            out.write(EOL);
            out.write("# further associated information" + EOL);
            String packAdd = System.getProperty("PACK_ADD");
            String[] packAddArr = null;
            if (packAdd != null) {
                packAddArr = packAdd.split(" ");
            }
            if (packAddArr == null) {
                out.write("FURTHER\tNONE" + EOL);
            } else {
                for (int i = 0; i < packAddArr.length; ++i) {
                    out.write("FURTHER_" + packAddArr[i] + SEPARATOR + NONE + EOL);
                }
            }
            out.write(EOL);
            String username = System.getProperty("user.name");
            String hostname = InetAddress.getLocalHost().getHostName();
            Date now = new Date(Calendar.getInstance().getTimeInMillis());
            String nowAsString = now.toLocaleString();
            String createdStatus = "created by '" + toolVersion + "' on " + nowAsString + " by " + username + " on " + hostname;
            out.write("# status of AB" + EOL);
            out.write("TEXEC\t\tNONE" + EOL);
            out.write("AB_STATUS\t" + createdStatus + EOL);
            out.write(EOL);
            out.write("# ========== RB section starts here ==========" + EOL);
            String prodName = prodPath + File.separator + prodRootName;
            out.write("RB_CONTENT\trecipe: " + ab.getRecipe() + EOL);
            out.write(RB_CONTENT + EOL);
            out.write("RB_CONTENT\tinstrument: " + instrume + EOL);
            out.write(RB_CONTENT + EOL);
            out.write("RB_CONTENT\t" + prodName + EOL);
            out.write(RB_CONTENT + EOL);
            out.write("RB_CONTENT\t{" + EOL);
            out.write(rbRawBuffer.toString());
            out.write("RB_CONTENT\t}" + EOL);
            out.write(RB_CONTENT + EOL);
            out.write("RB_CONTENT\t{" + EOL);
            out.write(rbCalibBuffer.toString());
            out.write("RB_CONTENT\t}" + EOL);
            out.write(RB_CONTENT + EOL);
            for (int i = 0; i < params.length; ++i) {
                out.write("RB_CONTENT\t" + params[i] + EOL);
            }
            out.write(RB_CONTENT + EOL);
            out.write(EOL);
            out.write("# ========== SOF section starts here ==========" + EOL);
            out.write(sofBuffer.toString());
            out.write(EOL);
            out.close();
        }
        catch (IOException e3) {
            throw new ABVisitorException(e3);
        }
    }

    private File createUniqueFile(String abRootName) throws ABVisitorException {
        String abFilename = null;
        DecimalFormat df = new DecimalFormat("0000");
        abFilename = this.dir + File.separator + abRootName;
        Integer counter = currentAbIndex.get(abRootName);
        if (counter == null) {
            currentAbIndex.put(abRootName, 0);
        } else {
            Integer n = counter;
            Integer n2 = counter = Integer.valueOf(counter + 1);
            if (counter == 10000) {
                throw new ABVisitorException("Maximum numer of ABs reached for AB root " + abRootName);
            }
            abFilename = abFilename + "_" + df.format(counter);
            abFilename = abFilename + ".ab";
            currentAbIndex.put(abRootName, counter);
        }
        return new File(abFilename.toString());
    }
}

