/*
 * Decompiled with CFR 0.152.
 */
package org.eso.oca.backend;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eso.oca.backend.ABVisitor;
import org.eso.oca.backend.ABVisitorException;
import org.eso.oca.backend.SelectionBlock;
import org.eso.oca.fits.KeywordNotFoundException;
import org.eso.oca.fits.OCAFile;
import org.eso.oca.fits.UndefinedValueException;

public class AssociationBlock {
    private String instrument = null;
    private OCAFile[] inputFiles = new OCAFile[0];
    private OCAFile[] associatedFiles = new OCAFile[0];
    private Vector<SelectionBlock> selectionBlocks = new Vector();
    private OCAFile[] productFiles = new OCAFile[0];
    private String recipe;
    private Vector recipeParams = new Vector();
    private String action;
    private String groupEvent;
    private String groupEventExt;
    private String[] matchKeywords = new String[0];
    private BigDecimal modifiedMjdObs = null;
    private OCAFile exemplar = null;
    private boolean isValid = true;
    private String abName;
    static Logger logger = Logger.getLogger(AssociationBlock.class);
    private String productDir = "/default/product/dir";
    private int minRequestedfiles = 1;
    private List<String> messages = new ArrayList<String>();
    private Integer priority;

    public void setValid(boolean flag) {
        this.isValid = flag;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String a2) {
        this.action = a2;
    }

    public OCAFile[] getAssociatedFiles() {
        return this.associatedFiles;
    }

    public void setAssociatedFiles(OCAFile[] aFiles) {
        this.associatedFiles = aFiles;
    }

    public synchronized void addAssociatedFiles(OCAFile[] aFiles) {
        int prevLen = this.associatedFiles.length;
        if (prevLen == 0) {
            this.setAssociatedFiles(aFiles);
        } else {
            int i;
            OCAFile[] aFilesNew = new OCAFile[prevLen + aFiles.length];
            for (i = 0; i < this.associatedFiles.length; ++i) {
                aFilesNew[i] = this.associatedFiles[i];
            }
            for (i = 0; i < aFiles.length; ++i) {
                aFilesNew[i + prevLen] = aFiles[i];
            }
            this.associatedFiles = aFilesNew;
        }
    }

    public synchronized void addInputFiles(OCAFile[] aFiles) {
        int prevLen = this.inputFiles.length;
        if (prevLen == 0) {
            this.setInputFiles(aFiles);
        } else {
            int i;
            OCAFile[] aFilesNew = new OCAFile[prevLen + aFiles.length];
            for (i = 0; i < this.inputFiles.length; ++i) {
                aFilesNew[i] = this.inputFiles[i];
            }
            for (i = 0; i < aFiles.length; ++i) {
                aFilesNew[i + prevLen] = aFiles[i];
            }
            this.inputFiles = aFilesNew;
        }
    }

    public void addSelectionBlock(SelectionBlock selectionBlock) {
        if (selectionBlock == null) {
            throw new IllegalArgumentException("selectionBlock must not be null");
        }
        this.selectionBlocks.add(selectionBlock);
    }

    public OCAFile[] getInputFiles() {
        return this.inputFiles;
    }

    public void setInputFiles(OCAFile[] iFiles) {
        this.inputFiles = iFiles;
    }

    public OCAFile[] getProductFiles() {
        return this.productFiles;
    }

    public void setABName(String aName) {
        this.abName = aName;
    }

    public String getABName() {
        String tmpName;
        try {
            tmpName = this.getExemplar().getDpId();
        }
        catch (Exception e1) {
            tmpName = new Long(Calendar.getInstance().getTimeInMillis()).toString();
            logger.error("Can't use exemplar dp_id to build AB name. Using timestamp : " + tmpName);
        }
        String abExt = this.getGroupEventExt();
        abExt = abExt == null ? "" : "_" + abExt;
        this.abName = tmpName + abExt;
        return this.abName;
    }

    public void setProductFiles(OCAFile[] pFiles) {
        this.productFiles = pFiles;
        String abName = this.getABName() + ".ab";
        String dfoDate = System.getProperty("DFO_DATE");
        for (int i = 0; i < this.productFiles.length; ++i) {
            this.productFiles[i].addMetaCard("AB.NAME", abName);
            if (dfoDate == null) continue;
            this.productFiles[i].addMetaCard("DATE", dfoDate);
        }
    }

    public String getRecipe() {
        return this.recipe;
    }

    public void setRecipe(String r) {
        this.recipe = r;
    }

    public String[] getRecipeParams() {
        return this.recipeParams.toArray(new String[0]);
    }

    public void setRecipeParams(Vector p) {
        this.recipeParams = p;
    }

    public OCAFile getExemplar() {
        int i;
        if (this.exemplar != null) {
            return this.exemplar;
        }
        for (i = 0; i < this.inputFiles.length; ++i) {
            try {
                this.inputFiles[i].getMjdObs();
            }
            catch (Exception e2) {
                continue;
            }
            this.exemplar = this.inputFiles[i];
            break;
        }
        if (this.exemplar == null) {
            logger.error("None of the input files has a valid MJD-OBS. Invalid AB.");
            this.exemplar = this.inputFiles[0];
            this.setValid(false);
            return this.exemplar;
        }
        for (i = 0; i < this.inputFiles.length; ++i) {
            try {
                if (this.inputFiles[i].getMjdObs().compareTo(this.exemplar.getMjdObs()) >= 0) continue;
                this.exemplar = this.inputFiles[i];
                continue;
            }
            catch (Exception e3) {
                try {
                    logger.info(this.inputFiles[i].getFilename() + ". Can't compare MJD-OBS with exemplar.");
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this.exemplar;
    }

    protected void setExemplar(OCAFile exemplarVal) {
        this.exemplar = exemplarVal;
    }

    public String getInstrument() throws KeywordNotFoundException, UndefinedValueException {
        if (this.instrument != null) {
            return this.instrument;
        }
        return this.getExemplar().getInstrument();
    }

    public void setInstrument(String i) {
        if (i == null) {
            throw new IllegalArgumentException("null instrument");
        }
        this.instrument = i;
    }

    public void accept(ABVisitor visitor) throws ABVisitorException {
        visitor.visit(this);
    }

    public String toString() {
        int i;
        StringBuffer out = new StringBuffer();
        out.append((this.isValid ? "GOOD" : "BAD") + " AB\n");
        out.append("recipe : " + this.recipe);
        out.append("\n");
        out.append("input files {\n");
        for (i = 0; i < this.inputFiles.length; ++i) {
            try {
                out.append(this.inputFiles[i].getFilename() + "\t");
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                out.append(this.inputFiles[i].getDoClass());
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            out.append("\n");
        }
        out.append("}\n");
        out.append("associated files {\n");
        for (i = 0; i < this.associatedFiles.length; ++i) {
            try {
                out.append(this.associatedFiles[i].getFilename() + "\t");
            }
            catch (Exception e3) {
                e3.printStackTrace();
            }
            try {
                out.append(this.associatedFiles[i].getAlias() + "\t");
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            out.append(this.associatedFiles[i].isVirtual() ? "VIRTUAL" : "REAL");
            out.append("\n");
        }
        out.append("}\n");
        out.append("product files {\n");
        for (i = 0; i < this.productFiles.length; ++i) {
            try {
                out.append(this.productFiles[i].getFilename() + "\t");
            }
            catch (Exception e4) {
                e4.printStackTrace();
            }
            try {
                out.append(this.productFiles[i].getProCatg());
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            out.append("\n");
        }
        out.append("}\n");
        return out.toString();
    }

    public void setMatchKeywords(String[] mKeywords) {
        if (mKeywords == null) {
            throw new IllegalArgumentException("null match keywords");
        }
        this.matchKeywords = mKeywords;
    }

    public String[] getMatchKeywords() {
        return this.matchKeywords;
    }

    protected void setModifiedMjdObs(BigDecimal modifiedMjdObsVal) {
        this.modifiedMjdObs = modifiedMjdObsVal;
    }

    public BigDecimal getModifiedMjdObs() throws NumberFormatException, KeywordNotFoundException, UndefinedValueException {
        if (this.modifiedMjdObs == null) {
            double mjdStart = this.getExemplar().getMjdObs().doubleValue();
            double totExptime = 0.0;
            for (int i = 0; i < this.inputFiles.length; ++i) {
                double exptime = 0.0;
                try {
                    exptime = new Float(this.inputFiles[i].getKeywordValue("EXPTIME")).doubleValue();
                }
                catch (Exception e2) {
                    logger.warn("Can't use EXPTIME of file " + this.inputFiles[i].getKeywordValue("FILENAME") + " to compute MODIFIED MJD-OBS");
                }
                totExptime += exptime;
            }
            this.modifiedMjdObs = new BigDecimal(mjdStart + totExptime / 86400.0 / 2.0);
        }
        return this.modifiedMjdObs;
    }

    public void setProductDir(String dir) {
        if (dir == null) {
            throw new IllegalArgumentException("null product dir");
        }
        this.productDir = dir;
    }

    public String getProductDir() {
        return this.productDir;
    }

    public void setGroupEvent(String event) {
        this.groupEvent = event;
    }

    public String getGroupEvent() {
        return this.groupEvent;
    }

    public void setGroupEventExt(String ext) {
        this.groupEventExt = ext;
    }

    public String getGroupEventExt() {
        return this.groupEventExt;
    }

    public String[] getAssociationTypes() {
        String[] types = new String[this.selectionBlocks.size()];
        for (int i = 0; i < this.selectionBlocks.size(); ++i) {
            types[i] = this.selectionBlocks.elementAt(i).getAlias();
        }
        return types;
    }

    public SelectionBlock getSelectionBlockForType(String type) {
        if (type == null) {
            throw new IllegalArgumentException("type must not be null");
        }
        for (int i = 0; i < this.selectionBlocks.size(); ++i) {
            if (!this.selectionBlocks.elementAt(i).getAlias().equals(type)) continue;
            return this.selectionBlocks.elementAt(i);
        }
        logger.error("No selection block found for type " + type);
        return new SelectionBlock(type, 0, 0, new OCAFile[0]);
    }

    public OCAFile[] getAssociatedFilesForType(String type) {
        if (type == null) {
            throw new IllegalArgumentException("type must not be null");
        }
        for (int i = 0; i < this.selectionBlocks.size(); ++i) {
            if (!this.selectionBlocks.elementAt(i).getAlias().equals(type)) continue;
            return this.selectionBlocks.elementAt(i).getSelectedFiles();
        }
        logger.error("No associations found for type " + type);
        return new OCAFile[0];
    }

    public Vector<SelectionBlock> getSelectionBlocks() {
        return this.selectionBlocks;
    }

    public void setSelectionBlocks(Vector<SelectionBlock> selections) {
        this.selectionBlocks = selections;
    }

    public void setMinRequestedFiles(int nr) {
        this.minRequestedfiles = nr;
    }

    public int getMinRequestedFiles() {
        return this.minRequestedfiles;
    }

    public List<String> getMessages() {
        return this.messages;
    }

    public void setMessages(List<String> messages) {
        this.messages = messages;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public Integer getPriority() {
        return this.priority;
    }
}

