/*
 * Decompiled with CFR 0.152.
 */
package org.eso.oca.fits;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.eso.oca.fits.DataTransportFormatHandler;
import org.eso.oca.fits.DefaultFileFilter;
import org.eso.oca.fits.FITSHandler;
import org.eso.oca.fits.FileHandlerException;
import org.eso.oca.fits.HDRHandler;
import org.eso.oca.fits.OCAFile;
import org.eso.oca.fits.OCAFileFilter;
import org.eso.oca.fits.TypedHeaderCard;
import org.eso.oca.fits.TypedHeaderCardException;
import org.eso.util.filesystem.DirectoryFileSelectionModel;
import org.eso.util.filesystem.FileSelectionModel;
import org.eso.util.filesystem.RecursiveFileSelectionModel;

public class OCAFileFactory {
    private String rootDir = ".";
    private FileSelectionModel fileSelectionModel = null;
    static Logger logger = Logger.getLogger(OCAFileFactory.class);

    public OCAFileFactory(String directory) {
        logger.trace("OCAFileFactory::OCAFileFactory()");
        this.rootDir = directory;
        this.fileSelectionModel = new DirectoryFileSelectionModel(this.rootDir);
    }

    public OCAFileFactory(String[] filesAndDirectories) {
        logger.trace("OCAFileFactory::OCAFileFactory(String[])");
        this.fileSelectionModel = new DirectoryFileSelectionModel(filesAndDirectories);
    }

    public void setRecursiveFileSelection() {
        logger.trace("OCAFileFactory::setRecursiveFileSelection()");
        this.fileSelectionModel = new RecursiveFileSelectionModel(this.rootDir);
    }

    public String getRootDir() {
        logger.trace("OCAFileFactory::getRootDir()");
        return this.rootDir;
    }

    public OCAFile[] createOCAFiles(int extension, String[] keywords, OCAFileFilter filter) {
        logger.trace("OCAFileFactory::createOCAFiles(int, String[], OCAFileFilter)");
        ArrayList<OCAFile> readFiles = new ArrayList<OCAFile>();
        ArrayList<File> skippedFiles = new ArrayList<File>();
        this.createOCAFiles(extension, keywords, filter, readFiles, skippedFiles);
        OCAFile[] fileArray = new OCAFile[readFiles.size()];
        return readFiles.toArray(fileArray);
    }

    public void createOCAFiles(int extension, String[] keywords, OCAFileFilter filter, ArrayList<OCAFile> readFiles, ArrayList<File> skippedFiles) {
        String methodName = "OCAFileFactory::createOCAFiles(int, String[], OCAFileFilter, ArrayList<OCAFile>, ArrayList<File>)";
        logger.trace("OCAFileFactory::createOCAFiles(int, String[], OCAFileFilter, ArrayList<OCAFile>, ArrayList<File>)");
        if (keywords == null || readFiles == null || skippedFiles == null) {
            String message = "OCAFileFactory::createOCAFiles(int, String[], OCAFileFilter, ArrayList<OCAFile>, ArrayList<File>) - null parameter(s):" + (keywords == null ? " keywords" : "") + (readFiles == null ? " readFiles" : "") + (skippedFiles == null ? " skippedFiles" : "") + ".";
            logger.fatal(message);
            throw new NullPointerException(message);
        }
        if (filter == null) {
            filter = new DefaultFileFilter();
        }
        TreeSet<String> tmpData = new TreeSet<String>(Arrays.asList(keywords));
        tmpData.add("INSTRUME");
        tmpData.add("MJD-OBS");
        tmpData.add((String)OCAFile.OBS_PROG_ID);
        tmpData.add((String)OCAFile.OBS_ID);
        tmpData.add("EXPTIME");
        tmpData.add("TPL.START");
        tmpData.add("TPL.EXPNO");
        tmpData.add("TPL.NEXP");
        String[] requestedData = new String[tmpData.size()];
        requestedData = tmpData.toArray(new String[0]);
        Vector files = this.fileSelectionModel.getFileList();
        for (String linkname : files) {
            Hashtable keywordValues;
            DataTransportFormatHandler handler;
            String filename;
            block18: {
                filename = OCAFile.getCanonicalPath(linkname);
                if (filename == null) {
                    logger.warn("OCAFileFactory::createOCAFiles(int, String[], OCAFileFilter, ArrayList<OCAFile>, ArrayList<File>) - skipping invalid pathname [" + linkname + "].");
                    skippedFiles.add(new File(linkname));
                    continue;
                }
                handler = null;
                int indexOfLastDot = filename.lastIndexOf(46);
                if (indexOfLastDot < 0) {
                    logger.debug("OCAFileFactory::createOCAFiles(int, String[], OCAFileFilter, ArrayList<OCAFile>, ArrayList<File>) - skipping unidentifiable file [" + linkname + "].");
                    skippedFiles.add(new File(linkname));
                    continue;
                }
                String ext = filename.substring(indexOfLastDot).toLowerCase();
                if (ext.equals(".hdr")) {
                    logger.debug("OCAFileFactory::createOCAFiles(int, String[], OCAFileFilter, ArrayList<OCAFile>, ArrayList<File>) - invoking HDR file handler for file [" + linkname + "].");
                    try {
                        handler = new HDRHandler(filename);
                        break block18;
                    }
                    catch (FileHandlerException e2) {
                        logger.error("OCAFileFactory::createOCAFiles(int, String[], OCAFileFilter, ArrayList<OCAFile>, ArrayList<File>) - could not handle file [" + linkname + "] as an HDR file [" + e2.getMessage() + "].");
                        skippedFiles.add(new File(linkname));
                        continue;
                    }
                }
                if (ext.equals(".fits") || ext.equals(".tfits")) {
                    logger.debug("OCAFileFactory::createOCAFiles(int, String[], OCAFileFilter, ArrayList<OCAFile>, ArrayList<File>) - invoking FITS file handler for file [" + linkname + "].");
                    try {
                        handler = new FITSHandler(filename);
                        break block18;
                    }
                    catch (FileHandlerException e3) {
                        logger.error("OCAFileFactory::createOCAFiles(int, String[], OCAFileFilter, ArrayList<OCAFile>, ArrayList<File>) - could not handle file [" + linkname + "] as a FITS file [" + e3.getMessage() + "].");
                        skippedFiles.add(new File(linkname));
                        continue;
                    }
                }
                logger.debug("OCAFileFactory::createOCAFiles(int, String[], OCAFileFilter, ArrayList<OCAFile>, ArrayList<File>) - skipping file [" + linkname + "] of unsupported type.");
                skippedFiles.add(new File(linkname));
                continue;
            }
            TypedHeaderCard[] cards = null;
            try {
                cards = handler.getFITSCards(extension, requestedData);
                handler.dispose();
            }
            catch (Exception e4) {
                logger.error("OCAFileFactory::createOCAFiles(int, String[], OCAFileFilter, ArrayList<OCAFile>, ArrayList<File>) - unable to retrieve FITS cards for file [" + linkname + "] [" + e4.getMessage() + "].");
                skippedFiles.add(new File(linkname));
                continue;
            }
            try {
                keywordValues = OCAFileFactory.convertArrayOfCardsToHashtable(cards);
            }
            catch (TypedHeaderCardException e5) {
                logger.error("OCAFileFactory::createOCAFiles(int, String[], OCAFileFilter, ArrayList<OCAFile>, ArrayList<File>) - unable to convert FITS cards to hashtable for file [" + linkname + "] [" + e5.getMessage() + "].");
                skippedFiles.add(new File(linkname));
                continue;
            }
            keywordValues.put("FILENAME", filename);
            keywordValues.put("LINKNAME", linkname);
            String olasID = null;
            Pattern p = Pattern.compile(".*/(r\\.){0,1}([^.]*)\\..*");
            Matcher m = p.matcher(filename);
            if (m.matches()) {
                olasID = m.group(2);
            } else {
                logger.warn("OCAFileFactory::createOCAFiles(int, String[], OCAFileFilter, ArrayList<OCAFile>, ArrayList<File>) - could not determine the OLAS ID for file [" + linkname + "].");
                olasID = "";
            }
            keywordValues.put("OLAS-ID", olasID.toUpperCase());
            keywordValues.put("DP.ID", OCAFileFactory.makeDpId(filename));
            OCAFile ocaFile = new OCAFile(keywordValues);
            if (filter.filter(ocaFile)) {
                logger.debug("OCAFileFactory::createOCAFiles(int, String[], OCAFileFilter, ArrayList<OCAFile>, ArrayList<File>) - file filter accepted file [" + linkname + "].");
                readFiles.add(ocaFile);
                continue;
            }
            logger.debug("OCAFileFactory::createOCAFiles(int, String[], OCAFileFilter, ArrayList<OCAFile>, ArrayList<File>) - file filter rejected file [" + linkname + "].");
            skippedFiles.add(new File(linkname));
        }
    }

    public static Hashtable convertArrayOfCardsToHashtable(TypedHeaderCard[] cards) throws TypedHeaderCardException {
        logger.trace("OCAFileFactory::convertArrayOfCardsToHashtable()");
        if (cards == null) {
            String message = "OCAFileFactory::convertArrayOfCardsToHashtable() - cards must not be null.";
            logger.fatal("OCAFileFactory::convertArrayOfCardsToHashtable() - cards must not be null.");
            throw new NullPointerException("OCAFileFactory::convertArrayOfCardsToHashtable() - cards must not be null.");
        }
        Hashtable<String, Object> keyValues = new Hashtable<String, Object>();
        block3: for (int i = 0; i < cards.length; ++i) {
            TypedHeaderCard currentCard = cards[i];
            String currentKey = currentCard.getKey(0);
            switch (currentCard.getType()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    keyValues.put(currentKey, currentCard.getValueObject());
                    continue block3;
                }
                default: {
                    String message = "OCAFileFactory::convertArrayOfCardsToHashtable() - type error for keyword '" + currentKey + "' with type '" + currentCard.getTypeString() + "'.";
                    logger.error(message);
                    throw new TypedHeaderCardException(message);
                }
            }
        }
        return keyValues;
    }

    public static String makeDpId(String filename) {
        String basename;
        logger.trace("OCAFileFactory::makeDpId()");
        if (filename == null) {
            String message = "OCAFileFactory::makeDpId() - filename must not be null.";
            logger.fatal("OCAFileFactory::makeDpId() - filename must not be null.");
            throw new NullPointerException("OCAFileFactory::makeDpId() - filename must not be null.");
        }
        String dpId = basename = new File(filename).getName();
        int indexOfLastDot = basename.lastIndexOf(46);
        if (indexOfLastDot > 0) {
            dpId = basename.substring(0, indexOfLastDot);
        }
        return dpId;
    }
}

