/*
 * Decompiled with CFR 0.152.
 */
package org.eso.oca.parser;

import org.apache.log4j.Logger;
import org.eso.oca.fits.TypedHeaderCard;
import org.eso.oca.fits.UndefinedFITSValue;
import org.eso.oca.parser.InterpretationException;
import org.eso.oca.parser.OCAState;
import org.eso.oca.parser.OcaParser;
import org.eso.oca.parser.OcaParserVisitor;
import org.eso.oca.parser.OcaVisitorException;
import org.eso.oca.parser.SimpleNode;

public class ASTLike
extends SimpleNode {
    static Logger logger = Logger.getLogger(ASTLike.class);

    public ASTLike(int id) {
        super(id);
    }

    public ASTLike(OcaParser p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OcaParserVisitor visitor, Object data) throws OcaVisitorException {
        return visitor.visit(this, data);
    }

    @Override
    public int precedence() {
        return 30;
    }

    private String escapeForRegex(String str) {
        String regexChars = "\\[]^-&.{}$?*+,|():=!<>";
        int length = str.length();
        StringBuffer result = new StringBuffer(length);
        for (int i = 0; i < length; ++i) {
            char currentChar = str.charAt(i);
            if (regexChars.indexOf(currentChar) >= 0) {
                result.append('\\');
            }
            result.append(currentChar);
        }
        return result.toString();
    }

    private String convertToRegex(String pattern) {
        pattern = this.escapeForRegex(pattern);
        int length = pattern.length();
        StringBuffer result = new StringBuffer(length);
        result.append("\\A");
        for (int i = 0; i < length; ++i) {
            char currentChar = pattern.charAt(i);
            if (currentChar == '%') {
                if (i + 1 < length && pattern.charAt(i + 1) == '%') {
                    result.append('%');
                    ++i;
                    continue;
                }
                result.append(".*");
                continue;
            }
            result.append(currentChar);
        }
        result.append("\\z");
        return result.toString();
    }

    Object like(Object leftOperand, Object rightOperand) throws InterpretationException {
        String message = this.getNodeLocationString() + "Operator 'like' may not be used for \"" + TypedHeaderCard.findFITSTypeString(leftOperand) + " like " + TypedHeaderCard.findFITSTypeString(rightOperand) + "\".";
        logger.error(message);
        throw new InterpretationException(message);
    }

    Boolean like(Object leftOperand, UndefinedFITSValue rightOperand) {
        String message = this.getNodeLocationString() + "Operator 'like' used with undefined operand: \"" + TypedHeaderCard.findFITSTypeString(leftOperand) + " like " + TypedHeaderCard.findFITSTypeString(rightOperand) + "\".";
        logger.debug(message);
        return new Boolean(false);
    }

    Boolean like(UndefinedFITSValue leftOperand, Object rightOperand) {
        String message = this.getNodeLocationString() + "Operator 'like' used with undefined operand: \"" + TypedHeaderCard.findFITSTypeString(leftOperand) + " like " + TypedHeaderCard.findFITSTypeString(rightOperand) + "\".";
        logger.debug(message);
        return new Boolean(false);
    }

    Boolean like(String leftOperand, String rightOperand) {
        return new Boolean(leftOperand.matches(this.convertToRegex(rightOperand)));
    }

    @Override
    public void interpret(OCAState state) throws InterpretationException {
        logger.trace("interpret() called.");
        this.jjtGetChild(0).interpret(state);
        this.jjtGetChild(1).interpret(state);
        state.stack[--state.top] = this.dispatch(this.getClass(), "like", new Object[]{state.stack[state.top], state.stack[state.top + 1]});
    }
}

