/*
 * Decompiled with CFR 0.152.
 */
package org.eso.oca.parser;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.TreeMap;
import org.eso.oca.parser.DispatchReflectionError;

public class DispatchHelper {
    private static Hashtable dispatchCache = new Hashtable();

    static LinkedList getMethodSet(Class targetClass, String methodName) {
        Class currentClass = targetClass;
        LinkedList<Method> methodList = new LinkedList<Method>();
        do {
            Method[] classMethods = currentClass.getDeclaredMethods();
            for (int i = 0; i < classMethods.length; ++i) {
                Method currentMethod = classMethods[i];
                if (!currentMethod.getName().equals(methodName)) continue;
                int accessModifiers = currentMethod.getModifiers();
                if (currentClass != targetClass && Modifier.isPrivate(accessModifiers) || currentClass.getPackage() != targetClass.getPackage() && !Modifier.isPublic(accessModifiers) && !Modifier.isProtected(accessModifiers)) continue;
                methodList.add(currentMethod);
            }
        } while ((currentClass = currentClass.getSuperclass()) != null);
        return methodList;
    }

    static Class getDispatchCallingClass() {
        try {
            throw new Exception();
        }
        catch (Exception e2) {
            StackTraceElement[] elements = e2.getStackTrace();
            if (elements.length < 3) {
                throw new DispatchReflectionError("KA-BOOM!");
            }
            try {
                return Class.forName(elements[2].getClassName());
            }
            catch (ClassNotFoundException cnfe) {
                return Object.class;
            }
        }
    }

    static Method getNearestMethod(Class targetClass, String methodName, Object[] args) {
        Method result = null;
        String methodKey = targetClass.getName() + "::" + methodName + "(";
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                methodKey = methodKey + ", ";
            }
            methodKey = methodKey + args[i].getClass().getName();
        }
        result = (Method)dispatchCache.get(methodKey = methodKey + ")");
        if (result == null) {
            LinkedList[] argTypes = new LinkedList[args.length];
            for (int i = 0; i < args.length; ++i) {
                argTypes[i] = new LinkedList();
                Class<?> currentArgType = args[i].getClass();
                do {
                    argTypes[i].add(currentArgType);
                } while ((currentArgType = currentArgType.getSuperclass()) != null);
            }
            LinkedList methodList = DispatchHelper.getMethodSet(targetClass, methodName);
            ListIterator methodIterator = methodList.listIterator(0);
            TreeMap<Integer, Method> scoredMethods = new TreeMap<Integer, Method>();
            block3: for (int i = 0; i < methodList.size(); ++i) {
                Method currentMethod = (Method)methodIterator.next();
                Class<?>[] currentParams = currentMethod.getParameterTypes();
                int currentScore = 0;
                if (currentParams.length != argTypes.length) continue;
                block4: for (int j = 0; j < argTypes.length; ++j) {
                    ListIterator paramIterator = argTypes[j].listIterator(0);
                    for (int k = 0; k < argTypes[j].size(); ++k) {
                        if (currentParams[j] != paramIterator.next()) continue;
                        currentScore += k * k;
                        continue block4;
                    }
                    continue block3;
                }
                if (currentScore == 0) {
                    result = currentMethod;
                    break;
                }
                if (scoredMethods.get(new Integer(currentScore)) != null) continue;
                scoredMethods.put(new Integer(currentScore), currentMethod);
            }
            if (result == null && scoredMethods.size() > 0) {
                result = (Method)scoredMethods.get(scoredMethods.firstKey());
            }
            dispatchCache.put(methodKey, result);
        }
        return result;
    }
}

