/*
 * Decompiled with CFR 0.152.
 */
package org.eso.util.dal;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eso.util.dal.ConnectionServiceException;
import org.eso.util.dal.DAOException;
import org.eso.util.dal.PackageAuxFilesDAO;
import org.eso.util.dal.SybaseConnectionService;

public class PackageAuxFilesDAOSyb
implements PackageAuxFilesDAO {
    static final Logger logger = Logger.getLogger(PackageAuxFilesDAOSyb.class);
    private static final String classLogName = "PackageAuxFilesDAOSyb";
    public static final String PACKAGEID_KW = "pkg_id";
    public static final String FILEID_KW = "file_id";
    public static final String AUXFILE_KW = "aux_file";
    private Connection d_connection = null;
    private String d_dbTable = null;

    public PackageAuxFilesDAOSyb(Connection conn, String dbTable) {
        this.d_connection = conn;
        this.d_dbTable = dbTable;
    }

    @Override
    public List<String> getAuxFiles(String fileId) throws DAOException {
        String query = "SELECT * FROM " + this.d_dbTable + " WHERE " + FILEID_KW + "='" + fileId + "'";
        try {
            ResultSet rs = SybaseConnectionService.executeStatement(this.d_connection, query);
            ArrayList<String> result = new ArrayList<String>();
            while (rs.next()) {
                result.add(rs.getString(AUXFILE_KW));
            }
            return result;
        }
        catch (SQLException e2) {
            throw new DAOException(e2.getMessage());
        }
        catch (ConnectionServiceException e3) {
            throw new DAOException(e3.getMessage());
        }
    }

    @Override
    public Map<String, List<String>> getAuxFiles(Integer pkgId) throws DAOException {
        String query = "SELECT * FROM " + this.d_dbTable + " WHERE " + PACKAGEID_KW + "=" + pkgId;
        try {
            ResultSet rs = SybaseConnectionService.executeStatement(this.d_connection, query);
            HashMap<String, List<String>> result = new HashMap<String, List<String>>();
            while (rs.next()) {
                String fileId = rs.getString(FILEID_KW);
                if (!result.containsKey(fileId)) {
                    result.put(fileId, new ArrayList());
                }
                List files = (List)result.get(fileId);
                files.add(rs.getString(AUXFILE_KW));
            }
            return result;
        }
        catch (SQLException e2) {
            throw new DAOException(e2.getMessage());
        }
        catch (ConnectionServiceException e3) {
            throw new DAOException(e3.getMessage());
        }
    }

    @Override
    public Map<String, List<String>> getAuxFiles(Integer pkgId, List<String> fileIds) throws DAOException {
        HashMap<String, List<String>> res = new HashMap<String, List<String>>();
        int numberOfIterations = (fileIds.size() + 99) / 100;
        for (int i = 0; i < numberOfIterations; ++i) {
            int start = i * 100;
            int stop = Math.min((i + 1) * 100, fileIds.size());
            res.putAll(this.getAuxFiles(pkgId, fileIds, start, stop));
        }
        return res;
    }

    private Map<String, List<String>> getAuxFiles(Integer pkgId, List<String> fileIds, int start, int stop) throws DAOException {
        String query = "SELECT * FROM " + this.d_dbTable + " WHERE " + PACKAGEID_KW + "=" + pkgId + " AND " + FILEID_KW + " IN (";
        for (int i = start; i < stop; ++i) {
            query = query + "'" + fileIds.get(i) + "',";
        }
        query = query.substring(0, query.length() - 1) + ")";
        try {
            ResultSet rs = SybaseConnectionService.executeStatement(this.d_connection, query);
            HashMap<String, List<String>> result = new HashMap<String, List<String>>();
            while (rs.next()) {
                String fileId = rs.getString(FILEID_KW);
                if (!result.containsKey(fileId)) {
                    result.put(fileId, new ArrayList());
                }
                List files = (List)result.get(fileId);
                files.add(rs.getString(AUXFILE_KW));
            }
            return result;
        }
        catch (SQLException e2) {
            throw new DAOException(e2.getMessage());
        }
        catch (ConnectionServiceException e3) {
            throw new DAOException(e3.getMessage());
        }
    }

    @Override
    public void insertPackageAuxFile(Integer pkgId, String fileId, String filename) throws DAOException {
        String query = "INSERT INTO " + this.d_dbTable + " (" + PACKAGEID_KW + "," + FILEID_KW + "," + AUXFILE_KW + ") ";
        query = query + " VALUES (" + pkgId + ",'" + fileId + "','" + filename + "')";
        try {
            SybaseConnectionService.executeStatement(this.d_connection, query);
        }
        catch (ConnectionServiceException e2) {
            throw new DAOException(e2.getMessage());
        }
    }

    @Override
    public void insertPackageAuxFiles(Integer pkgId, Map<String, List<String>> packageFiles) throws DAOException {
        ArrayList<String> statements = new ArrayList<String>();
        for (String fileId : packageFiles.keySet()) {
            for (String filename : packageFiles.get(fileId)) {
                String query = "INSERT INTO " + this.d_dbTable + " (" + PACKAGEID_KW + "," + FILEID_KW + "," + AUXFILE_KW + ") ";
                query = query + " VALUES (" + pkgId + ",'" + fileId + "','" + filename + "')";
                statements.add(query);
            }
        }
        try {
            SybaseConnectionService.executeBatchedStatement(this.d_connection, statements);
        }
        catch (ConnectionServiceException e2) {
            throw new DAOException(e2.getMessage());
        }
    }

    @Override
    public void insertPackageAuxFilesIfNotFound(Integer pkgId, Map<String, List<String>> packageFiles) throws DAOException {
        HashMap<String, List<String>> toInsert = new HashMap<String, List<String>>();
        for (String fileId : packageFiles.keySet()) {
            ArrayList<String> temp = new ArrayList<String>();
            for (String filename : packageFiles.get(fileId)) {
                if (this.findPackageAuxFile(pkgId, fileId, filename)) continue;
                temp.add(filename);
            }
            toInsert.put(fileId, temp);
        }
        this.insertPackageAuxFiles(pkgId, toInsert);
    }

    @Override
    public boolean findPackageAuxFile(Integer pkgId, String fileId, String filename) throws DAOException {
        String query = "SELECT * FROM " + this.d_dbTable + " WHERE " + PACKAGEID_KW + " = " + pkgId;
        query = query + " AND file_id = '" + fileId + "'";
        query = query + " AND aux_file = '" + filename + "'";
        try {
            ResultSet rs = SybaseConnectionService.executeStatement(this.d_connection, query);
            boolean res = rs.next();
            return res;
        }
        catch (SQLException e2) {
            throw new DAOException(e2.getMessage());
        }
        catch (ConnectionServiceException e3) {
            throw new DAOException(e3.getMessage());
        }
    }

    @Override
    public void deletePackageAuxFile(Integer pkgId, String fileId, String filename) throws DAOException {
        String query = "DELETE FROM " + this.d_dbTable + " WHERE " + PACKAGEID_KW + "=" + pkgId + " AND " + FILEID_KW + "='" + fileId + "' AND " + AUXFILE_KW + "='" + filename + "'";
        try {
            SybaseConnectionService.executeStatement(this.d_connection, query);
        }
        catch (ConnectionServiceException e2) {
            throw new DAOException(e2.getMessage());
        }
    }

    @Override
    public void deletePackageAuxFiles(Integer pkgId, Map<String, List<String>> packageFiles) throws DAOException {
        ArrayList<String> statements = new ArrayList<String>();
        for (String fileId : packageFiles.keySet()) {
            for (String filename : packageFiles.get(fileId)) {
                String query = "DELETE FROM " + this.d_dbTable + " WHERE " + PACKAGEID_KW + "=" + pkgId + " AND " + FILEID_KW + "='" + fileId + "' AND " + AUXFILE_KW + "='" + filename + "'";
                statements.add(query);
            }
        }
        try {
            SybaseConnectionService.executeBatchedStatement(this.d_connection, statements);
        }
        catch (ConnectionServiceException e2) {
            throw new DAOException(e2.getMessage());
        }
    }
}

