/*
 * Decompiled with CFR 0.152.
 */
package org.eso.util.database;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ConnectionPool {
    private static final String rcsid = "$Id: ConnectionPool.java,v 1.1 2007-03-07 09:20:43 szampier Exp $";
    private static Logger stdlog_ = Logger.getLogger(ConnectionPool.class);
    public static final String PoolSize = "conn.pool.size";
    public static final String Timeout = "conn.pool.timeout";
    public static final String ReopenAllowed = "conn.pool.reopen";
    protected static int MAX_CONNECTIONS = 20;
    protected static long REAPER_SLEEPTIME = 5000L;
    protected static long MAX_IDLE_LIFETIME = 60000L;
    protected static int MAX_LIFETIME = 600000;
    protected static boolean reopenAllowed_ = true;
    protected Vector<Element> pool_ = new Vector();
    private static ConnectionPool conPool_;
    private int maxPoolSize_;
    private Reaper reaper_;
    private String userName_;
    private String password_;

    public static long getMaxIdleLifetime() {
        return MAX_IDLE_LIFETIME;
    }

    public static long getReaperSleepTime() {
        return REAPER_SLEEPTIME;
    }

    public static synchronized boolean setInitProperties(Properties props) {
        String prop = props.getProperty(PoolSize);
        if (prop != null) {
            try {
                MAX_CONNECTIONS = Integer.parseInt(prop);
            }
            catch (NumberFormatException e2) {
                e2.printStackTrace();
            }
            stdlog_.info("MAX_CONNECTIONS set to: " + MAX_CONNECTIONS);
        }
        if ((prop = props.getProperty(Timeout)) != null) {
            try {
                MAX_IDLE_LIFETIME = Integer.parseInt(prop);
            }
            catch (NumberFormatException e3) {
                e3.printStackTrace();
            }
            stdlog_.info("MAX_IDLE_LIFETIME set to: " + MAX_IDLE_LIFETIME);
        }
        if ((prop = props.getProperty(ReopenAllowed)) != null) {
            reopenAllowed_ = prop.equalsIgnoreCase("T");
            stdlog_.info("reopenAllowed_ set to: " + reopenAllowed_);
        }
        return conPool_ == null;
    }

    protected ConnectionPool(int maxPoolSize) {
        this.maxPoolSize_ = maxPoolSize;
        if (MAX_IDLE_LIFETIME > 0L) {
            this.reaper_ = new Reaper(this, this.pool_);
            this.reaper_.start();
        } else {
            this.reaper_ = null;
        }
        stdlog_.debug("MAX_IDLE_LIFETIME: " + MAX_IDLE_LIFETIME);
        stdlog_.debug("MAX_CONNECTIONS: " + MAX_CONNECTIONS);
        stdlog_.debug("reopenAllowed_: " + reopenAllowed_);
    }

    public void setUserName(String un) {
        this.userName_ = un;
    }

    public void setPassword(String pw) {
        this.password_ = pw;
    }

    public synchronized Connection acquireConnection(String dbUrl, String userName, String password) throws SQLException {
        Element elem = null;
        this.userName_ = userName;
        this.setPassword(password);
        if (stdlog_.isDebugEnabled()) {
            stdlog_.debug("URL: " + dbUrl + " user name: " + this.userName_);
        }
        String dbName = dbUrl.substring(dbUrl.lastIndexOf(47) + 1, dbUrl.length());
        while (true) {
            int j;
            int poolSize = this.pool_.size();
            for (j = 0; j < poolSize; ++j) {
                elem = this.pool_.elementAt(j);
                if (!elem.available || reopenAllowed_ && !dbName.equals(elem.dbaseName)) continue;
                elem.available = false;
                stdlog_.debug("@@ acquireConnection: found " + j);
                return elem.connection;
            }
            if (reopenAllowed_) {
                for (j = 0; j < poolSize; ++j) {
                    elem = this.pool_.elementAt(j);
                    if (!elem.available) continue;
                    elem.available = false;
                    stdlog_.debug("@@ acquireConnection: found " + j);
                    this.reuseConnection(elem, dbUrl, dbName);
                    return elem.connection;
                }
            }
            if (this.pool_.size() < this.maxPoolSize_) break;
            try {
                stdlog_.debug("@@ acquireConnection: waiting");
                this.wait();
            }
            catch (InterruptedException e2) {
                e2.printStackTrace();
            }
        }
        stdlog_.debug("@@ acquireConnection: adding conn " + this.pool_.size());
        elem = new Element();
        elem.available = false;
        elem.creationTime = System.currentTimeMillis();
        elem.connection = this.openConnection(dbUrl);
        elem.dbaseName = dbName;
        this.pool_.addElement(elem);
        return elem.connection;
    }

    public synchronized void releaseAllConnections() throws SQLException {
        for (Element element : this.pool_) {
            this.closeConnection(element.connection);
        }
        this.pool_.removeAllElements();
    }

    public synchronized void releaseConnection(Connection con) {
        if (con == null) {
            return;
        }
        int poolSize = this.pool_.size();
        for (int j = 0; j < poolSize; ++j) {
            Element elem = this.pool_.elementAt(j);
            if (elem.connection != con) continue;
            boolean removeElem = false;
            try {
                if (elem.connection.isClosed()) {
                    removeElem = true;
                }
            }
            catch (SQLException e2) {
                removeElem = true;
            }
            if (removeElem) {
                this.pool_.removeElementAt(j);
            } else {
                elem.available = true;
                elem.last_released = System.currentTimeMillis();
            }
            stdlog_.debug("@@ releaseConnection: releasing " + j);
            this.notify();
            return;
        }
        stdlog_.warn("@@ releaseConnection: NOT FOUND");
        throw new IllegalArgumentException("internal error: unknown connection");
    }

    protected void reuseConnection(Element elem, String dbUrl, String dbName) throws SQLException {
        if (reopenAllowed_) {
            this.closeConnection(elem.connection);
            elem.connection = this.openConnection(dbUrl);
            elem.dbaseName = dbName;
        }
    }

    protected Connection openConnection(String url) throws SQLException {
        return this.openConnection(url, null, null);
    }

    protected Connection openConnection(String url, String un, String pw) throws SQLException {
        Connection conn;
        if (un == null) {
            un = this.userName_;
        }
        if (pw == null) {
            pw = this.getPassword();
        }
        Properties props = new Properties();
        props.put("CHARSET", "iso_1");
        props.put("user", un);
        props.put("password", pw);
        try {
            conn = DriverManager.getConnection(url, props);
        }
        catch (SQLException e2) {
            stdlog_.error("url: " + url + " user: " + un);
            throw e2;
        }
        return conn;
    }

    public Connection openExtraPoolConnection(String url, String un, String pw) throws SQLException {
        return this.openConnection(url, un, pw);
    }

    protected void closeConnection(Connection con) throws SQLException {
        con.close();
    }

    public static synchronized ConnectionPool getPool() {
        if (conPool_ == null) {
            conPool_ = new ConnectionPool(MAX_CONNECTIONS);
        }
        return conPool_;
    }

    public static synchronized void shutdown() {
        if (conPool_ != null) {
            if (ConnectionPool.conPool_.reaper_ != null) {
                ConnectionPool.conPool_.reaper_.shutdown();
            }
            conPool_ = null;
        }
    }

    private String getPassword() {
        return this.password_;
    }

    static {
        Properties sysProps = System.getProperties();
        StringBuffer drivers = new StringBuffer("com.sybase.jdbc3.jdbc.SybDriver");
        String oldDrivers = sysProps.getProperty("jdbc.drivers");
        if (oldDrivers != null) {
            drivers.append(":" + oldDrivers);
        }
        sysProps.put("jdbc.drivers", drivers.toString());
    }

    private class Reaper
    extends Thread {
        private ConnectionPool pool_;
        private Vector<Element> poolVec_;
        private boolean finished_;

        public Reaper(ConnectionPool pool, Vector<Element> poolVec) {
            super("ConnectionPool - Dead Connection Reaper");
            this.finished_ = false;
            this.pool_ = pool;
            this.poolVec_ = poolVec;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.finished_ = true;
            Reaper reaper = this;
            synchronized (reaper) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Element elem = null;
            while (!this.finished_) {
                long now = System.currentTimeMillis();
                ConnectionPool connectionPool = this.pool_;
                synchronized (connectionPool) {
                    for (int j = this.poolVec_.size() - 1; j >= 0; --j) {
                        elem = this.poolVec_.elementAt(j);
                        if (!elem.available || elem.last_released + MAX_IDLE_LIFETIME >= now && elem.creationTime + (long)MAX_LIFETIME >= now) continue;
                        stdlog_.debug("@@ reaper: last release " + elem.last_released);
                        this.poolVec_.removeElementAt(j);
                        this.forciblyCloseConnection(elem);
                    }
                }
                try {
                    Thread.sleep(REAPER_SLEEPTIME);
                }
                catch (InterruptedException e2) {}
            }
            Reaper reaper = this;
            synchronized (reaper) {
                this.notifyAll();
            }
        }

        public void forciblyCloseConnection(Element elem) {
            stdlog_.debug("@@ reaper: closing " + elem);
            try {
                ConnectionPool.this.closeConnection(elem.connection);
                elem.connection = null;
            }
            catch (SQLException e2) {
                e2.printStackTrace();
            }
        }
    }

    protected static class Element {
        public String dbaseName;
        public boolean available;
        public Connection connection;
        public long last_released;
        public long creationTime;

        protected Element() {
        }

        public String toString() {
            return "Element[dbaseName=" + this.dbaseName + ",available=" + this.available + ",last_released=" + this.last_released + ",creationTime=" + this.creationTime + "]";
        }
    }
}

