/*
 * Decompiled with CFR 0.152.
 */
package org.eso.util.misc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.Semaphore;
import org.apache.log4j.Logger;

class StreamConsumptionThread
extends Thread {
    static final Logger logger = Logger.getLogger(StreamConsumptionThread.class);
    private static final String classLogName = "StreamConsumptionThread";
    private static final String EOL = System.getProperty("line.separator");
    private static final int READ_BUFFER_SIZE = 1024;
    private static final int STREAM_POLLING_INTERVAL = 100;
    private volatile InputStream inputStream = null;
    private StringBuffer consumedStringBuffer = null;
    private String consumedString = null;
    private final Semaphore consumedStringPermit = new Semaphore(0);
    private final Semaphore streamConsumptionPermit = new Semaphore(0);
    private boolean newStreamConsumptionThread = true;
    private volatile boolean isConsumingStream = false;
    private volatile boolean abortStreamConsumption = false;
    private volatile boolean good = true;
    private final Semaphore activationSemaphore = new Semaphore(0);
    private volatile boolean terminate = false;

    StreamConsumptionThread(String threadName) {
        String methodLogName = "StreamConsumptionThread::StreamConsumptionThread()";
        logger.trace("StreamConsumptionThread::StreamConsumptionThread()");
        if (threadName != null) {
            logger.debug("StreamConsumptionThread::StreamConsumptionThread() - starting stream consumption thread [" + threadName + "].");
            this.setName(threadName);
        } else {
            logger.debug("StreamConsumptionThread::StreamConsumptionThread() - starting stream consumption thread.");
        }
        this.setDaemon(true);
        this.start();
        this.activationSemaphore.acquireUninterruptibly();
    }

    synchronized void consumeStream(InputStream inputStream) throws IllegalStateException, NullPointerException {
        String methodLogName = "StreamConsumptionThread::consumeStream()";
        logger.trace("StreamConsumptionThread::consumeStream()");
        if (inputStream == null) {
            String message = "StreamConsumptionThread::consumeStream() - inputStream must not be null.";
            logger.fatal("StreamConsumptionThread::consumeStream() - inputStream must not be null.");
            throw new NullPointerException("StreamConsumptionThread::consumeStream() - inputStream must not be null.");
        }
        if (this.isConsumingStream) {
            String message = "StreamConsumptionThread::consumeStream() - this StreamConsumptionThread is currently consuming characters from a stream. It is not ready for a new consumeStream() call.";
            logger.fatal("StreamConsumptionThread::consumeStream() - this StreamConsumptionThread is currently consuming characters from a stream. It is not ready for a new consumeStream() call.");
            throw new IllegalStateException("StreamConsumptionThread::consumeStream() - this StreamConsumptionThread is currently consuming characters from a stream. It is not ready for a new consumeStream() call.");
        }
        if (this.newStreamConsumptionThread) {
            logger.debug("StreamConsumptionThread::consumeStream() - this is a new StreamConsumptionThread.");
            this.newStreamConsumptionThread = false;
        } else {
            this.consumedStringPermit.acquireUninterruptibly();
        }
        if (this.consumedStringPermit.availablePermits() != 0) {
            String message = "StreamConsumptionThread::consumeStream() - [consumedStringPermit] binary semaphore violation detected.";
            logger.fatal("StreamConsumptionThread::consumeStream() - [consumedStringPermit] binary semaphore violation detected.");
            throw new AssertionError((Object)"StreamConsumptionThread::consumeStream() - [consumedStringPermit] binary semaphore violation detected.");
        }
        logger.debug("StreamConsumptionThread::consumeStream() - setting new input stream.");
        this.inputStream = inputStream;
        this.abortStreamConsumption = false;
        this.consumedStringBuffer = new StringBuffer();
        this.consumedString = null;
        this.isConsumingStream = true;
        this.good = true;
        this.streamConsumptionPermit.release();
    }

    boolean isConsumingStream() {
        String methodLogName = "StreamConsumptionThread::isConsumingStream()";
        logger.trace("StreamConsumptionThread::isConsumingStream()");
        return this.isConsumingStream;
    }

    InputStream getInputStream() {
        String methodLogName = "StreamConsumptionThread::getInputStream()";
        logger.trace("StreamConsumptionThread::getInputStream()");
        return this.inputStream;
    }

    @Override
    public void run() {
        String methodLogName = "StreamConsumptionThread::run()";
        logger.trace("StreamConsumptionThread::run()");
        logger.debug("StreamConsumptionThread::run() - stream consumption thread started.");
        this.activationSemaphore.release();
        BufferedReader reader = null;
        char[] currentChars = new char[1024];
        int numCharsRead = 0;
        block6: while (!this.terminate) {
            logger.debug("StreamConsumptionThread::run() - waiting for a new input stream.");
            while (true) {
                try {
                    this.streamConsumptionPermit.acquire();
                }
                catch (InterruptedException ie) {
                    if (this.terminate) {
                        logger.debug("StreamConsumptionThread::run() - stream consumption thread interrupted for termination whilst acquiring semaphore.");
                        break block6;
                    }
                    if (this.abortStreamConsumption) continue;
                    logger.debug("StreamConsumptionThread::run() - unexpected interrupt received whilst waiting for stream consumption permit.");
                    continue;
                }
                break;
            }
            if (this.streamConsumptionPermit.availablePermits() != 0) {
                String message = "StreamConsumptionThread::run() - [streamConsumptionPermit] binary semaphore violation detected.";
                logger.fatal("StreamConsumptionThread::run() - [streamConsumptionPermit] binary semaphore violation detected.");
                throw new AssertionError((Object)"StreamConsumptionThread::run() - [streamConsumptionPermit] binary semaphore violation detected.");
            }
            logger.debug("StreamConsumptionThread::run() - new input stream set; preparing to consume it.");
            reader = new BufferedReader(new InputStreamReader(this.inputStream));
            try {
                while (true) {
                    if (this.abortStreamConsumption) {
                        logger.debug("StreamConsumptionThread::run() - stream consumption aborted.");
                        break;
                    }
                    if (this.terminate) {
                        logger.debug("StreamConsumptionThread::run() - terminating stream consumption thread.");
                        break block6;
                    }
                    numCharsRead = reader.read(currentChars, 0, 1024);
                    if (numCharsRead < 0) {
                        logger.debug("StreamConsumptionThread::run() - stream consumption complete.");
                        break;
                    }
                    if (numCharsRead > 0) {
                        this.consumedStringBuffer.append(currentChars, 0, numCharsRead);
                    }
                    if (numCharsRead > 0) continue;
                    try {
                        StreamConsumptionThread.sleep(100L);
                    }
                    catch (InterruptedException ie) {
                        if (this.abortStreamConsumption || this.terminate) {
                            logger.debug("StreamConsumptionThread::run() - stream consumption thread interrupted" + (this.abortStreamConsumption ? " to abort consumption" : " for termination") + " whilst sleeping.");
                            continue;
                        }
                        logger.debug("StreamConsumptionThread::run() - unexpected interrupt received whilst waiting to poll stream for data.");
                    }
                }
            }
            catch (IOException ioe) {
                logger.error("StreamConsumptionThread::run() - error [" + ioe.getMessage() + "] whilst reading from input stream.");
                this.good = false;
            }
            reader = null;
            this.inputStream = null;
            this.isConsumingStream = false;
            logger.debug("StreamConsumptionThread::run() - finished with input stream.");
            this.consumedString = this.consumedStringBuffer.toString();
            this.consumedStringPermit.release();
        }
        logger.debug("StreamConsumptionThread::run() - stream consumption thread terminated.");
    }

    boolean good() {
        String methodLogName = "StreamConsumptionThread::good()";
        logger.trace("StreamConsumptionThread::good()");
        return this.good;
    }

    void awaitStreamConsumption() {
        String methodLogName = "StreamConsumptionThread::awaitStreamConsumption()";
        logger.trace("StreamConsumptionThread::awaitStreamConsumption()");
        this.consumedStringPermit.acquireUninterruptibly();
        if (this.consumedStringPermit.availablePermits() != 0) {
            String message = "StreamConsumptionThread::awaitStreamConsumption() - [consumedStringPermit] binary semaphore violation detected.";
            logger.fatal("StreamConsumptionThread::awaitStreamConsumption() - [consumedStringPermit] binary semaphore violation detected.");
            throw new AssertionError((Object)"StreamConsumptionThread::awaitStreamConsumption() - [consumedStringPermit] binary semaphore violation detected.");
        }
        this.consumedStringPermit.release();
    }

    String getConsumedString() {
        String methodLogName = "StreamConsumptionThread::getConsumedString()";
        logger.trace("StreamConsumptionThread::getConsumedString()");
        this.consumedStringPermit.acquireUninterruptibly();
        if (this.consumedStringPermit.availablePermits() != 0) {
            String message = "StreamConsumptionThread::getConsumedString() - [consumedStringPermit] binary semaphore violation detected.";
            logger.fatal("StreamConsumptionThread::getConsumedString() - [consumedStringPermit] binary semaphore violation detected.");
            throw new AssertionError((Object)"StreamConsumptionThread::getConsumedString() - [consumedStringPermit] binary semaphore violation detected.");
        }
        String result = this.consumedString;
        this.consumedStringPermit.release();
        return result;
    }

    synchronized void abortStreamConsumption() {
        String methodLogName = "StreamConsumptionThread::abortStreamConsumption()";
        logger.trace("StreamConsumptionThread::abortStreamConsumption()");
        if (this.isConsumingStream) {
            this.abortStreamConsumption = true;
            logger.debug("StreamConsumptionThread::abortStreamConsumption() - thread [" + this.getName() + "] aborting stream consumption.");
            this.interrupt();
        } else {
            logger.debug("StreamConsumptionThread::abortStreamConsumption() - thread [" + this.getName() + "]: no stream is being consumed.");
        }
    }

    synchronized void terminate() {
        String methodLogName = "StreamConsumptionThread::terminate()";
        logger.trace("StreamConsumptionThread::terminate()");
        this.terminate = true;
        logger.debug("StreamConsumptionThread::terminate() - terminating; interrupting thread [" + this.getName() + "].");
        this.interrupt();
    }
}

