/*
Copyright 2024 Keyfactor

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

EJBCA REST Interface

API reference documentation.

API version: 1.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ejbca

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"os"
	"strings"
)

// V1ConfigdumpApiService V1ConfigdumpApi service
type V1ConfigdumpApiService service

type ApiGetJsonConfigdumpRequest struct {
	ctx          context.Context
	ApiService   *V1ConfigdumpApiService
	ignoreerrors *bool
	defaults     *bool
	externalcas  *bool
	include      *[]string
	exclude      *[]string
}

// Print a warning instead of aborting and throwing an exception on errors.
func (r ApiGetJsonConfigdumpRequest) Ignoreerrors(ignoreerrors bool) ApiGetJsonConfigdumpRequest {
	r.ignoreerrors = &ignoreerrors
	return r
}

// Also include fields having the default value.
func (r ApiGetJsonConfigdumpRequest) Defaults(defaults bool) ApiGetJsonConfigdumpRequest {
	r.defaults = &defaults
	return r
}

// Enables export of external CAs (i.e. CAs where there&#39;s only a certificate and nothing else)
func (r ApiGetJsonConfigdumpRequest) Externalcas(externalcas bool) ApiGetJsonConfigdumpRequest {
	r.externalcas = &externalcas
	return r
}

// Names of items/types to include in the export. The syntax is identical to that of exclude. For items of types that aren&#39;t listed, everything is included.
func (r ApiGetJsonConfigdumpRequest) Include(include []string) ApiGetJsonConfigdumpRequest {
	r.include = &include
	return r
}

// Names of items/types to exclude in the export, separated by semicolon. Type and name is separated by a colon, and wildcards \&quot;\\*\&quot; are allowed. Both are case-insensitive. E.g. exclude&#x3D;\&quot;\\*:Example CA;cryptotoken:Example\\*;systemconfiguration:\\*\&quot;.  Supported types are: ACMECONFIG/acme-config, CA/certification-authorities,  CRYPTOTOKEN/crypto-tokens, PUBLISHER/publishers, APPROVALPROFILE/approval-profiles, CERTPROFILE/certificate-profiles, EEPROFILE/end-entity-profiles, SERVICE/services, ROLE/admin-roles, KEYBINDING/internal-key-bindings, ADMINPREFS/admin-preferences, OCSPCONFIG/ocsp-configuration, PEERCONNECTOR/peer-connectors, SCEPCONFIG/scep-config, CMPCONFIG/cmp-config, ESTCONFIG/est-config, VALIDATOR/validators, CTLOG/ct-logs, EXTENDEDKEYUSAGE/extended-key-usage, CERTEXTENSION/custom-certificate-extensions,  OAUTHKEY/trusted-oauth-providers, AVAILABLEPROTOCOLS/available-protocols
func (r ApiGetJsonConfigdumpRequest) Exclude(exclude []string) ApiGetJsonConfigdumpRequest {
	r.exclude = &exclude
	return r
}

func (r ApiGetJsonConfigdumpRequest) Execute() ([]string, *http.Response, error) {
	return r.ApiService.GetJsonConfigdumpExecute(r)
}

/*
GetJsonConfigdump Get the configuration in JSON.

Returns the configdump data in JSON.

	@param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	@return ApiGetJsonConfigdumpRequest
*/
func (a *V1ConfigdumpApiService) GetJsonConfigdump(ctx context.Context) ApiGetJsonConfigdumpRequest {
	return ApiGetJsonConfigdumpRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

// Execute executes the request
//
//	@return []string
func (a *V1ConfigdumpApiService) GetJsonConfigdumpExecute(r ApiGetJsonConfigdumpRequest) ([]string, *http.Response, error) {
	var (
		localVarHTTPMethod  = http.MethodGet
		localVarPostBody    interface{}
		formFiles           []formFile
		localVarReturnValue []string
	)

	localBasePath := "/ejbca/ejbca-rest-api"

	localVarPath := localBasePath + "/v1/configdump"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.ignoreerrors != nil {
		parameterAddToQuery(localVarQueryParams, "ignoreerrors", r.ignoreerrors, "")
	}
	if r.defaults != nil {
		parameterAddToQuery(localVarQueryParams, "defaults", r.defaults, "")
	}
	if r.externalcas != nil {
		parameterAddToQuery(localVarQueryParams, "externalcas", r.externalcas, "")
	}
	if r.include != nil {
		t := *r.include
		parameterAddToQuery(localVarQueryParams, "include", t, "multi")
	}
	if r.exclude != nil {
		t := *r.exclude
		parameterAddToQuery(localVarQueryParams, "exclude", t, "multi")
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiGetJsonConfigdumpForTypeRequest struct {
	ctx          context.Context
	ApiService   *V1ConfigdumpApiService
	type_        string
	ignoreerrors *bool
	defaults     *bool
	externalcas  *bool
}

// Print a warning instead of aborting and throwing an exception on errors.
func (r ApiGetJsonConfigdumpForTypeRequest) Ignoreerrors(ignoreerrors bool) ApiGetJsonConfigdumpForTypeRequest {
	r.ignoreerrors = &ignoreerrors
	return r
}

// Also include fields having the default value.
func (r ApiGetJsonConfigdumpForTypeRequest) Defaults(defaults bool) ApiGetJsonConfigdumpForTypeRequest {
	r.defaults = &defaults
	return r
}

// Enables export of external CAs (i.e. CAs where there&#39;s only a certificate and nothing else)
func (r ApiGetJsonConfigdumpForTypeRequest) Externalcas(externalcas bool) ApiGetJsonConfigdumpForTypeRequest {
	r.externalcas = &externalcas
	return r
}

func (r ApiGetJsonConfigdumpForTypeRequest) Execute() ([]string, *http.Response, error) {
	return r.ApiService.GetJsonConfigdumpForTypeExecute(r)
}

/*
GetJsonConfigdumpForType Get the configuration for type in JSON.

Returns the configdump data in JSON.

	@param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	@param type_ Configuration type to export.  Supported types are: ACMECONFIG/acme-config, CA/certification-authorities,  CRYPTOTOKEN/crypto-tokens, PUBLISHER/publishers, APPROVALPROFILE/approval-profiles, CERTPROFILE/certificate-profiles, EEPROFILE/end-entity-profiles, SERVICE/services, ROLE/admin-roles, KEYBINDING/internal-key-bindings, ADMINPREFS/admin-preferences, OCSPCONFIG/ocsp-configuration, PEERCONNECTOR/peer-connectors, SCEPCONFIG/scep-config, CMPCONFIG/cmp-config, ESTCONFIG/est-config, VALIDATOR/validators, CTLOG/ct-logs, EXTENDEDKEYUSAGE/extended-key-usage, CERTEXTENSION/custom-certificate-extensions,  OAUTHKEY/trusted-oauth-providers, AVAILABLEPROTOCOLS/available-protocols
	@return ApiGetJsonConfigdumpForTypeRequest
*/
func (a *V1ConfigdumpApiService) GetJsonConfigdumpForType(ctx context.Context, type_ string) ApiGetJsonConfigdumpForTypeRequest {
	return ApiGetJsonConfigdumpForTypeRequest{
		ApiService: a,
		ctx:        ctx,
		type_:      type_,
	}
}

// Execute executes the request
//
//	@return []string
func (a *V1ConfigdumpApiService) GetJsonConfigdumpForTypeExecute(r ApiGetJsonConfigdumpForTypeRequest) ([]string, *http.Response, error) {
	var (
		localVarHTTPMethod  = http.MethodGet
		localVarPostBody    interface{}
		formFiles           []formFile
		localVarReturnValue []string
	)

	localBasePath := "/ejbca/ejbca-rest-api"

	localVarPath := localBasePath + "/v1/configdump/{type}"
	localVarPath = strings.Replace(localVarPath, "{"+"type"+"}", url.PathEscape(parameterValueToString(r.type_, "type_")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.ignoreerrors != nil {
		parameterAddToQuery(localVarQueryParams, "ignoreerrors", r.ignoreerrors, "")
	}
	if r.defaults != nil {
		parameterAddToQuery(localVarQueryParams, "defaults", r.defaults, "")
	}
	if r.externalcas != nil {
		parameterAddToQuery(localVarQueryParams, "externalcas", r.externalcas, "")
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiGetJsonConfigdumpForTypeAndSettingRequest struct {
	ctx          context.Context
	ApiService   *V1ConfigdumpApiService
	type_        string
	setting      string
	ignoreerrors *bool
	defaults     *bool
}

// Print a warning instead of aborting and throwing an exception on errors.
func (r ApiGetJsonConfigdumpForTypeAndSettingRequest) Ignoreerrors(ignoreerrors bool) ApiGetJsonConfigdumpForTypeAndSettingRequest {
	r.ignoreerrors = &ignoreerrors
	return r
}

// Also include fields having the default value.
func (r ApiGetJsonConfigdumpForTypeAndSettingRequest) Defaults(defaults bool) ApiGetJsonConfigdumpForTypeAndSettingRequest {
	r.defaults = &defaults
	return r
}

func (r ApiGetJsonConfigdumpForTypeAndSettingRequest) Execute() ([]string, *http.Response, error) {
	return r.ApiService.GetJsonConfigdumpForTypeAndSettingExecute(r)
}

/*
GetJsonConfigdumpForTypeAndSetting Get the configuration for a type and setting in JSON.

Returns the configdump data in JSON.

	@param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	@param type_ Configuration type to export.  Supported types are: ACMECONFIG/acme-config, CA/certification-authorities,  CRYPTOTOKEN/crypto-tokens, PUBLISHER/publishers, APPROVALPROFILE/approval-profiles, CERTPROFILE/certificate-profiles, EEPROFILE/end-entity-profiles, SERVICE/services, ROLE/admin-roles, KEYBINDING/internal-key-bindings, ADMINPREFS/admin-preferences, OCSPCONFIG/ocsp-configuration, PEERCONNECTOR/peer-connectors, SCEPCONFIG/scep-config, CMPCONFIG/cmp-config, ESTCONFIG/est-config, VALIDATOR/validators, CTLOG/ct-logs, EXTENDEDKEYUSAGE/extended-key-usage, CERTEXTENSION/custom-certificate-extensions,  OAUTHKEY/trusted-oauth-providers, AVAILABLEPROTOCOLS/available-protocols
	@param setting Individual configuration name to export
	@return ApiGetJsonConfigdumpForTypeAndSettingRequest
*/
func (a *V1ConfigdumpApiService) GetJsonConfigdumpForTypeAndSetting(ctx context.Context, type_ string, setting string) ApiGetJsonConfigdumpForTypeAndSettingRequest {
	return ApiGetJsonConfigdumpForTypeAndSettingRequest{
		ApiService: a,
		ctx:        ctx,
		type_:      type_,
		setting:    setting,
	}
}

// Execute executes the request
//
//	@return []string
func (a *V1ConfigdumpApiService) GetJsonConfigdumpForTypeAndSettingExecute(r ApiGetJsonConfigdumpForTypeAndSettingRequest) ([]string, *http.Response, error) {
	var (
		localVarHTTPMethod  = http.MethodGet
		localVarPostBody    interface{}
		formFiles           []formFile
		localVarReturnValue []string
	)

	localBasePath := "/ejbca/ejbca-rest-api"

	localVarPath := localBasePath + "/v1/configdump/{type}/{setting}"
	localVarPath = strings.Replace(localVarPath, "{"+"type"+"}", url.PathEscape(parameterValueToString(r.type_, "type_")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"setting"+"}", url.PathEscape(parameterValueToString(r.setting, "setting")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.ignoreerrors != nil {
		parameterAddToQuery(localVarQueryParams, "ignoreerrors", r.ignoreerrors, "")
	}
	if r.defaults != nil {
		parameterAddToQuery(localVarQueryParams, "defaults", r.defaults, "")
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiGetZipExportRequest struct {
	ctx          context.Context
	ApiService   *V1ConfigdumpApiService
	ignoreerrors *bool
	defaults     *bool
	externalcas  *bool
	include      *[]string
	exclude      *[]string
}

// Print a warning instead of aborting and throwing an exception on errors.
func (r ApiGetZipExportRequest) Ignoreerrors(ignoreerrors bool) ApiGetZipExportRequest {
	r.ignoreerrors = &ignoreerrors
	return r
}

// Also include fields having the default value.
func (r ApiGetZipExportRequest) Defaults(defaults bool) ApiGetZipExportRequest {
	r.defaults = &defaults
	return r
}

// Enables export of external CAs (i.e. CAs where there&#39;s only a certificate and nothing else)
func (r ApiGetZipExportRequest) Externalcas(externalcas bool) ApiGetZipExportRequest {
	r.externalcas = &externalcas
	return r
}

// Names of items/types to include in the export. The syntax is identical to that of exclude. For items of types that aren&#39;t listed, everything is included.
func (r ApiGetZipExportRequest) Include(include []string) ApiGetZipExportRequest {
	r.include = &include
	return r
}

// Names of items/types to exclude in the export, separated by semicolon. Type and name is separated by a colon, and wildcards \&quot;\\*\&quot; are allowed. Both are case-insensitive. E.g. exclude&#x3D;\&quot;\\*:Example CA;cryptotoken:Example\\*;systemconfiguration:\\*\&quot;.  Supported types are: ACMECONFIG/acme-config, CA/certification-authorities,  CRYPTOTOKEN/crypto-tokens, PUBLISHER/publishers, APPROVALPROFILE/approval-profiles, CERTPROFILE/certificate-profiles, EEPROFILE/end-entity-profiles, SERVICE/services, ROLE/admin-roles, KEYBINDING/internal-key-bindings, ADMINPREFS/admin-preferences, OCSPCONFIG/ocsp-configuration, PEERCONNECTOR/peer-connectors, SCEPCONFIG/scep-config, CMPCONFIG/cmp-config, ESTCONFIG/est-config, VALIDATOR/validators, CTLOG/ct-logs, EXTENDEDKEYUSAGE/extended-key-usage, CERTEXTENSION/custom-certificate-extensions,  OAUTHKEY/trusted-oauth-providers, AVAILABLEPROTOCOLS/available-protocols
func (r ApiGetZipExportRequest) Exclude(exclude []string) ApiGetZipExportRequest {
	r.exclude = &exclude
	return r
}

func (r ApiGetZipExportRequest) Execute() ([]string, *http.Response, error) {
	return r.ApiService.GetZipExportExecute(r)
}

/*
GetZipExport Get the configuration as a ZIP file.

Returns a zip archive of YAML files.

	@param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	@return ApiGetZipExportRequest
*/
func (a *V1ConfigdumpApiService) GetZipExport(ctx context.Context) ApiGetZipExportRequest {
	return ApiGetZipExportRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

// Execute executes the request
//
//	@return []string
func (a *V1ConfigdumpApiService) GetZipExportExecute(r ApiGetZipExportRequest) ([]string, *http.Response, error) {
	var (
		localVarHTTPMethod  = http.MethodGet
		localVarPostBody    interface{}
		formFiles           []formFile
		localVarReturnValue []string
	)

	localBasePath := "/ejbca/ejbca-rest-api"

	localVarPath := localBasePath + "/v1/configdump/configdump.zip"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.ignoreerrors != nil {
		parameterAddToQuery(localVarQueryParams, "ignoreerrors", r.ignoreerrors, "")
	}
	if r.defaults != nil {
		parameterAddToQuery(localVarQueryParams, "defaults", r.defaults, "")
	}
	if r.externalcas != nil {
		parameterAddToQuery(localVarQueryParams, "externalcas", r.externalcas, "")
	}
	if r.include != nil {
		t := *r.include
		parameterAddToQuery(localVarQueryParams, "include", t, "multi")
	}
	if r.exclude != nil {
		t := *r.exclude
		parameterAddToQuery(localVarQueryParams, "exclude", t, "multi")
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/zip"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiPostJsonImportRequest struct {
	ctx          context.Context
	ApiService   *V1ConfigdumpApiService
	ignoreerrors *bool
	initialize   *bool
	continue_    *bool
	overwrite    *string
	resolve      *string
	body         *string
}

// Add to warnings instead of aborting on errors.
func (r ApiPostJsonImportRequest) Ignoreerrors(ignoreerrors bool) ApiPostJsonImportRequest {
	r.ignoreerrors = &ignoreerrors
	return r
}

// Generate initial certificate for CAs on import
func (r ApiPostJsonImportRequest) Initialize(initialize bool) ApiPostJsonImportRequest {
	r.initialize = &initialize
	return r
}

// Continue on errors. Default is to abort.
func (r ApiPostJsonImportRequest) Continue_(continue_ bool) ApiPostJsonImportRequest {
	r.continue_ = &continue_
	return r
}

// How to handle already existing configuration. Options are abort,skip,yes
func (r ApiPostJsonImportRequest) Overwrite(overwrite string) ApiPostJsonImportRequest {
	r.overwrite = &overwrite
	return r
}

// How to resolve missing references. Options are abort,skip,default
func (r ApiPostJsonImportRequest) Resolve(resolve string) ApiPostJsonImportRequest {
	r.resolve = &resolve
	return r
}

// JSON data in configdump format
func (r ApiPostJsonImportRequest) Body(body string) ApiPostJsonImportRequest {
	r.body = &body
	return r
}

func (r ApiPostJsonImportRequest) Execute() (*ConfigdumpResults, *http.Response, error) {
	return r.ApiService.PostJsonImportExecute(r)
}

/*
PostJsonImport Put the configuration in JSON.

	@param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	@return ApiPostJsonImportRequest
*/
func (a *V1ConfigdumpApiService) PostJsonImport(ctx context.Context) ApiPostJsonImportRequest {
	return ApiPostJsonImportRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

// Execute executes the request
//
//	@return ConfigdumpResults
func (a *V1ConfigdumpApiService) PostJsonImportExecute(r ApiPostJsonImportRequest) (*ConfigdumpResults, *http.Response, error) {
	var (
		localVarHTTPMethod  = http.MethodPost
		localVarPostBody    interface{}
		formFiles           []formFile
		localVarReturnValue *ConfigdumpResults
	)

	localBasePath := "/ejbca/ejbca-rest-api"

	localVarPath := localBasePath + "/v1/configdump"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.ignoreerrors != nil {
		parameterAddToQuery(localVarQueryParams, "ignoreerrors", r.ignoreerrors, "")
	}
	if r.initialize != nil {
		parameterAddToQuery(localVarQueryParams, "initialize", r.initialize, "")
	}
	if r.continue_ != nil {
		parameterAddToQuery(localVarQueryParams, "continue", r.continue_, "")
	}
	if r.overwrite != nil {
		parameterAddToQuery(localVarQueryParams, "overwrite", r.overwrite, "")
	}
	if r.resolve != nil {
		parameterAddToQuery(localVarQueryParams, "resolve", r.resolve, "")
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.body
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiPostZipImportRequest struct {
	ctx          context.Context
	ApiService   *V1ConfigdumpApiService
	zipfile      *os.File
	ignoreerrors *bool
	initialize   *bool
	continue_    *bool
	overwrite    *string
	resolve      *string
}

// A zipfile containing directories of YAML files.
func (r ApiPostZipImportRequest) Zipfile(zipfile *os.File) ApiPostZipImportRequest {
	r.zipfile = zipfile
	return r
}

// Add to warnings instead of aborting on errors.
func (r ApiPostZipImportRequest) Ignoreerrors(ignoreerrors bool) ApiPostZipImportRequest {
	r.ignoreerrors = &ignoreerrors
	return r
}

// Generate initial certificate for CAs on import
func (r ApiPostZipImportRequest) Initialize(initialize bool) ApiPostZipImportRequest {
	r.initialize = &initialize
	return r
}

// Continue on errors. Default is to abort.
func (r ApiPostZipImportRequest) Continue_(continue_ bool) ApiPostZipImportRequest {
	r.continue_ = &continue_
	return r
}

// How to handle already existing configuration. Options are abort,skip,yes
func (r ApiPostZipImportRequest) Overwrite(overwrite string) ApiPostZipImportRequest {
	r.overwrite = &overwrite
	return r
}

// How to resolve missing references. Options are abort,skip,default
func (r ApiPostZipImportRequest) Resolve(resolve string) ApiPostZipImportRequest {
	r.resolve = &resolve
	return r
}

func (r ApiPostZipImportRequest) Execute() (*ConfigdumpResults, *http.Response, error) {
	return r.ApiService.PostZipImportExecute(r)
}

/*
PostZipImport Put the configuration as a ZIP file.

	@param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	@return ApiPostZipImportRequest
*/
func (a *V1ConfigdumpApiService) PostZipImport(ctx context.Context) ApiPostZipImportRequest {
	return ApiPostZipImportRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

// Execute executes the request
//
//	@return ConfigdumpResults
func (a *V1ConfigdumpApiService) PostZipImportExecute(r ApiPostZipImportRequest) (*ConfigdumpResults, *http.Response, error) {
	var (
		localVarHTTPMethod  = http.MethodPost
		localVarPostBody    interface{}
		formFiles           []formFile
		localVarReturnValue *ConfigdumpResults
	)

	localBasePath := "/ejbca/ejbca-rest-api"

	localVarPath := localBasePath + "/v1/configdump/configdump.zip"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	var zipfileLocalVarFormFileName string
	var zipfileLocalVarFileName string
	var zipfileLocalVarFileBytes []byte

	zipfileLocalVarFormFileName = "zipfile"

	zipfileLocalVarFile := r.zipfile

	if zipfileLocalVarFile != nil {
		fbs, _ := io.ReadAll(zipfileLocalVarFile)

		zipfileLocalVarFileBytes = fbs
		zipfileLocalVarFileName = zipfileLocalVarFile.Name()
		zipfileLocalVarFile.Close()
		formFiles = append(formFiles, formFile{fileBytes: zipfileLocalVarFileBytes, fileName: zipfileLocalVarFileName, formFileName: zipfileLocalVarFormFileName})
	}
	if r.ignoreerrors != nil {
		parameterAddToQuery(localVarFormParams, "ignoreerrors", r.ignoreerrors, "")
	}
	if r.initialize != nil {
		parameterAddToQuery(localVarFormParams, "initialize", r.initialize, "")
	}
	if r.continue_ != nil {
		parameterAddToQuery(localVarFormParams, "continue", r.continue_, "")
	}
	if r.overwrite != nil {
		parameterAddToQuery(localVarFormParams, "overwrite", r.overwrite, "")
	}
	if r.resolve != nil {
		parameterAddToQuery(localVarFormParams, "resolve", r.resolve, "")
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiStatus4Request struct {
	ctx        context.Context
	ApiService *V1ConfigdumpApiService
}

func (r ApiStatus4Request) Execute() (*RestResourceStatusRestResponse, *http.Response, error) {
	return r.ApiService.Status4Execute(r)
}

/*
Status4 Get the status of this REST Resource

Returns status, API version and EJBCA version.

	@param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	@return ApiStatus4Request
*/
func (a *V1ConfigdumpApiService) Status4(ctx context.Context) ApiStatus4Request {
	return ApiStatus4Request{
		ApiService: a,
		ctx:        ctx,
	}
}

// Execute executes the request
//
//	@return RestResourceStatusRestResponse
func (a *V1ConfigdumpApiService) Status4Execute(r ApiStatus4Request) (*RestResourceStatusRestResponse, *http.Response, error) {
	var (
		localVarHTTPMethod  = http.MethodGet
		localVarPostBody    interface{}
		formFiles           []formFile
		localVarReturnValue *RestResourceStatusRestResponse
	)

	localBasePath := "/ejbca/ejbca-rest-api"

	localVarPath := localBasePath + "/v1/configdump/status"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
