/*
Copyright 2024 Keyfactor

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

EJBCA REST Interface

API reference documentation.

API version: 1.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ejbca

import (
	"encoding/json"
)

// checks if the CertificateRestResponse type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &CertificateRestResponse{}

// CertificateRestResponse struct for CertificateRestResponse
type CertificateRestResponse struct {
	// Certificate
	Certificate *string `json:"certificate,omitempty"`
	// Hex Serial Number
	SerialNumber *string `json:"serial_number,omitempty"`
	// Response format
	ResponseFormat *string `json:"response_format,omitempty"`
	// Certificate chain
	CertificateChain []string `json:"certificate_chain,omitempty"`
	// Certificate profile name
	CertificateProfile *string `json:"certificate_profile,omitempty"`
	// End Entity profile name
	EndEntityProfile     *string `json:"end_entity_profile,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _CertificateRestResponse CertificateRestResponse

// NewCertificateRestResponse instantiates a new CertificateRestResponse object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewCertificateRestResponse() *CertificateRestResponse {
	this := CertificateRestResponse{}
	return &this
}

// NewCertificateRestResponseWithDefaults instantiates a new CertificateRestResponse object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewCertificateRestResponseWithDefaults() *CertificateRestResponse {
	this := CertificateRestResponse{}
	return &this
}

// GetCertificate returns the Certificate field value if set, zero value otherwise.
func (o *CertificateRestResponse) GetCertificate() string {
	if o == nil || isNil(o.Certificate) {
		var ret string
		return ret
	}
	return *o.Certificate
}

// GetCertificateOk returns a tuple with the Certificate field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CertificateRestResponse) GetCertificateOk() (*string, bool) {
	if o == nil || isNil(o.Certificate) {
		return nil, false
	}
	return o.Certificate, true
}

// HasCertificate returns a boolean if a field has been set.
func (o *CertificateRestResponse) HasCertificate() bool {
	if o != nil && !isNil(o.Certificate) {
		return true
	}

	return false
}

// SetCertificate gets a reference to the given string and assigns it to the Certificate field.
func (o *CertificateRestResponse) SetCertificate(v string) {
	o.Certificate = &v
}

// GetSerialNumber returns the SerialNumber field value if set, zero value otherwise.
func (o *CertificateRestResponse) GetSerialNumber() string {
	if o == nil || isNil(o.SerialNumber) {
		var ret string
		return ret
	}
	return *o.SerialNumber
}

// GetSerialNumberOk returns a tuple with the SerialNumber field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CertificateRestResponse) GetSerialNumberOk() (*string, bool) {
	if o == nil || isNil(o.SerialNumber) {
		return nil, false
	}
	return o.SerialNumber, true
}

// HasSerialNumber returns a boolean if a field has been set.
func (o *CertificateRestResponse) HasSerialNumber() bool {
	if o != nil && !isNil(o.SerialNumber) {
		return true
	}

	return false
}

// SetSerialNumber gets a reference to the given string and assigns it to the SerialNumber field.
func (o *CertificateRestResponse) SetSerialNumber(v string) {
	o.SerialNumber = &v
}

// GetResponseFormat returns the ResponseFormat field value if set, zero value otherwise.
func (o *CertificateRestResponse) GetResponseFormat() string {
	if o == nil || isNil(o.ResponseFormat) {
		var ret string
		return ret
	}
	return *o.ResponseFormat
}

// GetResponseFormatOk returns a tuple with the ResponseFormat field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CertificateRestResponse) GetResponseFormatOk() (*string, bool) {
	if o == nil || isNil(o.ResponseFormat) {
		return nil, false
	}
	return o.ResponseFormat, true
}

// HasResponseFormat returns a boolean if a field has been set.
func (o *CertificateRestResponse) HasResponseFormat() bool {
	if o != nil && !isNil(o.ResponseFormat) {
		return true
	}

	return false
}

// SetResponseFormat gets a reference to the given string and assigns it to the ResponseFormat field.
func (o *CertificateRestResponse) SetResponseFormat(v string) {
	o.ResponseFormat = &v
}

// GetCertificateChain returns the CertificateChain field value if set, zero value otherwise.
func (o *CertificateRestResponse) GetCertificateChain() []string {
	if o == nil || isNil(o.CertificateChain) {
		var ret []string
		return ret
	}
	return o.CertificateChain
}

// GetCertificateChainOk returns a tuple with the CertificateChain field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CertificateRestResponse) GetCertificateChainOk() ([]string, bool) {
	if o == nil || isNil(o.CertificateChain) {
		return nil, false
	}
	return o.CertificateChain, true
}

// HasCertificateChain returns a boolean if a field has been set.
func (o *CertificateRestResponse) HasCertificateChain() bool {
	if o != nil && !isNil(o.CertificateChain) {
		return true
	}

	return false
}

// SetCertificateChain gets a reference to the given []string and assigns it to the CertificateChain field.
func (o *CertificateRestResponse) SetCertificateChain(v []string) {
	o.CertificateChain = v
}

// GetCertificateProfile returns the CertificateProfile field value if set, zero value otherwise.
func (o *CertificateRestResponse) GetCertificateProfile() string {
	if o == nil || isNil(o.CertificateProfile) {
		var ret string
		return ret
	}
	return *o.CertificateProfile
}

// GetCertificateProfileOk returns a tuple with the CertificateProfile field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CertificateRestResponse) GetCertificateProfileOk() (*string, bool) {
	if o == nil || isNil(o.CertificateProfile) {
		return nil, false
	}
	return o.CertificateProfile, true
}

// HasCertificateProfile returns a boolean if a field has been set.
func (o *CertificateRestResponse) HasCertificateProfile() bool {
	if o != nil && !isNil(o.CertificateProfile) {
		return true
	}

	return false
}

// SetCertificateProfile gets a reference to the given string and assigns it to the CertificateProfile field.
func (o *CertificateRestResponse) SetCertificateProfile(v string) {
	o.CertificateProfile = &v
}

// GetEndEntityProfile returns the EndEntityProfile field value if set, zero value otherwise.
func (o *CertificateRestResponse) GetEndEntityProfile() string {
	if o == nil || isNil(o.EndEntityProfile) {
		var ret string
		return ret
	}
	return *o.EndEntityProfile
}

// GetEndEntityProfileOk returns a tuple with the EndEntityProfile field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CertificateRestResponse) GetEndEntityProfileOk() (*string, bool) {
	if o == nil || isNil(o.EndEntityProfile) {
		return nil, false
	}
	return o.EndEntityProfile, true
}

// HasEndEntityProfile returns a boolean if a field has been set.
func (o *CertificateRestResponse) HasEndEntityProfile() bool {
	if o != nil && !isNil(o.EndEntityProfile) {
		return true
	}

	return false
}

// SetEndEntityProfile gets a reference to the given string and assigns it to the EndEntityProfile field.
func (o *CertificateRestResponse) SetEndEntityProfile(v string) {
	o.EndEntityProfile = &v
}

func (o CertificateRestResponse) MarshalJSON() ([]byte, error) {
	toSerialize, err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o CertificateRestResponse) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !isNil(o.Certificate) {
		toSerialize["certificate"] = o.Certificate
	}
	if !isNil(o.SerialNumber) {
		toSerialize["serial_number"] = o.SerialNumber
	}
	if !isNil(o.ResponseFormat) {
		toSerialize["response_format"] = o.ResponseFormat
	}
	if !isNil(o.CertificateChain) {
		toSerialize["certificate_chain"] = o.CertificateChain
	}
	if !isNil(o.CertificateProfile) {
		toSerialize["certificate_profile"] = o.CertificateProfile
	}
	if !isNil(o.EndEntityProfile) {
		toSerialize["end_entity_profile"] = o.EndEntityProfile
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *CertificateRestResponse) UnmarshalJSON(bytes []byte) (err error) {
	varCertificateRestResponse := _CertificateRestResponse{}

	if err = json.Unmarshal(bytes, &varCertificateRestResponse); err == nil {
		*o = CertificateRestResponse(varCertificateRestResponse)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "certificate")
		delete(additionalProperties, "serial_number")
		delete(additionalProperties, "response_format")
		delete(additionalProperties, "certificate_chain")
		delete(additionalProperties, "certificate_profile")
		delete(additionalProperties, "end_entity_profile")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableCertificateRestResponse struct {
	value *CertificateRestResponse
	isSet bool
}

func (v NullableCertificateRestResponse) Get() *CertificateRestResponse {
	return v.value
}

func (v *NullableCertificateRestResponse) Set(val *CertificateRestResponse) {
	v.value = val
	v.isSet = true
}

func (v NullableCertificateRestResponse) IsSet() bool {
	return v.isSet
}

func (v *NullableCertificateRestResponse) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableCertificateRestResponse(val *CertificateRestResponse) *NullableCertificateRestResponse {
	return &NullableCertificateRestResponse{value: val, isSet: true}
}

func (v NullableCertificateRestResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableCertificateRestResponse) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
