/*
Copyright 2024 Keyfactor

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

EJBCA REST Interface

API reference documentation.

API version: 1.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ejbca

import (
	"encoding/json"
)

// checks if the EndEntityProfileResponse type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &EndEntityProfileResponse{}

// EndEntityProfileResponse struct for EndEntityProfileResponse
type EndEntityProfileResponse struct {
	// End Entity profile name
	EndEntityProfileName *string `json:"end_entity_profile_name,omitempty"`
	// List of Subject DN Attributes
	SubjectDistinguishedNameFields []string `json:"subject_distinguished_name_fields,omitempty"`
	// List of Subject Alternative Name fields
	SubjectAlternativeNameFields []string `json:"subject_alternative_name_fields,omitempty"`
	// List of available Certificate Profiles
	AvailableCertificateProfiles []string `json:"available_certificate_profiles,omitempty"`
	// List of available Certificate Authorities (CAs)
	AvailableCas         []string `json:"available_cas,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _EndEntityProfileResponse EndEntityProfileResponse

// NewEndEntityProfileResponse instantiates a new EndEntityProfileResponse object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewEndEntityProfileResponse() *EndEntityProfileResponse {
	this := EndEntityProfileResponse{}
	return &this
}

// NewEndEntityProfileResponseWithDefaults instantiates a new EndEntityProfileResponse object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewEndEntityProfileResponseWithDefaults() *EndEntityProfileResponse {
	this := EndEntityProfileResponse{}
	return &this
}

// GetEndEntityProfileName returns the EndEntityProfileName field value if set, zero value otherwise.
func (o *EndEntityProfileResponse) GetEndEntityProfileName() string {
	if o == nil || isNil(o.EndEntityProfileName) {
		var ret string
		return ret
	}
	return *o.EndEntityProfileName
}

// GetEndEntityProfileNameOk returns a tuple with the EndEntityProfileName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EndEntityProfileResponse) GetEndEntityProfileNameOk() (*string, bool) {
	if o == nil || isNil(o.EndEntityProfileName) {
		return nil, false
	}
	return o.EndEntityProfileName, true
}

// HasEndEntityProfileName returns a boolean if a field has been set.
func (o *EndEntityProfileResponse) HasEndEntityProfileName() bool {
	if o != nil && !isNil(o.EndEntityProfileName) {
		return true
	}

	return false
}

// SetEndEntityProfileName gets a reference to the given string and assigns it to the EndEntityProfileName field.
func (o *EndEntityProfileResponse) SetEndEntityProfileName(v string) {
	o.EndEntityProfileName = &v
}

// GetSubjectDistinguishedNameFields returns the SubjectDistinguishedNameFields field value if set, zero value otherwise.
func (o *EndEntityProfileResponse) GetSubjectDistinguishedNameFields() []string {
	if o == nil || isNil(o.SubjectDistinguishedNameFields) {
		var ret []string
		return ret
	}
	return o.SubjectDistinguishedNameFields
}

// GetSubjectDistinguishedNameFieldsOk returns a tuple with the SubjectDistinguishedNameFields field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EndEntityProfileResponse) GetSubjectDistinguishedNameFieldsOk() ([]string, bool) {
	if o == nil || isNil(o.SubjectDistinguishedNameFields) {
		return nil, false
	}
	return o.SubjectDistinguishedNameFields, true
}

// HasSubjectDistinguishedNameFields returns a boolean if a field has been set.
func (o *EndEntityProfileResponse) HasSubjectDistinguishedNameFields() bool {
	if o != nil && !isNil(o.SubjectDistinguishedNameFields) {
		return true
	}

	return false
}

// SetSubjectDistinguishedNameFields gets a reference to the given []string and assigns it to the SubjectDistinguishedNameFields field.
func (o *EndEntityProfileResponse) SetSubjectDistinguishedNameFields(v []string) {
	o.SubjectDistinguishedNameFields = v
}

// GetSubjectAlternativeNameFields returns the SubjectAlternativeNameFields field value if set, zero value otherwise.
func (o *EndEntityProfileResponse) GetSubjectAlternativeNameFields() []string {
	if o == nil || isNil(o.SubjectAlternativeNameFields) {
		var ret []string
		return ret
	}
	return o.SubjectAlternativeNameFields
}

// GetSubjectAlternativeNameFieldsOk returns a tuple with the SubjectAlternativeNameFields field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EndEntityProfileResponse) GetSubjectAlternativeNameFieldsOk() ([]string, bool) {
	if o == nil || isNil(o.SubjectAlternativeNameFields) {
		return nil, false
	}
	return o.SubjectAlternativeNameFields, true
}

// HasSubjectAlternativeNameFields returns a boolean if a field has been set.
func (o *EndEntityProfileResponse) HasSubjectAlternativeNameFields() bool {
	if o != nil && !isNil(o.SubjectAlternativeNameFields) {
		return true
	}

	return false
}

// SetSubjectAlternativeNameFields gets a reference to the given []string and assigns it to the SubjectAlternativeNameFields field.
func (o *EndEntityProfileResponse) SetSubjectAlternativeNameFields(v []string) {
	o.SubjectAlternativeNameFields = v
}

// GetAvailableCertificateProfiles returns the AvailableCertificateProfiles field value if set, zero value otherwise.
func (o *EndEntityProfileResponse) GetAvailableCertificateProfiles() []string {
	if o == nil || isNil(o.AvailableCertificateProfiles) {
		var ret []string
		return ret
	}
	return o.AvailableCertificateProfiles
}

// GetAvailableCertificateProfilesOk returns a tuple with the AvailableCertificateProfiles field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EndEntityProfileResponse) GetAvailableCertificateProfilesOk() ([]string, bool) {
	if o == nil || isNil(o.AvailableCertificateProfiles) {
		return nil, false
	}
	return o.AvailableCertificateProfiles, true
}

// HasAvailableCertificateProfiles returns a boolean if a field has been set.
func (o *EndEntityProfileResponse) HasAvailableCertificateProfiles() bool {
	if o != nil && !isNil(o.AvailableCertificateProfiles) {
		return true
	}

	return false
}

// SetAvailableCertificateProfiles gets a reference to the given []string and assigns it to the AvailableCertificateProfiles field.
func (o *EndEntityProfileResponse) SetAvailableCertificateProfiles(v []string) {
	o.AvailableCertificateProfiles = v
}

// GetAvailableCas returns the AvailableCas field value if set, zero value otherwise.
func (o *EndEntityProfileResponse) GetAvailableCas() []string {
	if o == nil || isNil(o.AvailableCas) {
		var ret []string
		return ret
	}
	return o.AvailableCas
}

// GetAvailableCasOk returns a tuple with the AvailableCas field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EndEntityProfileResponse) GetAvailableCasOk() ([]string, bool) {
	if o == nil || isNil(o.AvailableCas) {
		return nil, false
	}
	return o.AvailableCas, true
}

// HasAvailableCas returns a boolean if a field has been set.
func (o *EndEntityProfileResponse) HasAvailableCas() bool {
	if o != nil && !isNil(o.AvailableCas) {
		return true
	}

	return false
}

// SetAvailableCas gets a reference to the given []string and assigns it to the AvailableCas field.
func (o *EndEntityProfileResponse) SetAvailableCas(v []string) {
	o.AvailableCas = v
}

func (o EndEntityProfileResponse) MarshalJSON() ([]byte, error) {
	toSerialize, err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o EndEntityProfileResponse) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !isNil(o.EndEntityProfileName) {
		toSerialize["end_entity_profile_name"] = o.EndEntityProfileName
	}
	if !isNil(o.SubjectDistinguishedNameFields) {
		toSerialize["subject_distinguished_name_fields"] = o.SubjectDistinguishedNameFields
	}
	if !isNil(o.SubjectAlternativeNameFields) {
		toSerialize["subject_alternative_name_fields"] = o.SubjectAlternativeNameFields
	}
	if !isNil(o.AvailableCertificateProfiles) {
		toSerialize["available_certificate_profiles"] = o.AvailableCertificateProfiles
	}
	if !isNil(o.AvailableCas) {
		toSerialize["available_cas"] = o.AvailableCas
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *EndEntityProfileResponse) UnmarshalJSON(bytes []byte) (err error) {
	varEndEntityProfileResponse := _EndEntityProfileResponse{}

	if err = json.Unmarshal(bytes, &varEndEntityProfileResponse); err == nil {
		*o = EndEntityProfileResponse(varEndEntityProfileResponse)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "end_entity_profile_name")
		delete(additionalProperties, "subject_distinguished_name_fields")
		delete(additionalProperties, "subject_alternative_name_fields")
		delete(additionalProperties, "available_certificate_profiles")
		delete(additionalProperties, "available_cas")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableEndEntityProfileResponse struct {
	value *EndEntityProfileResponse
	isSet bool
}

func (v NullableEndEntityProfileResponse) Get() *EndEntityProfileResponse {
	return v.value
}

func (v *NullableEndEntityProfileResponse) Set(val *EndEntityProfileResponse) {
	v.value = val
	v.isSet = true
}

func (v NullableEndEntityProfileResponse) IsSet() bool {
	return v.isSet
}

func (v *NullableEndEntityProfileResponse) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableEndEntityProfileResponse(val *EndEntityProfileResponse) *NullableEndEntityProfileResponse {
	return &NullableEndEntityProfileResponse{value: val, isSet: true}
}

func (v NullableEndEntityProfileResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableEndEntityProfileResponse) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
