/*
Copyright 2024 Keyfactor

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

EJBCA REST Interface

API reference documentation.

API version: 1.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ejbca

import (
	"encoding/json"
)

// checks if the KeyStoreRestRequest type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &KeyStoreRestRequest{}

// KeyStoreRestRequest struct for KeyStoreRestRequest
type KeyStoreRestRequest struct {
	// Username
	Username *string `json:"username,omitempty"`
	// Password
	Password *string `json:"password,omitempty"`
	// Key algorithm used for enrollment
	KeyAlg *string `json:"key_alg,omitempty"`
	// Key specification to use
	KeySpec              *string `json:"key_spec,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _KeyStoreRestRequest KeyStoreRestRequest

// NewKeyStoreRestRequest instantiates a new KeyStoreRestRequest object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewKeyStoreRestRequest() *KeyStoreRestRequest {
	this := KeyStoreRestRequest{}
	return &this
}

// NewKeyStoreRestRequestWithDefaults instantiates a new KeyStoreRestRequest object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewKeyStoreRestRequestWithDefaults() *KeyStoreRestRequest {
	this := KeyStoreRestRequest{}
	return &this
}

// GetUsername returns the Username field value if set, zero value otherwise.
func (o *KeyStoreRestRequest) GetUsername() string {
	if o == nil || isNil(o.Username) {
		var ret string
		return ret
	}
	return *o.Username
}

// GetUsernameOk returns a tuple with the Username field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *KeyStoreRestRequest) GetUsernameOk() (*string, bool) {
	if o == nil || isNil(o.Username) {
		return nil, false
	}
	return o.Username, true
}

// HasUsername returns a boolean if a field has been set.
func (o *KeyStoreRestRequest) HasUsername() bool {
	if o != nil && !isNil(o.Username) {
		return true
	}

	return false
}

// SetUsername gets a reference to the given string and assigns it to the Username field.
func (o *KeyStoreRestRequest) SetUsername(v string) {
	o.Username = &v
}

// GetPassword returns the Password field value if set, zero value otherwise.
func (o *KeyStoreRestRequest) GetPassword() string {
	if o == nil || isNil(o.Password) {
		var ret string
		return ret
	}
	return *o.Password
}

// GetPasswordOk returns a tuple with the Password field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *KeyStoreRestRequest) GetPasswordOk() (*string, bool) {
	if o == nil || isNil(o.Password) {
		return nil, false
	}
	return o.Password, true
}

// HasPassword returns a boolean if a field has been set.
func (o *KeyStoreRestRequest) HasPassword() bool {
	if o != nil && !isNil(o.Password) {
		return true
	}

	return false
}

// SetPassword gets a reference to the given string and assigns it to the Password field.
func (o *KeyStoreRestRequest) SetPassword(v string) {
	o.Password = &v
}

// GetKeyAlg returns the KeyAlg field value if set, zero value otherwise.
func (o *KeyStoreRestRequest) GetKeyAlg() string {
	if o == nil || isNil(o.KeyAlg) {
		var ret string
		return ret
	}
	return *o.KeyAlg
}

// GetKeyAlgOk returns a tuple with the KeyAlg field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *KeyStoreRestRequest) GetKeyAlgOk() (*string, bool) {
	if o == nil || isNil(o.KeyAlg) {
		return nil, false
	}
	return o.KeyAlg, true
}

// HasKeyAlg returns a boolean if a field has been set.
func (o *KeyStoreRestRequest) HasKeyAlg() bool {
	if o != nil && !isNil(o.KeyAlg) {
		return true
	}

	return false
}

// SetKeyAlg gets a reference to the given string and assigns it to the KeyAlg field.
func (o *KeyStoreRestRequest) SetKeyAlg(v string) {
	o.KeyAlg = &v
}

// GetKeySpec returns the KeySpec field value if set, zero value otherwise.
func (o *KeyStoreRestRequest) GetKeySpec() string {
	if o == nil || isNil(o.KeySpec) {
		var ret string
		return ret
	}
	return *o.KeySpec
}

// GetKeySpecOk returns a tuple with the KeySpec field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *KeyStoreRestRequest) GetKeySpecOk() (*string, bool) {
	if o == nil || isNil(o.KeySpec) {
		return nil, false
	}
	return o.KeySpec, true
}

// HasKeySpec returns a boolean if a field has been set.
func (o *KeyStoreRestRequest) HasKeySpec() bool {
	if o != nil && !isNil(o.KeySpec) {
		return true
	}

	return false
}

// SetKeySpec gets a reference to the given string and assigns it to the KeySpec field.
func (o *KeyStoreRestRequest) SetKeySpec(v string) {
	o.KeySpec = &v
}

func (o KeyStoreRestRequest) MarshalJSON() ([]byte, error) {
	toSerialize, err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o KeyStoreRestRequest) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !isNil(o.Username) {
		toSerialize["username"] = o.Username
	}
	if !isNil(o.Password) {
		toSerialize["password"] = o.Password
	}
	if !isNil(o.KeyAlg) {
		toSerialize["key_alg"] = o.KeyAlg
	}
	if !isNil(o.KeySpec) {
		toSerialize["key_spec"] = o.KeySpec
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *KeyStoreRestRequest) UnmarshalJSON(bytes []byte) (err error) {
	varKeyStoreRestRequest := _KeyStoreRestRequest{}

	if err = json.Unmarshal(bytes, &varKeyStoreRestRequest); err == nil {
		*o = KeyStoreRestRequest(varKeyStoreRestRequest)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "username")
		delete(additionalProperties, "password")
		delete(additionalProperties, "key_alg")
		delete(additionalProperties, "key_spec")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableKeyStoreRestRequest struct {
	value *KeyStoreRestRequest
	isSet bool
}

func (v NullableKeyStoreRestRequest) Get() *KeyStoreRestRequest {
	return v.value
}

func (v *NullableKeyStoreRestRequest) Set(val *KeyStoreRestRequest) {
	v.value = val
	v.isSet = true
}

func (v NullableKeyStoreRestRequest) IsSet() bool {
	return v.isSet
}

func (v *NullableKeyStoreRestRequest) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableKeyStoreRestRequest(val *KeyStoreRestRequest) *NullableKeyStoreRestRequest {
	return &NullableKeyStoreRestRequest{value: val, isSet: true}
}

func (v NullableKeyStoreRestRequest) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableKeyStoreRestRequest) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
