// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	"errors"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	smithywaiter "github.com/aws/smithy-go/waiter"
	"strconv"
	"time"
)

// Describes the specified instances or all instances.
//
// If you specify instance IDs, the output includes information for only the
// specified instances. If you specify filters, the output includes information for
// only those instances that meet the filter criteria. If you do not specify
// instance IDs or filters, the output includes information for all instances,
// which can affect performance. We recommend that you use pagination to ensure
// that the operation returns quickly and successfully.
//
// If you specify an instance ID that is not valid, an error is returned. If you
// specify an instance that you do not own, it is not included in the output.
//
// Recently terminated instances might appear in the returned results. This
// interval is usually less than one hour.
//
// If you describe instances in the rare case where an Availability Zone is
// experiencing a service disruption and you specify instance IDs that are in the
// affected zone, or do not specify any instance IDs at all, the call fails. If you
// describe instances and specify only instance IDs that are in an unaffected zone,
// the call works normally.
//
// We strongly recommend using only paginated requests. Unpaginated requests are
// susceptible to throttling and timeouts.
//
// The order of the elements in the response, including those within nested
// structures, might vary. Applications should not assume the elements appear in a
// particular order.
func (c *Client) DescribeInstances(ctx context.Context, params *DescribeInstancesInput, optFns ...func(*Options)) (*DescribeInstancesOutput, error) {
	if params == nil {
		params = &DescribeInstancesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeInstances", params, optFns, c.addOperationDescribeInstancesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeInstancesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeInstancesInput struct {

	// Checks whether you have the required permissions for the operation, without
	// actually making the request, and provides an error response. If you have the
	// required permissions, the error response is DryRunOperation . Otherwise, it is
	// UnauthorizedOperation .
	DryRun *bool

	// The filters.
	//
	//   - affinity - The affinity setting for an instance running on a Dedicated Host (
	//   default | host ).
	//
	//   - architecture - The instance architecture ( i386 | x86_64 | arm64 ).
	//
	//   - availability-zone - The Availability Zone of the instance.
	//
	//   - block-device-mapping.attach-time - The attach time for an EBS volume mapped
	//   to the instance, for example, 2022-09-15T17:15:20.000Z .
	//
	//   - block-device-mapping.delete-on-termination - A Boolean that indicates
	//   whether the EBS volume is deleted on instance termination.
	//
	//   - block-device-mapping.device-name - The device name specified in the block
	//   device mapping (for example, /dev/sdh or xvdh ).
	//
	//   - block-device-mapping.status - The status for the EBS volume ( attaching |
	//   attached | detaching | detached ).
	//
	//   - block-device-mapping.volume-id - The volume ID of the EBS volume.
	//
	//   - boot-mode - The boot mode that was specified by the AMI ( legacy-bios | uefi
	//   | uefi-preferred ).
	//
	//   - capacity-reservation-id - The ID of the Capacity Reservation into which the
	//   instance was launched.
	//
	//   - capacity-reservation-specification.capacity-reservation-preference - The
	//   instance's Capacity Reservation preference ( open | none ).
	//
	//   -
	//   capacity-reservation-specification.capacity-reservation-target.capacity-reservation-id
	//   - The ID of the targeted Capacity Reservation.
	//
	//   -
	//   capacity-reservation-specification.capacity-reservation-target.capacity-reservation-resource-group-arn
	//   - The ARN of the targeted Capacity Reservation group.
	//
	//   - client-token - The idempotency token you provided when you launched the
	//   instance.
	//
	//   - current-instance-boot-mode - The boot mode that is used to launch the
	//   instance at launch or start ( legacy-bios | uefi ).
	//
	//   - dns-name - The public DNS name of the instance.
	//
	//   - ebs-optimized - A Boolean that indicates whether the instance is optimized
	//   for Amazon EBS I/O.
	//
	//   - ena-support - A Boolean that indicates whether the instance is enabled for
	//   enhanced networking with ENA.
	//
	//   - enclave-options.enabled - A Boolean that indicates whether the instance is
	//   enabled for Amazon Web Services Nitro Enclaves.
	//
	//   - hibernation-options.configured - A Boolean that indicates whether the
	//   instance is enabled for hibernation. A value of true means that the instance
	//   is enabled for hibernation.
	//
	//   - host-id - The ID of the Dedicated Host on which the instance is running, if
	//   applicable.
	//
	//   - hypervisor - The hypervisor type of the instance ( ovm | xen ). The value
	//   xen is used for both Xen and Nitro hypervisors.
	//
	//   - iam-instance-profile.arn - The instance profile associated with the
	//   instance. Specified as an ARN.
	//
	//   - iam-instance-profile.id - The instance profile associated with the instance.
	//   Specified as an ID.
	//
	//   - image-id - The ID of the image used to launch the instance.
	//
	//   - instance-id - The ID of the instance.
	//
	//   - instance-lifecycle - Indicates whether this is a Spot Instance, a Scheduled
	//   Instance, or a Capacity Block ( spot | scheduled | capacity-block ).
	//
	//   - instance-state-code - The state of the instance, as a 16-bit unsigned
	//   integer. The high byte is used for internal purposes and should be ignored. The
	//   low byte is set based on the state represented. The valid values are: 0
	//   (pending), 16 (running), 32 (shutting-down), 48 (terminated), 64 (stopping), and
	//   80 (stopped).
	//
	//   - instance-state-name - The state of the instance ( pending | running |
	//   shutting-down | terminated | stopping | stopped ).
	//
	//   - instance-type - The type of instance (for example, t2.micro ).
	//
	//   - instance.group-id - The ID of the security group for the instance.
	//
	//   - instance.group-name - The name of the security group for the instance.
	//
	//   - ip-address - The public IPv4 address of the instance.
	//
	//   - ipv6-address - The IPv6 address of the instance.
	//
	//   - kernel-id - The kernel ID.
	//
	//   - key-name - The name of the key pair used when the instance was launched.
	//
	//   - launch-index - When launching multiple instances, this is the index for the
	//   instance in the launch group (for example, 0, 1, 2, and so on).
	//
	//   - launch-time - The time when the instance was launched, in the ISO 8601
	//   format in the UTC time zone (YYYY-MM-DDThh:mm:ss.sssZ), for example,
	//   2021-09-29T11:04:43.305Z . You can use a wildcard ( * ), for example,
	//   2021-09-29T* , which matches an entire day.
	//
	//   - maintenance-options.auto-recovery - The current automatic recovery behavior
	//   of the instance ( disabled | default ).
	//
	//   - metadata-options.http-endpoint - The status of access to the HTTP metadata
	//   endpoint on your instance ( enabled | disabled )
	//
	//   - metadata-options.http-protocol-ipv4 - Indicates whether the IPv4 endpoint is
	//   enabled ( disabled | enabled ).
	//
	//   - metadata-options.http-protocol-ipv6 - Indicates whether the IPv6 endpoint is
	//   enabled ( disabled | enabled ).
	//
	//   - metadata-options.http-put-response-hop-limit - The HTTP metadata request put
	//   response hop limit (integer, possible values 1 to 64 )
	//
	//   - metadata-options.http-tokens - The metadata request authorization state (
	//   optional | required )
	//
	//   - metadata-options.instance-metadata-tags - The status of access to instance
	//   tags from the instance metadata ( enabled | disabled )
	//
	//   - metadata-options.state - The state of the metadata option changes ( pending
	//   | applied ).
	//
	//   - monitoring-state - Indicates whether detailed monitoring is enabled (
	//   disabled | enabled ).
	//
	//   - network-interface.addresses.association.allocation-id - The allocation ID.
	//
	//   - network-interface.addresses.association.association-id - The association ID.
	//
	//   - network-interface.addresses.association.carrier-ip - The carrier IP address.
	//
	//   - network-interface.addresses.association.customer-owned-ip - The
	//   customer-owned IP address.
	//
	//   - network-interface.addresses.association.ip-owner-id - The owner ID of the
	//   private IPv4 address associated with the network interface.
	//
	//   - network-interface.addresses.association.public-dns-name - The public DNS
	//   name.
	//
	//   - network-interface.addresses.association.public-ip - The ID of the
	//   association of an Elastic IP address (IPv4) with a network interface.
	//
	//   - network-interface.addresses.primary - Specifies whether the IPv4 address of
	//   the network interface is the primary private IPv4 address.
	//
	//   - network-interface.addresses.private-dns-name - The private DNS name.
	//
	//   - network-interface.addresses.private-ip-address - The private IPv4 address
	//   associated with the network interface.
	//
	//   - network-interface.association.allocation-id - The allocation ID returned
	//   when you allocated the Elastic IP address (IPv4) for your network interface.
	//
	//   - network-interface.association.association-id - The association ID returned
	//   when the network interface was associated with an IPv4 address.
	//
	//   - network-interface.association.carrier-ip - The customer-owned IP address.
	//
	//   - network-interface.association.customer-owned-ip - The customer-owned IP
	//   address.
	//
	//   - network-interface.association.ip-owner-id - The owner of the Elastic IP
	//   address (IPv4) associated with the network interface.
	//
	//   - network-interface.association.public-dns-name - The public DNS name.
	//
	//   - network-interface.association.public-ip - The address of the Elastic IP
	//   address (IPv4) bound to the network interface.
	//
	//   - network-interface.attachment.attach-time - The time that the network
	//   interface was attached to an instance.
	//
	//   - network-interface.attachment.attachment-id - The ID of the interface
	//   attachment.
	//
	//   - network-interface.attachment.delete-on-termination - Specifies whether the
	//   attachment is deleted when an instance is terminated.
	//
	//   - network-interface.attachment.device-index - The device index to which the
	//   network interface is attached.
	//
	//   - network-interface.attachment.instance-id - The ID of the instance to which
	//   the network interface is attached.
	//
	//   - network-interface.attachment.instance-owner-id - The owner ID of the
	//   instance to which the network interface is attached.
	//
	//   - network-interface.attachment.network-card-index - The index of the network
	//   card.
	//
	//   - network-interface.attachment.status - The status of the attachment (
	//   attaching | attached | detaching | detached ).
	//
	//   - network-interface.availability-zone - The Availability Zone for the network
	//   interface.
	//
	//   - network-interface.deny-all-igw-traffic - A Boolean that indicates whether a
	//   network interface with an IPv6 address is unreachable from the public internet.
	//
	//   - network-interface.description - The description of the network interface.
	//
	//   - network-interface.group-id - The ID of a security group associated with the
	//   network interface.
	//
	//   - network-interface.group-name - The name of a security group associated with
	//   the network interface.
	//
	//   - network-interface.ipv4-prefixes.ipv4-prefix - The IPv4 prefixes that are
	//   assigned to the network interface.
	//
	//   - network-interface.ipv6-address - The IPv6 address associated with the
	//   network interface.
	//
	//   - network-interface.ipv6-addresses.ipv6-address - The IPv6 address associated
	//   with the network interface.
	//
	//   - network-interface.ipv6-addresses.is-primary-ipv6 - A Boolean that indicates
	//   whether this is the primary IPv6 address.
	//
	//   - network-interface.ipv6-native - A Boolean that indicates whether this is an
	//   IPv6 only network interface.
	//
	//   - network-interface.ipv6-prefixes.ipv6-prefix - The IPv6 prefix assigned to
	//   the network interface.
	//
	//   - network-interface.mac-address - The MAC address of the network interface.
	//
	//   - network-interface.network-interface-id - The ID of the network interface.
	//
	//   - network-interface.operator.managed - A Boolean that indicates whether the
	//   instance has a managed network interface.
	//
	//   - network-interface.operator.principal - The principal that manages the
	//   network interface. Only valid for instances with managed network interfaces,
	//   where managed is true .
	//
	//   - network-interface.outpost-arn - The ARN of the Outpost.
	//
	//   - network-interface.owner-id - The ID of the owner of the network interface.
	//
	//   - network-interface.private-dns-name - The private DNS name of the network
	//   interface.
	//
	//   - network-interface.private-ip-address - The private IPv4 address.
	//
	//   - network-interface.public-dns-name - The public DNS name.
	//
	//   - network-interface.requester-id - The requester ID for the network interface.
	//
	//   - network-interface.requester-managed - Indicates whether the network
	//   interface is being managed by Amazon Web Services.
	//
	//   - network-interface.status - The status of the network interface ( available )
	//   | in-use ).
	//
	//   - network-interface.source-dest-check - Whether the network interface performs
	//   source/destination checking. A value of true means that checking is enabled,
	//   and false means that checking is disabled. The value must be false for the
	//   network interface to perform network address translation (NAT) in your VPC.
	//
	//   - network-interface.subnet-id - The ID of the subnet for the network interface.
	//
	//   - network-interface.tag-key - The key of a tag assigned to the network
	//   interface.
	//
	//   - network-interface.tag-value - The value of a tag assigned to the network
	//   interface.
	//
	//   - network-interface.vpc-id - The ID of the VPC for the network interface.
	//
	//   - operator.managed - A Boolean that indicates whether this is a managed
	//   instance.
	//
	//   - operator.principal - The principal that manages the instance. Only valid for
	//   managed instances, where managed is true .
	//
	//   - outpost-arn - The Amazon Resource Name (ARN) of the Outpost.
	//
	//   - owner-id - The Amazon Web Services account ID of the instance owner.
	//
	//   - placement-group-name - The name of the placement group for the instance.
	//
	//   - placement-partition-number - The partition in which the instance is located.
	//
	//   - platform - The platform. To list only Windows instances, use windows .
	//
	//   - platform-details - The platform ( Linux/UNIX | Red Hat BYOL Linux | Red Hat
	//   Enterprise Linux | Red Hat Enterprise Linux with HA | Red Hat Enterprise
	//   Linux with SQL Server Standard and HA | Red Hat Enterprise Linux with SQL
	//   Server Enterprise and HA | Red Hat Enterprise Linux with SQL Server Standard |
	//   Red Hat Enterprise Linux with SQL Server Web | Red Hat Enterprise Linux with
	//   SQL Server Enterprise | SQL Server Enterprise | SQL Server Standard | SQL
	//   Server Web | SUSE Linux | Ubuntu Pro | Windows | Windows BYOL | Windows with
	//   SQL Server Enterprise | Windows with SQL Server Standard | Windows with SQL
	//   Server Web ).
	//
	//   - private-dns-name - The private IPv4 DNS name of the instance.
	//
	//   - private-dns-name-options.enable-resource-name-dns-a-record - A Boolean that
	//   indicates whether to respond to DNS queries for instance hostnames with DNS A
	//   records.
	//
	//   - private-dns-name-options.enable-resource-name-dns-aaaa-record - A Boolean
	//   that indicates whether to respond to DNS queries for instance hostnames with DNS
	//   AAAA records.
	//
	//   - private-dns-name-options.hostname-type - The type of hostname ( ip-name |
	//   resource-name ).
	//
	//   - private-ip-address - The private IPv4 address of the instance. This can only
	//   be used to filter by the primary IP address of the network interface attached to
	//   the instance. To filter by additional IP addresses assigned to the network
	//   interface, use the filter network-interface.addresses.private-ip-address .
	//
	//   - product-code - The product code associated with the AMI used to launch the
	//   instance.
	//
	//   - product-code.type - The type of product code ( devpay | marketplace ).
	//
	//   - ramdisk-id - The RAM disk ID.
	//
	//   - reason - The reason for the current state of the instance (for example,
	//   shows "User Initiated [date]" when you stop or terminate the instance). Similar
	//   to the state-reason-code filter.
	//
	//   - requester-id - The ID of the entity that launched the instance on your
	//   behalf (for example, Amazon Web Services Management Console, Auto Scaling, and
	//   so on).
	//
	//   - reservation-id - The ID of the instance's reservation. A reservation ID is
	//   created any time you launch an instance. A reservation ID has a one-to-one
	//   relationship with an instance launch request, but can be associated with more
	//   than one instance if you launch multiple instances using the same launch
	//   request. For example, if you launch one instance, you get one reservation ID. If
	//   you launch ten instances using the same launch request, you also get one
	//   reservation ID.
	//
	//   - root-device-name - The device name of the root device volume (for example,
	//   /dev/sda1 ).
	//
	//   - root-device-type - The type of the root device volume ( ebs | instance-store
	//   ).
	//
	//   - source-dest-check - Indicates whether the instance performs
	//   source/destination checking. A value of true means that checking is enabled,
	//   and false means that checking is disabled. The value must be false for the
	//   instance to perform network address translation (NAT) in your VPC.
	//
	//   - spot-instance-request-id - The ID of the Spot Instance request.
	//
	//   - state-reason-code - The reason code for the state change.
	//
	//   - state-reason-message - A message that describes the state change.
	//
	//   - subnet-id - The ID of the subnet for the instance.
	//
	//   - tag: - The key/value combination of a tag assigned to the resource. Use the
	//   tag key in the filter name and the tag value as the filter value. For example,
	//   to find all resources that have a tag with the key Owner and the value TeamA ,
	//   specify tag:Owner for the filter name and TeamA for the filter value.
	//
	//   - tag-key - The key of a tag assigned to the resource. Use this filter to find
	//   all resources that have a tag with a specific key, regardless of the tag value.
	//
	//   - tenancy - The tenancy of an instance ( dedicated | default | host ).
	//
	//   - tpm-support - Indicates if the instance is configured for NitroTPM support (
	//   v2.0 ).
	//
	//   - usage-operation - The usage operation value for the instance ( RunInstances
	//   | RunInstances:00g0 | RunInstances:0010 | RunInstances:1010 |
	//   RunInstances:1014 | RunInstances:1110 | RunInstances:0014 | RunInstances:0210
	//   | RunInstances:0110 | RunInstances:0100 | RunInstances:0004 |
	//   RunInstances:0200 | RunInstances:000g | RunInstances:0g00 | RunInstances:0002
	//   | RunInstances:0800 | RunInstances:0102 | RunInstances:0006 |
	//   RunInstances:0202 ).
	//
	//   - usage-operation-update-time - The time that the usage operation was last
	//   updated, for example, 2022-09-15T17:15:20.000Z .
	//
	//   - virtualization-type - The virtualization type of the instance ( paravirtual
	//   | hvm ).
	//
	//   - vpc-id - The ID of the VPC that the instance is running in.
	Filters []types.Filter

	// The instance IDs.
	//
	// Default: Describes all your instances.
	InstanceIds []string

	// The maximum number of items to return for this request. To get the next page of
	// items, make another request with the token returned in the output. For more
	// information, see [Pagination].
	//
	// You cannot specify this parameter and the instance IDs parameter in the same
	// request.
	//
	// [Pagination]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination
	MaxResults *int32

	// The token returned from a previous paginated request. Pagination continues from
	// the end of the items returned by the previous request.
	NextToken *string

	noSmithyDocumentSerde
}

type DescribeInstancesOutput struct {

	// The token to include in another request to get the next page of items. This
	// value is null when there are no more items to return.
	NextToken *string

	// Information about the reservations.
	Reservations []types.Reservation

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeInstancesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsEc2query_serializeOpDescribeInstances{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpDescribeInstances{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeInstances"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeInstances(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// InstanceExistsWaiterOptions are waiter options for InstanceExistsWaiter
type InstanceExistsWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	//
	// Passing options here is functionally equivalent to passing values to this
	// config's ClientOptions field that extend the inner client's APIOptions directly.
	APIOptions []func(*middleware.Stack) error

	// Functional options to be passed to all operations invoked by this client.
	//
	// Function values that modify the inner APIOptions are applied after the waiter
	// config's own APIOptions modifiers.
	ClientOptions []func(*Options)

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// InstanceExistsWaiter will use default minimum delay of 5 seconds. Note that
	// MinDelay must resolve to a value lesser than or equal to the MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, InstanceExistsWaiter will use default max delay of 120 seconds.
	// Note that MaxDelay must resolve to value greater than or equal to the MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state.
	//
	// By default service-modeled logic will populate this option. This option can
	// thus be used to define a custom waiter state with fall-back to service-modeled
	// waiter state mutators.The function returns an error in case of a failure state.
	// In case of retry state, this function returns a bool value of true and nil
	// error, while in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *DescribeInstancesInput, *DescribeInstancesOutput, error) (bool, error)
}

// InstanceExistsWaiter defines the waiters for InstanceExists
type InstanceExistsWaiter struct {
	client DescribeInstancesAPIClient

	options InstanceExistsWaiterOptions
}

// NewInstanceExistsWaiter constructs a InstanceExistsWaiter.
func NewInstanceExistsWaiter(client DescribeInstancesAPIClient, optFns ...func(*InstanceExistsWaiterOptions)) *InstanceExistsWaiter {
	options := InstanceExistsWaiterOptions{}
	options.MinDelay = 5 * time.Second
	options.MaxDelay = 120 * time.Second
	options.Retryable = instanceExistsStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &InstanceExistsWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for InstanceExists waiter. The maxWaitDur is the
// maximum wait duration the waiter will wait. The maxWaitDur is required and must
// be greater than zero.
func (w *InstanceExistsWaiter) Wait(ctx context.Context, params *DescribeInstancesInput, maxWaitDur time.Duration, optFns ...func(*InstanceExistsWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for InstanceExists waiter and returns
// the output of the successful operation. The maxWaitDur is the maximum wait
// duration the waiter will wait. The maxWaitDur is required and must be greater
// than zero.
func (w *InstanceExistsWaiter) WaitForOutput(ctx context.Context, params *DescribeInstancesInput, maxWaitDur time.Duration, optFns ...func(*InstanceExistsWaiterOptions)) (*DescribeInstancesOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 120 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.DescribeInstances(ctx, params, func(o *Options) {
			baseOpts := []func(*Options){
				addIsWaiterUserAgent,
			}
			o.APIOptions = append(o.APIOptions, apiOptions...)
			for _, opt := range baseOpts {
				opt(o)
			}
			for _, opt := range options.ClientOptions {
				opt(o)
			}
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for InstanceExists waiter")
}

func instanceExistsStateRetryable(ctx context.Context, input *DescribeInstancesInput, output *DescribeInstancesOutput, err error) (bool, error) {

	if err == nil {
		v1 := output.Reservations
		v2 := len(v1)
		v3 := 0
		v4 := int64(v2) > int64(v3)
		expectedValue := "true"
		bv, err := strconv.ParseBool(expectedValue)
		if err != nil {
			return false, fmt.Errorf("error parsing boolean from string %w", err)
		}
		if v4 == bv {
			return false, nil
		}
	}

	if err != nil {
		var apiErr smithy.APIError
		ok := errors.As(err, &apiErr)
		if !ok {
			return false, fmt.Errorf("expected err to be of type smithy.APIError, got %w", err)
		}

		if "InvalidInstanceID.NotFound" == apiErr.ErrorCode() {
			return true, nil
		}
	}

	return true, nil
}

// InstanceRunningWaiterOptions are waiter options for InstanceRunningWaiter
type InstanceRunningWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	//
	// Passing options here is functionally equivalent to passing values to this
	// config's ClientOptions field that extend the inner client's APIOptions directly.
	APIOptions []func(*middleware.Stack) error

	// Functional options to be passed to all operations invoked by this client.
	//
	// Function values that modify the inner APIOptions are applied after the waiter
	// config's own APIOptions modifiers.
	ClientOptions []func(*Options)

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// InstanceRunningWaiter will use default minimum delay of 15 seconds. Note that
	// MinDelay must resolve to a value lesser than or equal to the MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, InstanceRunningWaiter will use default max delay of 120 seconds.
	// Note that MaxDelay must resolve to value greater than or equal to the MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state.
	//
	// By default service-modeled logic will populate this option. This option can
	// thus be used to define a custom waiter state with fall-back to service-modeled
	// waiter state mutators.The function returns an error in case of a failure state.
	// In case of retry state, this function returns a bool value of true and nil
	// error, while in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *DescribeInstancesInput, *DescribeInstancesOutput, error) (bool, error)
}

// InstanceRunningWaiter defines the waiters for InstanceRunning
type InstanceRunningWaiter struct {
	client DescribeInstancesAPIClient

	options InstanceRunningWaiterOptions
}

// NewInstanceRunningWaiter constructs a InstanceRunningWaiter.
func NewInstanceRunningWaiter(client DescribeInstancesAPIClient, optFns ...func(*InstanceRunningWaiterOptions)) *InstanceRunningWaiter {
	options := InstanceRunningWaiterOptions{}
	options.MinDelay = 15 * time.Second
	options.MaxDelay = 120 * time.Second
	options.Retryable = instanceRunningStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &InstanceRunningWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for InstanceRunning waiter. The maxWaitDur is
// the maximum wait duration the waiter will wait. The maxWaitDur is required and
// must be greater than zero.
func (w *InstanceRunningWaiter) Wait(ctx context.Context, params *DescribeInstancesInput, maxWaitDur time.Duration, optFns ...func(*InstanceRunningWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for InstanceRunning waiter and returns
// the output of the successful operation. The maxWaitDur is the maximum wait
// duration the waiter will wait. The maxWaitDur is required and must be greater
// than zero.
func (w *InstanceRunningWaiter) WaitForOutput(ctx context.Context, params *DescribeInstancesInput, maxWaitDur time.Duration, optFns ...func(*InstanceRunningWaiterOptions)) (*DescribeInstancesOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 120 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.DescribeInstances(ctx, params, func(o *Options) {
			baseOpts := []func(*Options){
				addIsWaiterUserAgent,
			}
			o.APIOptions = append(o.APIOptions, apiOptions...)
			for _, opt := range baseOpts {
				opt(o)
			}
			for _, opt := range options.ClientOptions {
				opt(o)
			}
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for InstanceRunning waiter")
}

func instanceRunningStateRetryable(ctx context.Context, input *DescribeInstancesInput, output *DescribeInstancesOutput, err error) (bool, error) {

	if err == nil {
		v1 := output.Reservations
		var v2 [][]types.Instance
		for _, v := range v1 {
			v3 := v.Instances
			v2 = append(v2, v3)
		}
		var v4 []types.Instance
		for _, v := range v2 {
			v4 = append(v4, v...)
		}
		var v5 []types.InstanceStateName
		for _, v := range v4 {
			v6 := v.State
			v7 := v6.Name
			v5 = append(v5, v7)
		}
		expectedValue := "running"
		match := len(v5) > 0
		for _, v := range v5 {
			if string(v) != expectedValue {
				match = false
				break
			}
		}

		if match {
			return false, nil
		}
	}

	if err == nil {
		v1 := output.Reservations
		var v2 [][]types.Instance
		for _, v := range v1 {
			v3 := v.Instances
			v2 = append(v2, v3)
		}
		var v4 []types.Instance
		for _, v := range v2 {
			v4 = append(v4, v...)
		}
		var v5 []types.InstanceStateName
		for _, v := range v4 {
			v6 := v.State
			v7 := v6.Name
			v5 = append(v5, v7)
		}
		expectedValue := "shutting-down"
		var match bool
		for _, v := range v5 {
			if string(v) == expectedValue {
				match = true
				break
			}
		}

		if match {
			return false, fmt.Errorf("waiter state transitioned to Failure")
		}
	}

	if err == nil {
		v1 := output.Reservations
		var v2 [][]types.Instance
		for _, v := range v1 {
			v3 := v.Instances
			v2 = append(v2, v3)
		}
		var v4 []types.Instance
		for _, v := range v2 {
			v4 = append(v4, v...)
		}
		var v5 []types.InstanceStateName
		for _, v := range v4 {
			v6 := v.State
			v7 := v6.Name
			v5 = append(v5, v7)
		}
		expectedValue := "terminated"
		var match bool
		for _, v := range v5 {
			if string(v) == expectedValue {
				match = true
				break
			}
		}

		if match {
			return false, fmt.Errorf("waiter state transitioned to Failure")
		}
	}

	if err == nil {
		v1 := output.Reservations
		var v2 [][]types.Instance
		for _, v := range v1 {
			v3 := v.Instances
			v2 = append(v2, v3)
		}
		var v4 []types.Instance
		for _, v := range v2 {
			v4 = append(v4, v...)
		}
		var v5 []types.InstanceStateName
		for _, v := range v4 {
			v6 := v.State
			v7 := v6.Name
			v5 = append(v5, v7)
		}
		expectedValue := "stopping"
		var match bool
		for _, v := range v5 {
			if string(v) == expectedValue {
				match = true
				break
			}
		}

		if match {
			return false, fmt.Errorf("waiter state transitioned to Failure")
		}
	}

	if err != nil {
		var apiErr smithy.APIError
		ok := errors.As(err, &apiErr)
		if !ok {
			return false, fmt.Errorf("expected err to be of type smithy.APIError, got %w", err)
		}

		if "InvalidInstanceID.NotFound" == apiErr.ErrorCode() {
			return true, nil
		}
	}

	return true, nil
}

// InstanceStoppedWaiterOptions are waiter options for InstanceStoppedWaiter
type InstanceStoppedWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	//
	// Passing options here is functionally equivalent to passing values to this
	// config's ClientOptions field that extend the inner client's APIOptions directly.
	APIOptions []func(*middleware.Stack) error

	// Functional options to be passed to all operations invoked by this client.
	//
	// Function values that modify the inner APIOptions are applied after the waiter
	// config's own APIOptions modifiers.
	ClientOptions []func(*Options)

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// InstanceStoppedWaiter will use default minimum delay of 15 seconds. Note that
	// MinDelay must resolve to a value lesser than or equal to the MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, InstanceStoppedWaiter will use default max delay of 120 seconds.
	// Note that MaxDelay must resolve to value greater than or equal to the MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state.
	//
	// By default service-modeled logic will populate this option. This option can
	// thus be used to define a custom waiter state with fall-back to service-modeled
	// waiter state mutators.The function returns an error in case of a failure state.
	// In case of retry state, this function returns a bool value of true and nil
	// error, while in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *DescribeInstancesInput, *DescribeInstancesOutput, error) (bool, error)
}

// InstanceStoppedWaiter defines the waiters for InstanceStopped
type InstanceStoppedWaiter struct {
	client DescribeInstancesAPIClient

	options InstanceStoppedWaiterOptions
}

// NewInstanceStoppedWaiter constructs a InstanceStoppedWaiter.
func NewInstanceStoppedWaiter(client DescribeInstancesAPIClient, optFns ...func(*InstanceStoppedWaiterOptions)) *InstanceStoppedWaiter {
	options := InstanceStoppedWaiterOptions{}
	options.MinDelay = 15 * time.Second
	options.MaxDelay = 120 * time.Second
	options.Retryable = instanceStoppedStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &InstanceStoppedWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for InstanceStopped waiter. The maxWaitDur is
// the maximum wait duration the waiter will wait. The maxWaitDur is required and
// must be greater than zero.
func (w *InstanceStoppedWaiter) Wait(ctx context.Context, params *DescribeInstancesInput, maxWaitDur time.Duration, optFns ...func(*InstanceStoppedWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for InstanceStopped waiter and returns
// the output of the successful operation. The maxWaitDur is the maximum wait
// duration the waiter will wait. The maxWaitDur is required and must be greater
// than zero.
func (w *InstanceStoppedWaiter) WaitForOutput(ctx context.Context, params *DescribeInstancesInput, maxWaitDur time.Duration, optFns ...func(*InstanceStoppedWaiterOptions)) (*DescribeInstancesOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 120 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.DescribeInstances(ctx, params, func(o *Options) {
			baseOpts := []func(*Options){
				addIsWaiterUserAgent,
			}
			o.APIOptions = append(o.APIOptions, apiOptions...)
			for _, opt := range baseOpts {
				opt(o)
			}
			for _, opt := range options.ClientOptions {
				opt(o)
			}
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for InstanceStopped waiter")
}

func instanceStoppedStateRetryable(ctx context.Context, input *DescribeInstancesInput, output *DescribeInstancesOutput, err error) (bool, error) {

	if err == nil {
		v1 := output.Reservations
		var v2 [][]types.Instance
		for _, v := range v1 {
			v3 := v.Instances
			v2 = append(v2, v3)
		}
		var v4 []types.Instance
		for _, v := range v2 {
			v4 = append(v4, v...)
		}
		var v5 []types.InstanceStateName
		for _, v := range v4 {
			v6 := v.State
			v7 := v6.Name
			v5 = append(v5, v7)
		}
		expectedValue := "stopped"
		match := len(v5) > 0
		for _, v := range v5 {
			if string(v) != expectedValue {
				match = false
				break
			}
		}

		if match {
			return false, nil
		}
	}

	if err == nil {
		v1 := output.Reservations
		var v2 [][]types.Instance
		for _, v := range v1 {
			v3 := v.Instances
			v2 = append(v2, v3)
		}
		var v4 []types.Instance
		for _, v := range v2 {
			v4 = append(v4, v...)
		}
		var v5 []types.InstanceStateName
		for _, v := range v4 {
			v6 := v.State
			v7 := v6.Name
			v5 = append(v5, v7)
		}
		expectedValue := "pending"
		var match bool
		for _, v := range v5 {
			if string(v) == expectedValue {
				match = true
				break
			}
		}

		if match {
			return false, fmt.Errorf("waiter state transitioned to Failure")
		}
	}

	if err == nil {
		v1 := output.Reservations
		var v2 [][]types.Instance
		for _, v := range v1 {
			v3 := v.Instances
			v2 = append(v2, v3)
		}
		var v4 []types.Instance
		for _, v := range v2 {
			v4 = append(v4, v...)
		}
		var v5 []types.InstanceStateName
		for _, v := range v4 {
			v6 := v.State
			v7 := v6.Name
			v5 = append(v5, v7)
		}
		expectedValue := "terminated"
		var match bool
		for _, v := range v5 {
			if string(v) == expectedValue {
				match = true
				break
			}
		}

		if match {
			return false, fmt.Errorf("waiter state transitioned to Failure")
		}
	}

	return true, nil
}

// InstanceTerminatedWaiterOptions are waiter options for InstanceTerminatedWaiter
type InstanceTerminatedWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	//
	// Passing options here is functionally equivalent to passing values to this
	// config's ClientOptions field that extend the inner client's APIOptions directly.
	APIOptions []func(*middleware.Stack) error

	// Functional options to be passed to all operations invoked by this client.
	//
	// Function values that modify the inner APIOptions are applied after the waiter
	// config's own APIOptions modifiers.
	ClientOptions []func(*Options)

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// InstanceTerminatedWaiter will use default minimum delay of 15 seconds. Note that
	// MinDelay must resolve to a value lesser than or equal to the MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, InstanceTerminatedWaiter will use default max delay of 120 seconds.
	// Note that MaxDelay must resolve to value greater than or equal to the MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state.
	//
	// By default service-modeled logic will populate this option. This option can
	// thus be used to define a custom waiter state with fall-back to service-modeled
	// waiter state mutators.The function returns an error in case of a failure state.
	// In case of retry state, this function returns a bool value of true and nil
	// error, while in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *DescribeInstancesInput, *DescribeInstancesOutput, error) (bool, error)
}

// InstanceTerminatedWaiter defines the waiters for InstanceTerminated
type InstanceTerminatedWaiter struct {
	client DescribeInstancesAPIClient

	options InstanceTerminatedWaiterOptions
}

// NewInstanceTerminatedWaiter constructs a InstanceTerminatedWaiter.
func NewInstanceTerminatedWaiter(client DescribeInstancesAPIClient, optFns ...func(*InstanceTerminatedWaiterOptions)) *InstanceTerminatedWaiter {
	options := InstanceTerminatedWaiterOptions{}
	options.MinDelay = 15 * time.Second
	options.MaxDelay = 120 * time.Second
	options.Retryable = instanceTerminatedStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &InstanceTerminatedWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for InstanceTerminated waiter. The maxWaitDur is
// the maximum wait duration the waiter will wait. The maxWaitDur is required and
// must be greater than zero.
func (w *InstanceTerminatedWaiter) Wait(ctx context.Context, params *DescribeInstancesInput, maxWaitDur time.Duration, optFns ...func(*InstanceTerminatedWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for InstanceTerminated waiter and
// returns the output of the successful operation. The maxWaitDur is the maximum
// wait duration the waiter will wait. The maxWaitDur is required and must be
// greater than zero.
func (w *InstanceTerminatedWaiter) WaitForOutput(ctx context.Context, params *DescribeInstancesInput, maxWaitDur time.Duration, optFns ...func(*InstanceTerminatedWaiterOptions)) (*DescribeInstancesOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 120 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.DescribeInstances(ctx, params, func(o *Options) {
			baseOpts := []func(*Options){
				addIsWaiterUserAgent,
			}
			o.APIOptions = append(o.APIOptions, apiOptions...)
			for _, opt := range baseOpts {
				opt(o)
			}
			for _, opt := range options.ClientOptions {
				opt(o)
			}
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for InstanceTerminated waiter")
}

func instanceTerminatedStateRetryable(ctx context.Context, input *DescribeInstancesInput, output *DescribeInstancesOutput, err error) (bool, error) {

	if err == nil {
		v1 := output.Reservations
		var v2 [][]types.Instance
		for _, v := range v1 {
			v3 := v.Instances
			v2 = append(v2, v3)
		}
		var v4 []types.Instance
		for _, v := range v2 {
			v4 = append(v4, v...)
		}
		var v5 []types.InstanceStateName
		for _, v := range v4 {
			v6 := v.State
			v7 := v6.Name
			v5 = append(v5, v7)
		}
		expectedValue := "terminated"
		match := len(v5) > 0
		for _, v := range v5 {
			if string(v) != expectedValue {
				match = false
				break
			}
		}

		if match {
			return false, nil
		}
	}

	if err == nil {
		v1 := output.Reservations
		var v2 [][]types.Instance
		for _, v := range v1 {
			v3 := v.Instances
			v2 = append(v2, v3)
		}
		var v4 []types.Instance
		for _, v := range v2 {
			v4 = append(v4, v...)
		}
		var v5 []types.InstanceStateName
		for _, v := range v4 {
			v6 := v.State
			v7 := v6.Name
			v5 = append(v5, v7)
		}
		expectedValue := "pending"
		var match bool
		for _, v := range v5 {
			if string(v) == expectedValue {
				match = true
				break
			}
		}

		if match {
			return false, fmt.Errorf("waiter state transitioned to Failure")
		}
	}

	if err == nil {
		v1 := output.Reservations
		var v2 [][]types.Instance
		for _, v := range v1 {
			v3 := v.Instances
			v2 = append(v2, v3)
		}
		var v4 []types.Instance
		for _, v := range v2 {
			v4 = append(v4, v...)
		}
		var v5 []types.InstanceStateName
		for _, v := range v4 {
			v6 := v.State
			v7 := v6.Name
			v5 = append(v5, v7)
		}
		expectedValue := "stopping"
		var match bool
		for _, v := range v5 {
			if string(v) == expectedValue {
				match = true
				break
			}
		}

		if match {
			return false, fmt.Errorf("waiter state transitioned to Failure")
		}
	}

	return true, nil
}

// DescribeInstancesPaginatorOptions is the paginator options for DescribeInstances
type DescribeInstancesPaginatorOptions struct {
	// The maximum number of items to return for this request. To get the next page of
	// items, make another request with the token returned in the output. For more
	// information, see [Pagination].
	//
	// You cannot specify this parameter and the instance IDs parameter in the same
	// request.
	//
	// [Pagination]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeInstancesPaginator is a paginator for DescribeInstances
type DescribeInstancesPaginator struct {
	options   DescribeInstancesPaginatorOptions
	client    DescribeInstancesAPIClient
	params    *DescribeInstancesInput
	nextToken *string
	firstPage bool
}

// NewDescribeInstancesPaginator returns a new DescribeInstancesPaginator
func NewDescribeInstancesPaginator(client DescribeInstancesAPIClient, params *DescribeInstancesInput, optFns ...func(*DescribeInstancesPaginatorOptions)) *DescribeInstancesPaginator {
	if params == nil {
		params = &DescribeInstancesInput{}
	}

	options := DescribeInstancesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeInstancesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeInstancesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeInstances page.
func (p *DescribeInstancesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeInstancesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.DescribeInstances(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// DescribeInstancesAPIClient is a client that implements the DescribeInstances
// operation.
type DescribeInstancesAPIClient interface {
	DescribeInstances(context.Context, *DescribeInstancesInput, ...func(*Options)) (*DescribeInstancesOutput, error)
}

var _ DescribeInstancesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opDescribeInstances(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeInstances",
	}
}
