// Code generated by protoc-gen-go-grpc. DO NOT EDIT.

package upstreamauthorityv1

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

// UpstreamAuthorityClient is the client API for UpstreamAuthority service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type UpstreamAuthorityClient interface {
	// Mints an X.509 CA and responds with the signed X.509 CA certificate
	// chain and upstream X.509 roots. If supported by the implementation,
	// subsequent responses on the stream contain upstream X.509 root updates,
	// otherwise the stream is closed after the initial response.
	//
	// Implementation note:
	// The stream should be kept open in the face of transient errors
	// encountered while tracking changes to the upstream X.509 roots as SPIRE
	// Server will not reopen a closed stream until the next X.509 CA rotation.
	MintX509CAAndSubscribe(ctx context.Context, in *MintX509CARequest, opts ...grpc.CallOption) (UpstreamAuthority_MintX509CAAndSubscribeClient, error)
	// Publishes a JWT signing key upstream and responds with the upstream JWT
	// keys. If supported by the implementation, subsequent responses on the
	// stream contain upstream JWT key updates, otherwise the stream is closed
	// after the initial response.
	//
	// This RPC is optional and will return NotImplemented if unsupported.
	//
	// Implementation note:
	// The stream should be kept open in the face of transient errors
	// encountered while tracking changes to the upstream JWT keys as SPIRE
	// Server will not reopen a closed stream until the next JWT key rotation.
	PublishJWTKeyAndSubscribe(ctx context.Context, in *PublishJWTKeyRequest, opts ...grpc.CallOption) (UpstreamAuthority_PublishJWTKeyAndSubscribeClient, error)
}

type upstreamAuthorityClient struct {
	cc grpc.ClientConnInterface
}

func NewUpstreamAuthorityClient(cc grpc.ClientConnInterface) UpstreamAuthorityClient {
	return &upstreamAuthorityClient{cc}
}

func (c *upstreamAuthorityClient) MintX509CAAndSubscribe(ctx context.Context, in *MintX509CARequest, opts ...grpc.CallOption) (UpstreamAuthority_MintX509CAAndSubscribeClient, error) {
	stream, err := c.cc.NewStream(ctx, &UpstreamAuthority_ServiceDesc.Streams[0], "/spire.plugin.server.upstreamauthority.v1.UpstreamAuthority/MintX509CAAndSubscribe", opts...)
	if err != nil {
		return nil, err
	}
	x := &upstreamAuthorityMintX509CAAndSubscribeClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type UpstreamAuthority_MintX509CAAndSubscribeClient interface {
	Recv() (*MintX509CAResponse, error)
	grpc.ClientStream
}

type upstreamAuthorityMintX509CAAndSubscribeClient struct {
	grpc.ClientStream
}

func (x *upstreamAuthorityMintX509CAAndSubscribeClient) Recv() (*MintX509CAResponse, error) {
	m := new(MintX509CAResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *upstreamAuthorityClient) PublishJWTKeyAndSubscribe(ctx context.Context, in *PublishJWTKeyRequest, opts ...grpc.CallOption) (UpstreamAuthority_PublishJWTKeyAndSubscribeClient, error) {
	stream, err := c.cc.NewStream(ctx, &UpstreamAuthority_ServiceDesc.Streams[1], "/spire.plugin.server.upstreamauthority.v1.UpstreamAuthority/PublishJWTKeyAndSubscribe", opts...)
	if err != nil {
		return nil, err
	}
	x := &upstreamAuthorityPublishJWTKeyAndSubscribeClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type UpstreamAuthority_PublishJWTKeyAndSubscribeClient interface {
	Recv() (*PublishJWTKeyResponse, error)
	grpc.ClientStream
}

type upstreamAuthorityPublishJWTKeyAndSubscribeClient struct {
	grpc.ClientStream
}

func (x *upstreamAuthorityPublishJWTKeyAndSubscribeClient) Recv() (*PublishJWTKeyResponse, error) {
	m := new(PublishJWTKeyResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// UpstreamAuthorityServer is the server API for UpstreamAuthority service.
// All implementations must embed UnimplementedUpstreamAuthorityServer
// for forward compatibility
type UpstreamAuthorityServer interface {
	// Mints an X.509 CA and responds with the signed X.509 CA certificate
	// chain and upstream X.509 roots. If supported by the implementation,
	// subsequent responses on the stream contain upstream X.509 root updates,
	// otherwise the stream is closed after the initial response.
	//
	// Implementation note:
	// The stream should be kept open in the face of transient errors
	// encountered while tracking changes to the upstream X.509 roots as SPIRE
	// Server will not reopen a closed stream until the next X.509 CA rotation.
	MintX509CAAndSubscribe(*MintX509CARequest, UpstreamAuthority_MintX509CAAndSubscribeServer) error
	// Publishes a JWT signing key upstream and responds with the upstream JWT
	// keys. If supported by the implementation, subsequent responses on the
	// stream contain upstream JWT key updates, otherwise the stream is closed
	// after the initial response.
	//
	// This RPC is optional and will return NotImplemented if unsupported.
	//
	// Implementation note:
	// The stream should be kept open in the face of transient errors
	// encountered while tracking changes to the upstream JWT keys as SPIRE
	// Server will not reopen a closed stream until the next JWT key rotation.
	PublishJWTKeyAndSubscribe(*PublishJWTKeyRequest, UpstreamAuthority_PublishJWTKeyAndSubscribeServer) error
	mustEmbedUnimplementedUpstreamAuthorityServer()
}

// UnimplementedUpstreamAuthorityServer must be embedded to have forward compatible implementations.
type UnimplementedUpstreamAuthorityServer struct {
}

func (UnimplementedUpstreamAuthorityServer) MintX509CAAndSubscribe(*MintX509CARequest, UpstreamAuthority_MintX509CAAndSubscribeServer) error {
	return status.Errorf(codes.Unimplemented, "method MintX509CAAndSubscribe not implemented")
}
func (UnimplementedUpstreamAuthorityServer) PublishJWTKeyAndSubscribe(*PublishJWTKeyRequest, UpstreamAuthority_PublishJWTKeyAndSubscribeServer) error {
	return status.Errorf(codes.Unimplemented, "method PublishJWTKeyAndSubscribe not implemented")
}
func (UnimplementedUpstreamAuthorityServer) mustEmbedUnimplementedUpstreamAuthorityServer() {}

// UnsafeUpstreamAuthorityServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to UpstreamAuthorityServer will
// result in compilation errors.
type UnsafeUpstreamAuthorityServer interface {
	mustEmbedUnimplementedUpstreamAuthorityServer()
}

func RegisterUpstreamAuthorityServer(s grpc.ServiceRegistrar, srv UpstreamAuthorityServer) {
	s.RegisterService(&UpstreamAuthority_ServiceDesc, srv)
}

func _UpstreamAuthority_MintX509CAAndSubscribe_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(MintX509CARequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(UpstreamAuthorityServer).MintX509CAAndSubscribe(m, &upstreamAuthorityMintX509CAAndSubscribeServer{stream})
}

type UpstreamAuthority_MintX509CAAndSubscribeServer interface {
	Send(*MintX509CAResponse) error
	grpc.ServerStream
}

type upstreamAuthorityMintX509CAAndSubscribeServer struct {
	grpc.ServerStream
}

func (x *upstreamAuthorityMintX509CAAndSubscribeServer) Send(m *MintX509CAResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _UpstreamAuthority_PublishJWTKeyAndSubscribe_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(PublishJWTKeyRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(UpstreamAuthorityServer).PublishJWTKeyAndSubscribe(m, &upstreamAuthorityPublishJWTKeyAndSubscribeServer{stream})
}

type UpstreamAuthority_PublishJWTKeyAndSubscribeServer interface {
	Send(*PublishJWTKeyResponse) error
	grpc.ServerStream
}

type upstreamAuthorityPublishJWTKeyAndSubscribeServer struct {
	grpc.ServerStream
}

func (x *upstreamAuthorityPublishJWTKeyAndSubscribeServer) Send(m *PublishJWTKeyResponse) error {
	return x.ServerStream.SendMsg(m)
}

// UpstreamAuthority_ServiceDesc is the grpc.ServiceDesc for UpstreamAuthority service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var UpstreamAuthority_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "spire.plugin.server.upstreamauthority.v1.UpstreamAuthority",
	HandlerType: (*UpstreamAuthorityServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "MintX509CAAndSubscribe",
			Handler:       _UpstreamAuthority_MintX509CAAndSubscribe_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "PublishJWTKeyAndSubscribe",
			Handler:       _UpstreamAuthority_PublishJWTKeyAndSubscribe_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "spire/plugin/server/upstreamauthority/v1/upstreamauthority.proto",
}
