# Table of Content
- <a href="#description">Description</a>
- <a href="#building-and-install">Building and Install</a>
- <a href="#troubleshooting">Troubleshooting</a>
- <a href="#regarding-upstreaming-of-tuxedo-drivers">Regarding upstreaming of tuxedo-drivers</a>

# Description
Drivers for several platform devices for TUXEDO notebooks meant for the DKMS.

## Features
- Driver for Fn-keys
- SysFS control of brightness/color/mode for most TUXEDO keyboards
    - [https://docs.kernel.org/leds/leds-class.html](https://docs.kernel.org/leds/leds-class.html)
    - [https://docs.kernel.org/leds/leds-class-multicolor.html](https://docs.kernel.org/leds/leds-class-multicolor.html)
- Hardware I/O driver for TUXEDO Control Center

## Modules included in this package
- tuxedo_compatibility_check
- tuxedo_keyboard
- clevo_acpi
- clevo_wmi
- uniwill_wmi
- tuxedo_io
- ite_8291
- ite_8291_lb
- ite_8297
- ite_829x
- stk8321
- tuxedo_nb05_ec
- tuxedo_nb05_power_profiles
- tuxedo_nb05_sensors
- tuxedo_nb05_keyboard
- tuxedo_nb04_keyboard
- tuxedo_nb04_wmi_ab
- tuxedo_nb04_wmi_bs
- tuxedo_nb04_sensors
- tuxedo_nb04_power_profiles
- tuxedo_nb04_kbd_backlight

# Building and Install

## Warning when installing the module:

The `make install` and `make dkmsinstall` targets are only intended for development purposes. Only use them if you know how to recover from a botched root file system or DKMS state!

For production systems use the version from the package repository where available or the deb or rpm package generated by `make package-deb` and `make package-rpm` respectively.

## Dependencies:
All:
- make

`make install`:
- gcc or clang
- linux-headers

`make dkmsinstall`:
- dkms
- linux-headers

`make package-deb`:
- devscripts
- debhelper

`make package-rpm`:
- rpm

# Troubleshooting

## The keyboard backlight control and/or touchpad toggle key combinations do not work
For all devices with a touchpad toggle key(-combo) and some devices with keyboard backlight control key-combos the driver does nothing more then to send the corresponding key event to userspace where it is the desktop environments duty to carry out the action. Some smaller desktop environments however don't bind an action to these keys by default so it seems that these keys don't work.

Please refer to your desktop environments documentation on how to set custom keybindings to fix this.

For keyboard brightness control you should use the D-Bus interface of UPower as actions for the key presses.

For touchpad toggle on X11 you can use `xinput` to enable/disable the touchpad, on Wayland the correct way is desktop environment specific.

# Regarding upstreaming of tuxedo-drivers
The code, while perfectly functional, is currently not in an upstreamable state. That being said we started an upstreaming effort for the first small part with the keyboard backlight control for the Sirius 16 Gen 1 & 2, which will be followed by more once it is accepted.

If you want to hack away at this matter yourself please follow the following precautions and guidelines to avoid breakages on both software and hardware level:
- Involve us in the whole process. Nothing is won if at some point tuxedo-control-center or the dkms variant of tuxedo-drivers stops working. Especially when you send something to the LKML, set us in the cc.
- We mostly can't share documentation, but we can answer questions.
- Code interacting with the EC, which is most of tuxedo-drivers, can brick devices and therefore must be ensured to only run on compatible and tested devices.
- If you use tuxedo-drivers as a reference or code snippets from it, a "Codeveloped-by:\<name\>@tuxedocomputers.de" must be included in your upstream commit, with \<name\> depending on the actual part of tuxedo-drivers being used. Talk to us regarding this.
