/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.input.parse;

import com.thaiopensource.relaxng.edit.AnnotationChild;
import com.thaiopensource.relaxng.edit.AttributeAnnotation;
import com.thaiopensource.relaxng.edit.ElementAnnotation;
import com.thaiopensource.relaxng.edit.SourceLocation;
import com.thaiopensource.relaxng.edit.TextAnnotation;
import com.thaiopensource.relaxng.input.parse.CommentListImpl;
import com.thaiopensource.relaxng.parse.BuildException;
import com.thaiopensource.relaxng.parse.ElementAnnotationBuilder;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementAnnotationBuilderImpl
implements ElementAnnotationBuilder<SourceLocation, ElementAnnotationBuilderImpl, CommentListImpl> {
    private final ElementAnnotation element;
    private CommentListImpl comments;

    ElementAnnotationBuilderImpl(CommentListImpl commentListImpl, ElementAnnotation elementAnnotation) {
        this.comments = commentListImpl;
        this.element = elementAnnotation;
    }

    @Override
    public void addText(String string, SourceLocation sourceLocation, CommentListImpl commentListImpl) throws BuildException {
        TextAnnotation textAnnotation = new TextAnnotation(string);
        textAnnotation.setSourceLocation(sourceLocation);
        if (commentListImpl != null) {
            this.element.getChildren().addAll(commentListImpl.list);
        }
        this.element.getChildren().add(textAnnotation);
    }

    @Override
    public void addAttribute(String string, String string2, String string3, String string4, SourceLocation sourceLocation) throws BuildException {
        AttributeAnnotation attributeAnnotation = new AttributeAnnotation(string, string2, string4);
        attributeAnnotation.setPrefix(string3);
        attributeAnnotation.setSourceLocation(sourceLocation);
        this.element.getAttributes().add(attributeAnnotation);
    }

    @Override
    public ElementAnnotationBuilderImpl makeElementAnnotation() throws BuildException {
        return this;
    }

    @Override
    public void addElement(ElementAnnotationBuilderImpl elementAnnotationBuilderImpl) throws BuildException {
        elementAnnotationBuilderImpl.addTo(this.element.getChildren());
    }

    @Override
    public void addComment(CommentListImpl commentListImpl) throws BuildException {
        if (commentListImpl != null) {
            this.element.getChildren().addAll(commentListImpl.list);
        }
    }

    @Override
    public void addLeadingComment(CommentListImpl commentListImpl) throws BuildException {
        if (this.comments == null) {
            this.comments = commentListImpl;
        } else if (commentListImpl != null) {
            this.comments.add(commentListImpl);
        }
    }

    void addTo(List<AnnotationChild> list) {
        if (this.comments != null) {
            list.addAll(this.comments.list);
        }
        list.add(this.element);
    }
}

