/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.discovery.commands;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.equinox.internal.p2.discovery.Catalog;
import org.eclipse.equinox.internal.p2.discovery.DiscoveryCore;
import org.eclipse.equinox.internal.p2.discovery.compatibility.BundleDiscoveryStrategy;
import org.eclipse.equinox.internal.p2.discovery.compatibility.RemoteBundleDiscoveryStrategy;
import org.eclipse.equinox.internal.p2.discovery.model.Tag;
import org.eclipse.equinox.internal.p2.ui.discovery.util.WorkbenchUtil;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.CatalogConfiguration;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.DiscoveryWizard;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;

public class ShowBundleCatalogCommandHandler
extends AbstractHandler {
    private static final String ID_PARAMETER_DIRECTORY = "org.eclipse.equinox.p2.ui.discovery.commands.DirectoryParameter";
    private static final String ID_PARAMETER_TAGS = "org.eclipse.equinox.p2.ui.discovery.commands.TagsParameter";

    public Object execute(ExecutionEvent event) {
        LinkedHashSet<Tag> tags = new LinkedHashSet<Tag>();
        String tagString = event.getParameter(ID_PARAMETER_TAGS);
        if (tagString != null) {
            String[] tagIds;
            String[] stringArray = tagIds = tagString.split("\\s*,\\s*");
            int n = tagIds.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                String[] text = id.split("=", 2);
                Tag tag = text.length > 1 ? new Tag(text[0], text[1]) : new Tag(id, id);
                tags.add(tag);
                ++n2;
            }
        }
        Catalog catalog = new Catalog();
        catalog.getDiscoveryStrategies().add(new BundleDiscoveryStrategy());
        String directoryUrl = event.getParameter(ID_PARAMETER_DIRECTORY);
        if (directoryUrl != null && directoryUrl.length() > 0) {
            RemoteBundleDiscoveryStrategy remoteDiscoveryStrategy = new RemoteBundleDiscoveryStrategy();
            remoteDiscoveryStrategy.setDirectoryUrl(directoryUrl);
            catalog.getDiscoveryStrategies().add(remoteDiscoveryStrategy);
        }
        catalog.setEnvironment(DiscoveryCore.createEnvironment());
        catalog.setVerifyUpdateSiteAvailability(true);
        catalog.setTags(new ArrayList(tags));
        CatalogConfiguration configuration = new CatalogConfiguration();
        configuration.setShowTagFilter(tags.size() > 0);
        configuration.setSelectedTags(tags);
        DiscoveryWizard wizard = new DiscoveryWizard(catalog, configuration);
        WizardDialog dialog = new WizardDialog(WorkbenchUtil.getShell(), (IWizard)wizard);
        dialog.open();
        return null;
    }
}

