/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.codemining;

import java.util.concurrent.Callable;
import java.util.function.Consumer;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.codemining.AbstractCodeMining;
import org.eclipse.jface.text.codemining.ICodeMiningProvider;
import org.eclipse.jface.text.source.inlined.Positions;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

public abstract class LineHeaderCodeMining
extends AbstractCodeMining {
    public LineHeaderCodeMining(int beforeLineNumber, IDocument document, ICodeMiningProvider provider) throws BadLocationException {
        this(beforeLineNumber, document, provider, null);
    }

    public LineHeaderCodeMining(int beforeLineNumber, IDocument document, ICodeMiningProvider provider, Consumer<MouseEvent> action) throws BadLocationException {
        this(Positions.of(beforeLineNumber, document, true), provider, action);
    }

    public LineHeaderCodeMining(Position position, ICodeMiningProvider provider, Consumer<MouseEvent> action) throws BadLocationException {
        super(position, provider, action);
    }

    @Override
    public Point draw(final GC gc, final StyledText textWidget, final Color color, final int x, final int y) {
        return LineHeaderCodeMining.draw(this.getLabel(), gc, textWidget, x, y, new Callable<Point>(){

            @Override
            public Point call() throws Exception {
                return LineHeaderCodeMining.super.draw(gc, textWidget, color, x, y);
            }
        });
    }

    static Point draw(String label, GC gc, StyledText textWidget, int x, int y, Callable<Point> superDrawCallable) {
        String title = label != null ? label : "no command";
        String[] lines = title.split("\\r?\\n|\\r");
        if (lines.length > 1) {
            Point result = new Point(0, 0);
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                gc.drawString(line, x, y, true);
                Point ext = gc.stringExtent(line);
                result.x = Math.max(result.x, ext.x);
                result.y += ext.y;
                y += ext.y + textWidget.getLineSpacing();
                ++n2;
            }
            return result;
        }
        try {
            return superDrawCallable.call();
        }
        catch (Exception e) {
            return null;
        }
    }
}

