# Common Schema Fields

Fields common to files, directories, symlinks, FIFOs and sockets.

    {"camliVersion": 1,
     "camliType": "...",  // one of "file", "directory", "symlink", "fifo", "socket"

      // At most one of these may be set. (zero may be present only for large files' subranges,
      // represented as a tree of file schemas)  But exactly one of these is required for
      // top-level files, directories, symlinks, FIFOs, sockets, e.t.c.
      "fileName": "if-it-is-utf8.txt",    // only for utf-8
      "fileNameBytes": [65, 234, 234, 192, 23, 123],   // if unknown charset (not recommended)

      // Optional:
      "unixPermission": "0755",  // no octal in JSON, so octal as string
      "unixOwnerId": 1000,
      "unixOwner": "bradfitz",
      "unixGroupId": 500,
      "unixGroup": "camliteam",
      "unixXattrs": [....],  // TBD
      "unixMtime": "2010-07-10T17:14:51.5678Z",  // UTC-- ISO 8601, as many significant digits as known
      "unixCtime": "2010-07-10T17:20:03.9212Z",  // UTC-- ISO 8601, best-effort to match unix meaning

      // Not recommended to include, but if you must: (atime is a bit silly)
      "unixAtime": "2010-07-10T17:14:22.1234Z",  // UTC-- ISO 8601
    }
