/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench;

import java.util.Map;
import org.eclipse.core.runtime.ILog;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.core.services.contributions.IContributionFactorySpi;
import org.eclipse.e4.ui.internal.workbench.Activator;
import org.eclipse.emf.common.util.URI;
import org.osgi.framework.Bundle;

public class ReflectionContributionFactory
implements IContributionFactory {
    private Map<String, Object> languages;

    public Object create(String uriString, IEclipseContext context, IEclipseContext staticContext) {
        return this.doCreate(uriString, context, staticContext);
    }

    public Object create(String uriString, IEclipseContext context) {
        return this.doCreate(uriString, context, null);
    }

    private Object doCreate(String uriString, IEclipseContext context, IEclipseContext staticContext) {
        Object contribution;
        URI uri;
        Bundle bundle;
        if (uriString == null) {
            return null;
        }
        if (uriString.startsWith("platform:/plugin/")) {
            ILog.get().error("platform-style URIs deprecated for referencing types: " + uriString);
            uriString = uriString.replace("platform:/plugin/", "bundleclass://");
            ILog.get().error("URI rewritten as: " + uriString);
        }
        if ((bundle = this.getBundle(uri = URI.createURI((String)uriString))) != null) {
            contribution = this.createFromBundle(bundle, context, staticContext, uri);
        } else {
            contribution = null;
            ILog.get().error("Unable to retrieve the bundle from the URI: " + uriString);
        }
        return contribution;
    }

    protected Object createFromBundle(Bundle bundle, IEclipseContext context, IEclipseContext staticContext, URI uri) {
        Object contribution;
        if (uri.segmentCount() > 1) {
            String prefix = uri.segment(0);
            IContributionFactorySpi factory = (IContributionFactorySpi)this.languages.get(prefix);
            if (factory == null) {
                String message = "Unsupported contribution factory type '" + prefix + "'";
                ILog.get().error(message);
                return null;
            }
            StringBuilder resource = new StringBuilder(uri.segment(1));
            int i = 2;
            while (i < uri.segmentCount()) {
                resource.append('/');
                resource.append(uri.segment(i));
                ++i;
            }
            contribution = factory.create(bundle, resource.toString(), context);
        } else {
            String clazz = uri.segment(0);
            try {
                Class targetClass = bundle.loadClass(clazz);
                contribution = staticContext == null ? ContextInjectionFactory.make((Class)targetClass, (IEclipseContext)context) : ContextInjectionFactory.make((Class)targetClass, (IEclipseContext)context, (IEclipseContext)staticContext);
                if (contribution == null) {
                    String message = "Unable to load class '" + clazz + "' from bundle '" + bundle.getBundleId() + "'";
                    ILog.get().error(message, (Throwable)new Exception());
                }
            }
            catch (ClassNotFoundException e) {
                contribution = null;
                String message = "Unable to load class '" + clazz + "' from bundle '" + bundle.getBundleId() + "'";
                ILog.get().error(message, (Throwable)e);
            }
            catch (InjectionException e) {
                contribution = null;
                String message = "Unable to create class '" + clazz + "' from bundle '" + bundle.getBundleId() + "'";
                ILog.get().error(message, (Throwable)e);
            }
        }
        return contribution;
    }

    protected Bundle getBundle(URI platformURI) {
        if (platformURI.authority() == null) {
            ILog.get().error("Failed to get bundle for: " + String.valueOf(platformURI));
            return null;
        }
        return Activator.getDefault().getBundleForName(platformURI.authority());
    }

    public Bundle getBundle(String uriString) {
        URI uri = URI.createURI((String)uriString);
        return this.getBundle(uri);
    }
}

