/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.config.discovery.internal;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.common.registry.RegistryChangeListener;
import org.openhab.core.config.core.ConfigurableService;
import org.openhab.core.config.core.Configuration;
import org.openhab.core.config.discovery.DiscoveryResult;
import org.openhab.core.config.discovery.DiscoveryResultFlag;
import org.openhab.core.config.discovery.inbox.Inbox;
import org.openhab.core.config.discovery.inbox.InboxAutoApprovePredicate;
import org.openhab.core.config.discovery.inbox.InboxListener;
import org.openhab.core.config.discovery.inbox.InboxPredicates;
import org.openhab.core.events.AbstractTypedEventSubscriber;
import org.openhab.core.events.EventSubscriber;
import org.openhab.core.thing.Thing;
import org.openhab.core.thing.ThingRegistry;
import org.openhab.core.thing.ThingStatus;
import org.openhab.core.thing.ThingTypeUID;
import org.openhab.core.thing.events.ThingStatusInfoChangedEvent;
import org.openhab.core.thing.type.ThingType;
import org.openhab.core.thing.type.ThingTypeRegistry;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, configurationPid={"org.openhab.inbox"}, service={EventSubscriber.class}, property={"service.pid=org.openhab.inbox"})
@ConfigurableService(category="system", label="Inbox", description_uri="system:inbox")
@NonNullByDefault
public class AutomaticInboxProcessor
extends AbstractTypedEventSubscriber<ThingStatusInfoChangedEvent>
implements InboxListener,
RegistryChangeListener<Thing> {
    public static final String AUTO_IGNORE_CONFIG_PROPERTY = "autoIgnore";
    public static final String ALWAYS_AUTO_APPROVE_CONFIG_PROPERTY = "autoApprove";
    protected static final String CONFIG_URI = "system:inbox";
    private final Logger logger = LoggerFactory.getLogger(AutomaticInboxProcessor.class);
    private final ThingRegistry thingRegistry;
    private final ThingTypeRegistry thingTypeRegistry;
    private final Inbox inbox;
    private boolean autoIgnore = true;
    private boolean alwaysAutoApprove = false;
    private final Set<InboxAutoApprovePredicate> inboxAutoApprovePredicates = new CopyOnWriteArraySet<InboxAutoApprovePredicate>();

    @Activate
    public AutomaticInboxProcessor(@Reference ThingTypeRegistry thingTypeRegistry, @Reference ThingRegistry thingRegistry, @Reference Inbox inbox) {
        super(ThingStatusInfoChangedEvent.TYPE);
        this.thingTypeRegistry = thingTypeRegistry;
        this.thingRegistry = thingRegistry;
        this.inbox = inbox;
    }

    @Activate
    protected void activate(@Nullable Map<String, Object> properties) {
        this.thingRegistry.addRegistryChangeListener((RegistryChangeListener)this);
        this.inbox.addInboxListener(this);
        this.modified(properties);
    }

    @Modified
    protected void modified(@Nullable Map<String, Object> properties) {
        if (properties != null) {
            Object value = properties.get(AUTO_IGNORE_CONFIG_PROPERTY);
            this.autoIgnore = value == null || !"false".equals(value.toString());
            value = properties.get(ALWAYS_AUTO_APPROVE_CONFIG_PROPERTY);
            this.alwaysAutoApprove = value != null && "true".equals(value.toString());
            this.autoApproveInboxEntries();
        }
    }

    @Deactivate
    protected void deactivate() {
        this.inbox.removeInboxListener(this);
        this.thingRegistry.removeRegistryChangeListener((RegistryChangeListener)this);
    }

    public void receiveTypedEvent(ThingStatusInfoChangedEvent event) {
        if (this.autoIgnore) {
            Thing thing = this.thingRegistry.get(event.getThingUID());
            ThingStatus thingStatus = event.getStatusInfo().getStatus();
            this.autoIgnore(thing, thingStatus);
        }
    }

    @Override
    public void thingAdded(Inbox inbox, DiscoveryResult result) {
        Optional<Thing> thing;
        String value;
        if (this.autoIgnore && (value = this.getRepresentationValue(result)) != null && (thing = this.thingRegistry.stream().filter(t -> Objects.equals(value, this.getRepresentationPropertyValueForThing((Thing)t))).filter(t -> Objects.equals(t.getThingTypeUID(), result.getThingTypeUID())).findFirst()).isPresent()) {
            this.logger.debug("Auto-ignoring the inbox entry for the representation value '{}'.", (Object)value);
            inbox.setFlag(result.getThingUID(), DiscoveryResultFlag.IGNORED);
        }
        if (this.alwaysAutoApprove || this.isToBeAutoApproved(result)) {
            inbox.approve(result.getThingUID(), result.getLabel(), null);
        }
    }

    @Override
    public void thingUpdated(Inbox inbox, DiscoveryResult result) {
    }

    @Override
    public void thingRemoved(Inbox inbox, DiscoveryResult result) {
    }

    public void added(Thing element) {
    }

    public void removed(Thing element) {
        this.removePossiblyIgnoredResultInInbox(element);
    }

    public void updated(Thing oldElement, Thing element) {
    }

    private @Nullable String getRepresentationValue(DiscoveryResult result) {
        return result.getRepresentationProperty() != null ? Objects.toString(result.getProperties().get(result.getRepresentationProperty()), null) : null;
    }

    private void autoIgnore(@Nullable Thing thing, ThingStatus thingStatus) {
        if (ThingStatus.ONLINE.equals((Object)thingStatus)) {
            this.checkAndIgnoreInInbox(thing);
        }
    }

    private void checkAndIgnoreInInbox(@Nullable Thing thing) {
        String representationValue;
        if (thing != null && (representationValue = this.getRepresentationPropertyValueForThing(thing)) != null) {
            this.ignoreInInbox(thing.getThingTypeUID(), representationValue);
        }
    }

    private void ignoreInInbox(ThingTypeUID thingtypeUID, String representationValue) {
        List<DiscoveryResult> results = this.inbox.stream().filter(InboxPredicates.withRepresentationPropertyValue(representationValue)).filter(InboxPredicates.forThingTypeUID(thingtypeUID)).toList();
        if (results.size() == 1) {
            this.logger.debug("Auto-ignoring the inbox entry for the representation value '{}'.", (Object)representationValue);
            this.inbox.setFlag(results.getFirst().getThingUID(), DiscoveryResultFlag.IGNORED);
        }
    }

    private void removePossiblyIgnoredResultInInbox(@Nullable Thing thing) {
        String representationValue;
        if (thing != null && (representationValue = this.getRepresentationPropertyValueForThing(thing)) != null) {
            this.removeFromInbox(thing.getThingTypeUID(), representationValue);
        }
    }

    private @Nullable String getRepresentationPropertyValueForThing(Thing thing) {
        ThingType thingType = this.thingTypeRegistry.getThingType(thing.getThingTypeUID());
        if (thingType != null) {
            String representationProperty = thingType.getRepresentationProperty();
            if (representationProperty == null) {
                return null;
            }
            Map properties = thing.getProperties();
            if (properties.containsKey(representationProperty)) {
                return (String)properties.get(representationProperty);
            }
            Configuration configuration = thing.getConfiguration();
            if (configuration.containsKey(representationProperty)) {
                return String.valueOf(configuration.get(representationProperty));
            }
        }
        return null;
    }

    private void removeFromInbox(ThingTypeUID thingtypeUID, String representationValue) {
        List<DiscoveryResult> results = this.inbox.stream().filter(InboxPredicates.withRepresentationPropertyValue(representationValue)).filter(InboxPredicates.forThingTypeUID(thingtypeUID)).filter(InboxPredicates.withFlag(DiscoveryResultFlag.IGNORED)).toList();
        if (results.size() == 1) {
            this.logger.debug("Removing the ignored result from the inbox for the representation value '{}'.", (Object)representationValue);
            this.inbox.remove(results.getFirst().getThingUID());
        }
    }

    private void autoApproveInboxEntries() {
        for (DiscoveryResult result : this.inbox.getAll()) {
            if (!DiscoveryResultFlag.NEW.equals((Object)result.getFlag()) || !this.alwaysAutoApprove && !this.isToBeAutoApproved(result)) continue;
            this.inbox.approve(result.getThingUID(), result.getLabel(), null);
        }
    }

    private boolean isToBeAutoApproved(DiscoveryResult result) {
        return this.inboxAutoApprovePredicates.stream().anyMatch(predicate -> predicate.test(result));
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addInboxAutoApprovePredicate(InboxAutoApprovePredicate inboxAutoApprovePredicate) {
        this.inboxAutoApprovePredicates.add(inboxAutoApprovePredicate);
        for (DiscoveryResult result : this.inbox.getAll()) {
            if (!DiscoveryResultFlag.NEW.equals((Object)result.getFlag()) || !inboxAutoApprovePredicate.test(result)) continue;
            this.inbox.approve(result.getThingUID(), result.getLabel(), null);
        }
    }

    protected void removeInboxAutoApprovePredicate(InboxAutoApprovePredicate inboxAutoApprovePredicate) {
        this.inboxAutoApprovePredicates.remove(inboxAutoApprovePredicate);
    }
}

