// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/certificatemanager/v1/certificate_manager.proto

#include "google/cloud/certificatemanager/v1/internal/certificate_manager_connection_impl.h"
#include "google/cloud/certificatemanager/v1/internal/certificate_manager_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace certificatemanager_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<certificatemanager_v1::CertificateManagerRetryPolicy>
retry_policy(Options const& options) {
  return options
      .get<certificatemanager_v1::CertificateManagerRetryPolicyOption>()
      ->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options
      .get<certificatemanager_v1::CertificateManagerBackoffPolicyOption>()
      ->clone();
}

std::unique_ptr<
    certificatemanager_v1::CertificateManagerConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<certificatemanager_v1::
               CertificateManagerConnectionIdempotencyPolicyOption>()
      ->clone();
}

std::unique_ptr<PollingPolicy> polling_policy(Options const& options) {
  return options
      .get<certificatemanager_v1::CertificateManagerPollingPolicyOption>()
      ->clone();
}

}  // namespace

CertificateManagerConnectionImpl::CertificateManagerConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<certificatemanager_v1_internal::CertificateManagerStub>
        stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(
          std::move(options), CertificateManagerConnection::options())) {}

StreamRange<google::cloud::certificatemanager::v1::Certificate>
CertificateManagerConnectionImpl::ListCertificates(
    google::cloud::certificatemanager::v1::ListCertificatesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListCertificates(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::certificatemanager::v1::Certificate>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<
           certificatemanager_v1::CertificateManagerRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::certificatemanager::v1::ListCertificatesRequest const&
              r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::certificatemanager::v1::
                       ListCertificatesRequest const& request) {
              return stub->ListCertificates(context, request);
            },
            r, function_name);
      },
      [](google::cloud::certificatemanager::v1::ListCertificatesResponse r) {
        std::vector<google::cloud::certificatemanager::v1::Certificate> result(
            r.certificates().size());
        auto& messages = *r.mutable_certificates();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::certificatemanager::v1::Certificate>
CertificateManagerConnectionImpl::GetCertificate(
    google::cloud::certificatemanager::v1::GetCertificateRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetCertificate(request),
      [this](grpc::ClientContext& context,
             google::cloud::certificatemanager::v1::GetCertificateRequest const&
                 request) { return stub_->GetCertificate(context, request); },
      request, __func__);
}

future<StatusOr<google::cloud::certificatemanager::v1::Certificate>>
CertificateManagerConnectionImpl::CreateCertificate(
    google::cloud::certificatemanager::v1::CreateCertificateRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::certificatemanager::v1::Certificate>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::certificatemanager::v1::CreateCertificateRequest const&
              request) {
        return stub->AsyncCreateCertificate(cq, std::move(context), options,
                                            request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::certificatemanager::v1::Certificate>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateCertificate(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::certificatemanager::v1::Certificate>>
CertificateManagerConnectionImpl::UpdateCertificate(
    google::cloud::certificatemanager::v1::UpdateCertificateRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::certificatemanager::v1::Certificate>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::certificatemanager::v1::UpdateCertificateRequest const&
              request) {
        return stub->AsyncUpdateCertificate(cq, std::move(context), options,
                                            request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::certificatemanager::v1::Certificate>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateCertificate(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::certificatemanager::v1::OperationMetadata>>
CertificateManagerConnectionImpl::DeleteCertificate(
    google::cloud::certificatemanager::v1::DeleteCertificateRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::certificatemanager::v1::OperationMetadata>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::certificatemanager::v1::DeleteCertificateRequest const&
              request) {
        return stub->AsyncDeleteCertificate(cq, std::move(context), options,
                                            request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::certificatemanager::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteCertificate(request),
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::certificatemanager::v1::CertificateMap>
CertificateManagerConnectionImpl::ListCertificateMaps(
    google::cloud::certificatemanager::v1::ListCertificateMapsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListCertificateMaps(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::certificatemanager::v1::CertificateMap>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<
           certificatemanager_v1::CertificateManagerRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::certificatemanager::v1::
              ListCertificateMapsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::certificatemanager::v1::
                       ListCertificateMapsRequest const& request) {
              return stub->ListCertificateMaps(context, request);
            },
            r, function_name);
      },
      [](google::cloud::certificatemanager::v1::ListCertificateMapsResponse r) {
        std::vector<google::cloud::certificatemanager::v1::CertificateMap>
            result(r.certificate_maps().size());
        auto& messages = *r.mutable_certificate_maps();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::certificatemanager::v1::CertificateMap>
CertificateManagerConnectionImpl::GetCertificateMap(
    google::cloud::certificatemanager::v1::GetCertificateMapRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetCertificateMap(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::certificatemanager::v1::GetCertificateMapRequest const&
              request) { return stub_->GetCertificateMap(context, request); },
      request, __func__);
}

future<StatusOr<google::cloud::certificatemanager::v1::CertificateMap>>
CertificateManagerConnectionImpl::CreateCertificateMap(
    google::cloud::certificatemanager::v1::CreateCertificateMapRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::certificatemanager::v1::CertificateMap>(
      background_->cq(), current, request,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::cloud::certificatemanager::v1::
                         CreateCertificateMapRequest const& request) {
        return stub->AsyncCreateCertificateMap(cq, std::move(context), options,
                                               request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::certificatemanager::v1::CertificateMap>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateCertificateMap(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::certificatemanager::v1::CertificateMap>>
CertificateManagerConnectionImpl::UpdateCertificateMap(
    google::cloud::certificatemanager::v1::UpdateCertificateMapRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::certificatemanager::v1::CertificateMap>(
      background_->cq(), current, request,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::cloud::certificatemanager::v1::
                         UpdateCertificateMapRequest const& request) {
        return stub->AsyncUpdateCertificateMap(cq, std::move(context), options,
                                               request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::certificatemanager::v1::CertificateMap>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateCertificateMap(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::certificatemanager::v1::OperationMetadata>>
CertificateManagerConnectionImpl::DeleteCertificateMap(
    google::cloud::certificatemanager::v1::DeleteCertificateMapRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::certificatemanager::v1::OperationMetadata>(
      background_->cq(), current, request,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::cloud::certificatemanager::v1::
                         DeleteCertificateMapRequest const& request) {
        return stub->AsyncDeleteCertificateMap(cq, std::move(context), options,
                                               request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::certificatemanager::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteCertificateMap(request),
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::certificatemanager::v1::CertificateMapEntry>
CertificateManagerConnectionImpl::ListCertificateMapEntries(
    google::cloud::certificatemanager::v1::ListCertificateMapEntriesRequest
        request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListCertificateMapEntries(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::certificatemanager::v1::CertificateMapEntry>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<
           certificatemanager_v1::CertificateManagerRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::certificatemanager::v1::
              ListCertificateMapEntriesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::certificatemanager::v1::
                       ListCertificateMapEntriesRequest const& request) {
              return stub->ListCertificateMapEntries(context, request);
            },
            r, function_name);
      },
      [](google::cloud::certificatemanager::v1::
             ListCertificateMapEntriesResponse r) {
        std::vector<google::cloud::certificatemanager::v1::CertificateMapEntry>
            result(r.certificate_map_entries().size());
        auto& messages = *r.mutable_certificate_map_entries();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::certificatemanager::v1::CertificateMapEntry>
CertificateManagerConnectionImpl::GetCertificateMapEntry(
    google::cloud::certificatemanager::v1::GetCertificateMapEntryRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetCertificateMapEntry(request),
      [this](grpc::ClientContext& context,
             google::cloud::certificatemanager::v1::
                 GetCertificateMapEntryRequest const& request) {
        return stub_->GetCertificateMapEntry(context, request);
      },
      request, __func__);
}

future<StatusOr<google::cloud::certificatemanager::v1::CertificateMapEntry>>
CertificateManagerConnectionImpl::CreateCertificateMapEntry(
    google::cloud::certificatemanager::v1::
        CreateCertificateMapEntryRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::certificatemanager::v1::CertificateMapEntry>(
      background_->cq(), current, request,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::cloud::certificatemanager::v1::
                         CreateCertificateMapEntryRequest const& request) {
        return stub->AsyncCreateCertificateMapEntry(cq, std::move(context),
                                                    options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::certificatemanager::v1::CertificateMapEntry>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateCertificateMapEntry(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::certificatemanager::v1::CertificateMapEntry>>
CertificateManagerConnectionImpl::UpdateCertificateMapEntry(
    google::cloud::certificatemanager::v1::
        UpdateCertificateMapEntryRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::certificatemanager::v1::CertificateMapEntry>(
      background_->cq(), current, request,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::cloud::certificatemanager::v1::
                         UpdateCertificateMapEntryRequest const& request) {
        return stub->AsyncUpdateCertificateMapEntry(cq, std::move(context),
                                                    options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::certificatemanager::v1::CertificateMapEntry>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateCertificateMapEntry(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::certificatemanager::v1::OperationMetadata>>
CertificateManagerConnectionImpl::DeleteCertificateMapEntry(
    google::cloud::certificatemanager::v1::
        DeleteCertificateMapEntryRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::certificatemanager::v1::OperationMetadata>(
      background_->cq(), current, request,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::cloud::certificatemanager::v1::
                         DeleteCertificateMapEntryRequest const& request) {
        return stub->AsyncDeleteCertificateMapEntry(cq, std::move(context),
                                                    options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::certificatemanager::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteCertificateMapEntry(request),
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::certificatemanager::v1::DnsAuthorization>
CertificateManagerConnectionImpl::ListDnsAuthorizations(
    google::cloud::certificatemanager::v1::ListDnsAuthorizationsRequest
        request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListDnsAuthorizations(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::certificatemanager::v1::DnsAuthorization>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<
           certificatemanager_v1::CertificateManagerRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::certificatemanager::v1::
              ListDnsAuthorizationsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::certificatemanager::v1::
                       ListDnsAuthorizationsRequest const& request) {
              return stub->ListDnsAuthorizations(context, request);
            },
            r, function_name);
      },
      [](google::cloud::certificatemanager::v1::ListDnsAuthorizationsResponse
             r) {
        std::vector<google::cloud::certificatemanager::v1::DnsAuthorization>
            result(r.dns_authorizations().size());
        auto& messages = *r.mutable_dns_authorizations();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::certificatemanager::v1::DnsAuthorization>
CertificateManagerConnectionImpl::GetDnsAuthorization(
    google::cloud::certificatemanager::v1::GetDnsAuthorizationRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetDnsAuthorization(request),
      [this](grpc::ClientContext& context,
             google::cloud::certificatemanager::v1::
                 GetDnsAuthorizationRequest const& request) {
        return stub_->GetDnsAuthorization(context, request);
      },
      request, __func__);
}

future<StatusOr<google::cloud::certificatemanager::v1::DnsAuthorization>>
CertificateManagerConnectionImpl::CreateDnsAuthorization(
    google::cloud::certificatemanager::v1::CreateDnsAuthorizationRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::certificatemanager::v1::DnsAuthorization>(
      background_->cq(), current, request,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::cloud::certificatemanager::v1::
                         CreateDnsAuthorizationRequest const& request) {
        return stub->AsyncCreateDnsAuthorization(cq, std::move(context),
                                                 options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::certificatemanager::v1::DnsAuthorization>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateDnsAuthorization(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::certificatemanager::v1::DnsAuthorization>>
CertificateManagerConnectionImpl::UpdateDnsAuthorization(
    google::cloud::certificatemanager::v1::UpdateDnsAuthorizationRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::certificatemanager::v1::DnsAuthorization>(
      background_->cq(), current, request,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::cloud::certificatemanager::v1::
                         UpdateDnsAuthorizationRequest const& request) {
        return stub->AsyncUpdateDnsAuthorization(cq, std::move(context),
                                                 options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::certificatemanager::v1::DnsAuthorization>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateDnsAuthorization(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::certificatemanager::v1::OperationMetadata>>
CertificateManagerConnectionImpl::DeleteDnsAuthorization(
    google::cloud::certificatemanager::v1::DeleteDnsAuthorizationRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::certificatemanager::v1::OperationMetadata>(
      background_->cq(), current, request,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::cloud::certificatemanager::v1::
                         DeleteDnsAuthorizationRequest const& request) {
        return stub->AsyncDeleteDnsAuthorization(cq, std::move(context),
                                                 options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::certificatemanager::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteDnsAuthorization(request),
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::certificatemanager::v1::CertificateIssuanceConfig>
CertificateManagerConnectionImpl::ListCertificateIssuanceConfigs(
    google::cloud::certificatemanager::v1::ListCertificateIssuanceConfigsRequest
        request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListCertificateIssuanceConfigs(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<StreamRange<
      google::cloud::certificatemanager::v1::CertificateIssuanceConfig>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<
           certificatemanager_v1::CertificateManagerRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::certificatemanager::v1::
              ListCertificateIssuanceConfigsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::certificatemanager::v1::
                       ListCertificateIssuanceConfigsRequest const& request) {
              return stub->ListCertificateIssuanceConfigs(context, request);
            },
            r, function_name);
      },
      [](google::cloud::certificatemanager::v1::
             ListCertificateIssuanceConfigsResponse r) {
        std::vector<
            google::cloud::certificatemanager::v1::CertificateIssuanceConfig>
            result(r.certificate_issuance_configs().size());
        auto& messages = *r.mutable_certificate_issuance_configs();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::certificatemanager::v1::CertificateIssuanceConfig>
CertificateManagerConnectionImpl::GetCertificateIssuanceConfig(
    google::cloud::certificatemanager::v1::
        GetCertificateIssuanceConfigRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetCertificateIssuanceConfig(request),
      [this](grpc::ClientContext& context,
             google::cloud::certificatemanager::v1::
                 GetCertificateIssuanceConfigRequest const& request) {
        return stub_->GetCertificateIssuanceConfig(context, request);
      },
      request, __func__);
}

future<
    StatusOr<google::cloud::certificatemanager::v1::CertificateIssuanceConfig>>
CertificateManagerConnectionImpl::CreateCertificateIssuanceConfig(
    google::cloud::certificatemanager::v1::
        CreateCertificateIssuanceConfigRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::certificatemanager::v1::CertificateIssuanceConfig>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::certificatemanager::v1::
              CreateCertificateIssuanceConfigRequest const& request) {
        return stub->AsyncCreateCertificateIssuanceConfig(
            cq, std::move(context), options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::certificatemanager::v1::CertificateIssuanceConfig>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateCertificateIssuanceConfig(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::certificatemanager::v1::OperationMetadata>>
CertificateManagerConnectionImpl::DeleteCertificateIssuanceConfig(
    google::cloud::certificatemanager::v1::
        DeleteCertificateIssuanceConfigRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::certificatemanager::v1::OperationMetadata>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::certificatemanager::v1::
              DeleteCertificateIssuanceConfigRequest const& request) {
        return stub->AsyncDeleteCertificateIssuanceConfig(
            cq, std::move(context), options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::certificatemanager::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteCertificateIssuanceConfig(request),
      polling_policy(*current), __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace certificatemanager_v1_internal
}  // namespace cloud
}  // namespace google
