// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source:
// google/cloud/compute/target_https_proxies/v1/target_https_proxies.proto

#include "google/cloud/compute/target_https_proxies/v1/internal/target_https_proxies_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_target_https_proxies_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

TargetHttpsProxiesTracingConnection::TargetHttpsProxiesTracingConnection(
    std::shared_ptr<
        compute_target_https_proxies_v1::TargetHttpsProxiesConnection>
        child)
    : child_(std::move(child)) {}

StreamRange<std::pair<
    std::string, google::cloud::cpp::compute::v1::TargetHttpsProxiesScopedList>>
TargetHttpsProxiesTracingConnection::AggregatedListTargetHttpsProxies(
    google::cloud::cpp::compute::target_https_proxies::v1::
        AggregatedListTargetHttpsProxiesRequest request) {
  auto span = internal::MakeSpan(
      "compute_target_https_proxies_v1::TargetHttpsProxiesConnection::"
      "AggregatedListTargetHttpsProxies");
  internal::OTelScope scope(span);
  auto sr = child_->AggregatedListTargetHttpsProxies(std::move(request));
  return internal::MakeTracedStreamRange<
      std::pair<std::string,
                google::cloud::cpp::compute::v1::TargetHttpsProxiesScopedList>>(
      std::move(span), std::move(sr));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
TargetHttpsProxiesTracingConnection::DeleteTargetHttpsProxy(
    google::cloud::cpp::compute::target_https_proxies::v1::
        DeleteTargetHttpsProxyRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_target_https_proxies_v1::TargetHttpsProxiesConnection::"
      "DeleteTargetHttpsProxy");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteTargetHttpsProxy(request));
}

StatusOr<google::cloud::cpp::compute::v1::TargetHttpsProxy>
TargetHttpsProxiesTracingConnection::GetTargetHttpsProxy(
    google::cloud::cpp::compute::target_https_proxies::v1::
        GetTargetHttpsProxyRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_target_https_proxies_v1::TargetHttpsProxiesConnection::"
      "GetTargetHttpsProxy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetTargetHttpsProxy(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
TargetHttpsProxiesTracingConnection::InsertTargetHttpsProxy(
    google::cloud::cpp::compute::target_https_proxies::v1::
        InsertTargetHttpsProxyRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_target_https_proxies_v1::TargetHttpsProxiesConnection::"
      "InsertTargetHttpsProxy");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->InsertTargetHttpsProxy(request));
}

StreamRange<google::cloud::cpp::compute::v1::TargetHttpsProxy>
TargetHttpsProxiesTracingConnection::ListTargetHttpsProxies(
    google::cloud::cpp::compute::target_https_proxies::v1::
        ListTargetHttpsProxiesRequest request) {
  auto span = internal::MakeSpan(
      "compute_target_https_proxies_v1::TargetHttpsProxiesConnection::"
      "ListTargetHttpsProxies");
  internal::OTelScope scope(span);
  auto sr = child_->ListTargetHttpsProxies(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::cpp::compute::v1::TargetHttpsProxy>(std::move(span),
                                                         std::move(sr));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
TargetHttpsProxiesTracingConnection::PatchTargetHttpsProxy(
    google::cloud::cpp::compute::target_https_proxies::v1::
        PatchTargetHttpsProxyRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_target_https_proxies_v1::TargetHttpsProxiesConnection::"
      "PatchTargetHttpsProxy");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->PatchTargetHttpsProxy(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
TargetHttpsProxiesTracingConnection::SetCertificateMap(
    google::cloud::cpp::compute::target_https_proxies::v1::
        SetCertificateMapRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_target_https_proxies_v1::TargetHttpsProxiesConnection::"
      "SetCertificateMap");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->SetCertificateMap(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
TargetHttpsProxiesTracingConnection::SetQuicOverride(
    google::cloud::cpp::compute::target_https_proxies::v1::
        SetQuicOverrideRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_target_https_proxies_v1::TargetHttpsProxiesConnection::"
      "SetQuicOverride");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->SetQuicOverride(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
TargetHttpsProxiesTracingConnection::SetSslCertificates(
    google::cloud::cpp::compute::target_https_proxies::v1::
        SetSslCertificatesRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_target_https_proxies_v1::TargetHttpsProxiesConnection::"
      "SetSslCertificates");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->SetSslCertificates(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
TargetHttpsProxiesTracingConnection::SetSslPolicy(
    google::cloud::cpp::compute::target_https_proxies::v1::
        SetSslPolicyRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_target_https_proxies_v1::TargetHttpsProxiesConnection::"
      "SetSslPolicy");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->SetSslPolicy(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
TargetHttpsProxiesTracingConnection::SetUrlMap(
    google::cloud::cpp::compute::target_https_proxies::v1::
        SetUrlMapRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_target_https_proxies_v1::TargetHttpsProxiesConnection::"
      "SetUrlMap");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->SetUrlMap(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<compute_target_https_proxies_v1::TargetHttpsProxiesConnection>
MakeTargetHttpsProxiesTracingConnection(
    std::shared_ptr<
        compute_target_https_proxies_v1::TargetHttpsProxiesConnection>
        conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn =
        std::make_shared<TargetHttpsProxiesTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_target_https_proxies_v1_internal
}  // namespace cloud
}  // namespace google
