// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/cx/v3/security_settings.proto

#include "google/cloud/dialogflow_cx/security_settings_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace dialogflow_cx {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

SecuritySettingsServiceClient::SecuritySettingsServiceClient(
    std::shared_ptr<SecuritySettingsServiceConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
SecuritySettingsServiceClient::~SecuritySettingsServiceClient() = default;

StatusOr<google::cloud::dialogflow::cx::v3::SecuritySettings>
SecuritySettingsServiceClient::CreateSecuritySettings(
    std::string const& parent,
    google::cloud::dialogflow::cx::v3::SecuritySettings const&
        security_settings,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::CreateSecuritySettingsRequest request;
  request.set_parent(parent);
  *request.mutable_security_settings() = security_settings;
  return connection_->CreateSecuritySettings(request);
}

StatusOr<google::cloud::dialogflow::cx::v3::SecuritySettings>
SecuritySettingsServiceClient::CreateSecuritySettings(
    google::cloud::dialogflow::cx::v3::CreateSecuritySettingsRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateSecuritySettings(request);
}

StatusOr<google::cloud::dialogflow::cx::v3::SecuritySettings>
SecuritySettingsServiceClient::GetSecuritySettings(std::string const& name,
                                                   Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::GetSecuritySettingsRequest request;
  request.set_name(name);
  return connection_->GetSecuritySettings(request);
}

StatusOr<google::cloud::dialogflow::cx::v3::SecuritySettings>
SecuritySettingsServiceClient::GetSecuritySettings(
    google::cloud::dialogflow::cx::v3::GetSecuritySettingsRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetSecuritySettings(request);
}

StatusOr<google::cloud::dialogflow::cx::v3::SecuritySettings>
SecuritySettingsServiceClient::UpdateSecuritySettings(
    google::cloud::dialogflow::cx::v3::SecuritySettings const&
        security_settings,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::UpdateSecuritySettingsRequest request;
  *request.mutable_security_settings() = security_settings;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateSecuritySettings(request);
}

StatusOr<google::cloud::dialogflow::cx::v3::SecuritySettings>
SecuritySettingsServiceClient::UpdateSecuritySettings(
    google::cloud::dialogflow::cx::v3::UpdateSecuritySettingsRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateSecuritySettings(request);
}

StreamRange<google::cloud::dialogflow::cx::v3::SecuritySettings>
SecuritySettingsServiceClient::ListSecuritySettings(std::string const& parent,
                                                    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::ListSecuritySettingsRequest request;
  request.set_parent(parent);
  return connection_->ListSecuritySettings(request);
}

StreamRange<google::cloud::dialogflow::cx::v3::SecuritySettings>
SecuritySettingsServiceClient::ListSecuritySettings(
    google::cloud::dialogflow::cx::v3::ListSecuritySettingsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListSecuritySettings(std::move(request));
}

Status SecuritySettingsServiceClient::DeleteSecuritySettings(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::DeleteSecuritySettingsRequest request;
  request.set_name(name);
  return connection_->DeleteSecuritySettings(request);
}

Status SecuritySettingsServiceClient::DeleteSecuritySettings(
    google::cloud::dialogflow::cx::v3::DeleteSecuritySettingsRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteSecuritySettings(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_cx
}  // namespace cloud
}  // namespace google
