// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/v3/query_service.proto

#include "google/cloud/monitoring/v3/internal/query_connection_impl.h"
#include "google/cloud/monitoring/v3/internal/query_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace monitoring_v3_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<monitoring_v3::QueryServiceRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<monitoring_v3::QueryServiceRetryPolicyOption>()->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options.get<monitoring_v3::QueryServiceBackoffPolicyOption>()->clone();
}

std::unique_ptr<monitoring_v3::QueryServiceConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<monitoring_v3::QueryServiceConnectionIdempotencyPolicyOption>()
      ->clone();
}

}  // namespace

QueryServiceConnectionImpl::QueryServiceConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<monitoring_v3_internal::QueryServiceStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(std::move(options),
                                      QueryServiceConnection::options())) {}

StreamRange<google::monitoring::v3::TimeSeriesData>
QueryServiceConnectionImpl::QueryTimeSeries(
    google::monitoring::v3::QueryTimeSeriesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->QueryTimeSeries(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::monitoring::v3::TimeSeriesData>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<monitoring_v3::QueryServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::monitoring::v3::QueryTimeSeriesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context,
                google::monitoring::v3::QueryTimeSeriesRequest const& request) {
              return stub->QueryTimeSeries(context, request);
            },
            r, function_name);
      },
      [](google::monitoring::v3::QueryTimeSeriesResponse r) {
        std::vector<google::monitoring::v3::TimeSeriesData> result(
            r.time_series_data().size());
        auto& messages = *r.mutable_time_series_data();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring_v3_internal
}  // namespace cloud
}  // namespace google
