// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/feature_online_store_admin_service.proto

#include "google/cloud/aiplatform/v1/internal/feature_online_store_admin_connection_impl.h"
#include "google/cloud/aiplatform/v1/internal/feature_online_store_admin_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace aiplatform_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<aiplatform_v1::FeatureOnlineStoreAdminServiceRetryPolicy>
retry_policy(Options const& options) {
  return options
      .get<aiplatform_v1::FeatureOnlineStoreAdminServiceRetryPolicyOption>()
      ->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options
      .get<aiplatform_v1::FeatureOnlineStoreAdminServiceBackoffPolicyOption>()
      ->clone();
}

std::unique_ptr<
    aiplatform_v1::FeatureOnlineStoreAdminServiceConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<
          aiplatform_v1::
              FeatureOnlineStoreAdminServiceConnectionIdempotencyPolicyOption>()
      ->clone();
}

std::unique_ptr<PollingPolicy> polling_policy(Options const& options) {
  return options
      .get<aiplatform_v1::FeatureOnlineStoreAdminServicePollingPolicyOption>()
      ->clone();
}

}  // namespace

FeatureOnlineStoreAdminServiceConnectionImpl::
    FeatureOnlineStoreAdminServiceConnectionImpl(
        std::unique_ptr<google::cloud::BackgroundThreads> background,
        std::shared_ptr<
            aiplatform_v1_internal::FeatureOnlineStoreAdminServiceStub>
            stub,
        Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(
          std::move(options),
          FeatureOnlineStoreAdminServiceConnection::options())) {}

future<StatusOr<google::cloud::aiplatform::v1::FeatureOnlineStore>>
FeatureOnlineStoreAdminServiceConnectionImpl::CreateFeatureOnlineStore(
    google::cloud::aiplatform::v1::CreateFeatureOnlineStoreRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::aiplatform::v1::FeatureOnlineStore>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::aiplatform::v1::CreateFeatureOnlineStoreRequest const&
              request) {
        return stub->AsyncCreateFeatureOnlineStore(cq, std::move(context),
                                                   options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::aiplatform::v1::FeatureOnlineStore>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateFeatureOnlineStore(request),
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::aiplatform::v1::FeatureOnlineStore>
FeatureOnlineStoreAdminServiceConnectionImpl::GetFeatureOnlineStore(
    google::cloud::aiplatform::v1::GetFeatureOnlineStoreRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetFeatureOnlineStore(request),
      [this](grpc::ClientContext& context,
             google::cloud::aiplatform::v1::GetFeatureOnlineStoreRequest const&
                 request) {
        return stub_->GetFeatureOnlineStore(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::aiplatform::v1::FeatureOnlineStore>
FeatureOnlineStoreAdminServiceConnectionImpl::ListFeatureOnlineStores(
    google::cloud::aiplatform::v1::ListFeatureOnlineStoresRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListFeatureOnlineStores(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::aiplatform::v1::FeatureOnlineStore>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<
           aiplatform_v1::FeatureOnlineStoreAdminServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::aiplatform::v1::ListFeatureOnlineStoresRequest const&
              r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::aiplatform::v1::
                       ListFeatureOnlineStoresRequest const& request) {
              return stub->ListFeatureOnlineStores(context, request);
            },
            r, function_name);
      },
      [](google::cloud::aiplatform::v1::ListFeatureOnlineStoresResponse r) {
        std::vector<google::cloud::aiplatform::v1::FeatureOnlineStore> result(
            r.feature_online_stores().size());
        auto& messages = *r.mutable_feature_online_stores();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

future<StatusOr<google::cloud::aiplatform::v1::FeatureOnlineStore>>
FeatureOnlineStoreAdminServiceConnectionImpl::UpdateFeatureOnlineStore(
    google::cloud::aiplatform::v1::UpdateFeatureOnlineStoreRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::aiplatform::v1::FeatureOnlineStore>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::aiplatform::v1::UpdateFeatureOnlineStoreRequest const&
              request) {
        return stub->AsyncUpdateFeatureOnlineStore(cq, std::move(context),
                                                   options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::aiplatform::v1::FeatureOnlineStore>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateFeatureOnlineStore(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
FeatureOnlineStoreAdminServiceConnectionImpl::DeleteFeatureOnlineStore(
    google::cloud::aiplatform::v1::DeleteFeatureOnlineStoreRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::aiplatform::v1::DeleteOperationMetadata>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::aiplatform::v1::DeleteFeatureOnlineStoreRequest const&
              request) {
        return stub->AsyncDeleteFeatureOnlineStore(cq, std::move(context),
                                                   options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::aiplatform::v1::DeleteOperationMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteFeatureOnlineStore(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::aiplatform::v1::FeatureView>>
FeatureOnlineStoreAdminServiceConnectionImpl::CreateFeatureView(
    google::cloud::aiplatform::v1::CreateFeatureViewRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::aiplatform::v1::FeatureView>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::aiplatform::v1::CreateFeatureViewRequest const&
              request) {
        return stub->AsyncCreateFeatureView(cq, std::move(context), options,
                                            request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::aiplatform::v1::FeatureView>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateFeatureView(request),
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::aiplatform::v1::FeatureView>
FeatureOnlineStoreAdminServiceConnectionImpl::GetFeatureView(
    google::cloud::aiplatform::v1::GetFeatureViewRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetFeatureView(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::aiplatform::v1::GetFeatureViewRequest const& request) {
        return stub_->GetFeatureView(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::aiplatform::v1::FeatureView>
FeatureOnlineStoreAdminServiceConnectionImpl::ListFeatureViews(
    google::cloud::aiplatform::v1::ListFeatureViewsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListFeatureViews(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::aiplatform::v1::FeatureView>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<
           aiplatform_v1::FeatureOnlineStoreAdminServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::aiplatform::v1::ListFeatureViewsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::aiplatform::v1::ListFeatureViewsRequest const&
                       request) {
              return stub->ListFeatureViews(context, request);
            },
            r, function_name);
      },
      [](google::cloud::aiplatform::v1::ListFeatureViewsResponse r) {
        std::vector<google::cloud::aiplatform::v1::FeatureView> result(
            r.feature_views().size());
        auto& messages = *r.mutable_feature_views();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

future<StatusOr<google::cloud::aiplatform::v1::FeatureView>>
FeatureOnlineStoreAdminServiceConnectionImpl::UpdateFeatureView(
    google::cloud::aiplatform::v1::UpdateFeatureViewRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::aiplatform::v1::FeatureView>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::aiplatform::v1::UpdateFeatureViewRequest const&
              request) {
        return stub->AsyncUpdateFeatureView(cq, std::move(context), options,
                                            request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::aiplatform::v1::FeatureView>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateFeatureView(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
FeatureOnlineStoreAdminServiceConnectionImpl::DeleteFeatureView(
    google::cloud::aiplatform::v1::DeleteFeatureViewRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::aiplatform::v1::DeleteOperationMetadata>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::aiplatform::v1::DeleteFeatureViewRequest const&
              request) {
        return stub->AsyncDeleteFeatureView(cq, std::move(context), options,
                                            request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::aiplatform::v1::DeleteOperationMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteFeatureView(request),
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::aiplatform::v1::SyncFeatureViewResponse>
FeatureOnlineStoreAdminServiceConnectionImpl::SyncFeatureView(
    google::cloud::aiplatform::v1::SyncFeatureViewRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->SyncFeatureView(request),
      [this](grpc::ClientContext& context,
             google::cloud::aiplatform::v1::SyncFeatureViewRequest const&
                 request) { return stub_->SyncFeatureView(context, request); },
      request, __func__);
}

StatusOr<google::cloud::aiplatform::v1::FeatureViewSync>
FeatureOnlineStoreAdminServiceConnectionImpl::GetFeatureViewSync(
    google::cloud::aiplatform::v1::GetFeatureViewSyncRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetFeatureViewSync(request),
      [this](grpc::ClientContext& context,
             google::cloud::aiplatform::v1::GetFeatureViewSyncRequest const&
                 request) {
        return stub_->GetFeatureViewSync(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::aiplatform::v1::FeatureViewSync>
FeatureOnlineStoreAdminServiceConnectionImpl::ListFeatureViewSyncs(
    google::cloud::aiplatform::v1::ListFeatureViewSyncsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListFeatureViewSyncs(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::aiplatform::v1::FeatureViewSync>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<
           aiplatform_v1::FeatureOnlineStoreAdminServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::aiplatform::v1::ListFeatureViewSyncsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::aiplatform::v1::
                       ListFeatureViewSyncsRequest const& request) {
              return stub->ListFeatureViewSyncs(context, request);
            },
            r, function_name);
      },
      [](google::cloud::aiplatform::v1::ListFeatureViewSyncsResponse r) {
        std::vector<google::cloud::aiplatform::v1::FeatureViewSync> result(
            r.feature_view_syncs().size());
        auto& messages = *r.mutable_feature_view_syncs();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1_internal
}  // namespace cloud
}  // namespace google
