// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/connection/v1/connection.proto

#include "google/cloud/bigquery/connection/v1/internal/connection_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace bigquery_connection_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

ConnectionServiceTracingConnection::ConnectionServiceTracingConnection(
    std::shared_ptr<bigquery_connection_v1::ConnectionServiceConnection> child)
    : child_(std::move(child)) {}

StatusOr<google::cloud::bigquery::connection::v1::Connection>
ConnectionServiceTracingConnection::CreateConnection(
    google::cloud::bigquery::connection::v1::CreateConnectionRequest const&
        request) {
  auto span = internal::MakeSpan(
      "bigquery_connection_v1::ConnectionServiceConnection::CreateConnection");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateConnection(request));
}

StatusOr<google::cloud::bigquery::connection::v1::Connection>
ConnectionServiceTracingConnection::GetConnection(
    google::cloud::bigquery::connection::v1::GetConnectionRequest const&
        request) {
  auto span = internal::MakeSpan(
      "bigquery_connection_v1::ConnectionServiceConnection::GetConnection");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetConnection(request));
}

StreamRange<google::cloud::bigquery::connection::v1::Connection>
ConnectionServiceTracingConnection::ListConnections(
    google::cloud::bigquery::connection::v1::ListConnectionsRequest request) {
  auto span = internal::MakeSpan(
      "bigquery_connection_v1::ConnectionServiceConnection::ListConnections");
  internal::OTelScope scope(span);
  auto sr = child_->ListConnections(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::bigquery::connection::v1::Connection>(std::move(span),
                                                           std::move(sr));
}

StatusOr<google::cloud::bigquery::connection::v1::Connection>
ConnectionServiceTracingConnection::UpdateConnection(
    google::cloud::bigquery::connection::v1::UpdateConnectionRequest const&
        request) {
  auto span = internal::MakeSpan(
      "bigquery_connection_v1::ConnectionServiceConnection::UpdateConnection");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateConnection(request));
}

Status ConnectionServiceTracingConnection::DeleteConnection(
    google::cloud::bigquery::connection::v1::DeleteConnectionRequest const&
        request) {
  auto span = internal::MakeSpan(
      "bigquery_connection_v1::ConnectionServiceConnection::DeleteConnection");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteConnection(request));
}

StatusOr<google::iam::v1::Policy>
ConnectionServiceTracingConnection::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const& request) {
  auto span = internal::MakeSpan(
      "bigquery_connection_v1::ConnectionServiceConnection::GetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetIamPolicy(request));
}

StatusOr<google::iam::v1::Policy>
ConnectionServiceTracingConnection::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  auto span = internal::MakeSpan(
      "bigquery_connection_v1::ConnectionServiceConnection::SetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->SetIamPolicy(request));
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
ConnectionServiceTracingConnection::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const& request) {
  auto span = internal::MakeSpan(
      "bigquery_connection_v1::ConnectionServiceConnection::"
      "TestIamPermissions");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->TestIamPermissions(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<bigquery_connection_v1::ConnectionServiceConnection>
MakeConnectionServiceTracingConnection(
    std::shared_ptr<bigquery_connection_v1::ConnectionServiceConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn =
        std::make_shared<ConnectionServiceTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquery_connection_v1_internal
}  // namespace cloud
}  // namespace google
