// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/spanner/v1/spanner.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SPANNER_INTERNAL_SPANNER_STUB_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SPANNER_INTERNAL_SPANNER_STUB_H

#include "google/cloud/completion_queue.h"
#include "google/cloud/future.h"
#include "google/cloud/internal/streaming_read_rpc.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/spanner/v1/spanner.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace spanner_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class SpannerStub {
 public:
  virtual ~SpannerStub() = 0;

  virtual StatusOr<google::spanner::v1::Session> CreateSession(
      grpc::ClientContext& context,
      google::spanner::v1::CreateSessionRequest const& request) = 0;

  virtual StatusOr<google::spanner::v1::BatchCreateSessionsResponse>
  BatchCreateSessions(
      grpc::ClientContext& context,
      google::spanner::v1::BatchCreateSessionsRequest const& request) = 0;

  virtual Status DeleteSession(
      grpc::ClientContext& context,
      google::spanner::v1::DeleteSessionRequest const& request) = 0;

  virtual StatusOr<google::spanner::v1::ResultSet> ExecuteSql(
      grpc::ClientContext& context,
      google::spanner::v1::ExecuteSqlRequest const& request) = 0;

  virtual std::unique_ptr<google::cloud::internal::StreamingReadRpc<
      google::spanner::v1::PartialResultSet>>
  ExecuteStreamingSql(
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::spanner::v1::ExecuteSqlRequest const& request) = 0;

  virtual StatusOr<google::spanner::v1::ExecuteBatchDmlResponse>
  ExecuteBatchDml(
      grpc::ClientContext& context,
      google::spanner::v1::ExecuteBatchDmlRequest const& request) = 0;

  virtual std::unique_ptr<google::cloud::internal::StreamingReadRpc<
      google::spanner::v1::PartialResultSet>>
  StreamingRead(std::shared_ptr<grpc::ClientContext> context,
                Options const& options,
                google::spanner::v1::ReadRequest const& request) = 0;

  virtual StatusOr<google::spanner::v1::Transaction> BeginTransaction(
      grpc::ClientContext& context,
      google::spanner::v1::BeginTransactionRequest const& request) = 0;

  virtual StatusOr<google::spanner::v1::CommitResponse> Commit(
      grpc::ClientContext& context,
      google::spanner::v1::CommitRequest const& request) = 0;

  virtual Status Rollback(
      grpc::ClientContext& context,
      google::spanner::v1::RollbackRequest const& request) = 0;

  virtual StatusOr<google::spanner::v1::PartitionResponse> PartitionQuery(
      grpc::ClientContext& context,
      google::spanner::v1::PartitionQueryRequest const& request) = 0;

  virtual StatusOr<google::spanner::v1::PartitionResponse> PartitionRead(
      grpc::ClientContext& context,
      google::spanner::v1::PartitionReadRequest const& request) = 0;

  virtual std::unique_ptr<google::cloud::internal::StreamingReadRpc<
      google::spanner::v1::BatchWriteResponse>>
  BatchWrite(std::shared_ptr<grpc::ClientContext> context,
             Options const& options,
             google::spanner::v1::BatchWriteRequest const& request) = 0;

  virtual future<StatusOr<google::spanner::v1::BatchCreateSessionsResponse>>
  AsyncBatchCreateSessions(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::spanner::v1::BatchCreateSessionsRequest const& request) = 0;

  virtual future<Status> AsyncDeleteSession(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::spanner::v1::DeleteSessionRequest const& request) = 0;

  virtual future<StatusOr<google::spanner::v1::ResultSet>> AsyncExecuteSql(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::spanner::v1::ExecuteSqlRequest const& request) = 0;
};

class DefaultSpannerStub : public SpannerStub {
 public:
  explicit DefaultSpannerStub(
      std::unique_ptr<google::spanner::v1::Spanner::StubInterface> grpc_stub)
      : grpc_stub_(std::move(grpc_stub)) {}

  StatusOr<google::spanner::v1::Session> CreateSession(
      grpc::ClientContext& context,
      google::spanner::v1::CreateSessionRequest const& request) override;

  StatusOr<google::spanner::v1::BatchCreateSessionsResponse>
  BatchCreateSessions(
      grpc::ClientContext& context,
      google::spanner::v1::BatchCreateSessionsRequest const& request) override;

  Status DeleteSession(
      grpc::ClientContext& context,
      google::spanner::v1::DeleteSessionRequest const& request) override;

  StatusOr<google::spanner::v1::ResultSet> ExecuteSql(
      grpc::ClientContext& context,
      google::spanner::v1::ExecuteSqlRequest const& request) override;

  std::unique_ptr<google::cloud::internal::StreamingReadRpc<
      google::spanner::v1::PartialResultSet>>
  ExecuteStreamingSql(
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::spanner::v1::ExecuteSqlRequest const& request) override;

  StatusOr<google::spanner::v1::ExecuteBatchDmlResponse> ExecuteBatchDml(
      grpc::ClientContext& context,
      google::spanner::v1::ExecuteBatchDmlRequest const& request) override;

  std::unique_ptr<google::cloud::internal::StreamingReadRpc<
      google::spanner::v1::PartialResultSet>>
  StreamingRead(std::shared_ptr<grpc::ClientContext> context,
                Options const& options,
                google::spanner::v1::ReadRequest const& request) override;

  StatusOr<google::spanner::v1::Transaction> BeginTransaction(
      grpc::ClientContext& context,
      google::spanner::v1::BeginTransactionRequest const& request) override;

  StatusOr<google::spanner::v1::CommitResponse> Commit(
      grpc::ClientContext& context,
      google::spanner::v1::CommitRequest const& request) override;

  Status Rollback(grpc::ClientContext& context,
                  google::spanner::v1::RollbackRequest const& request) override;

  StatusOr<google::spanner::v1::PartitionResponse> PartitionQuery(
      grpc::ClientContext& context,
      google::spanner::v1::PartitionQueryRequest const& request) override;

  StatusOr<google::spanner::v1::PartitionResponse> PartitionRead(
      grpc::ClientContext& context,
      google::spanner::v1::PartitionReadRequest const& request) override;

  std::unique_ptr<google::cloud::internal::StreamingReadRpc<
      google::spanner::v1::BatchWriteResponse>>
  BatchWrite(std::shared_ptr<grpc::ClientContext> context,
             Options const& options,
             google::spanner::v1::BatchWriteRequest const& request) override;

  future<StatusOr<google::spanner::v1::BatchCreateSessionsResponse>>
  AsyncBatchCreateSessions(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::spanner::v1::BatchCreateSessionsRequest const& request) override;

  future<Status> AsyncDeleteSession(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::spanner::v1::DeleteSessionRequest const& request) override;

  future<StatusOr<google::spanner::v1::ResultSet>> AsyncExecuteSql(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::spanner::v1::ExecuteSqlRequest const& request) override;

 private:
  std::unique_ptr<google::spanner::v1::Spanner::StubInterface> grpc_stub_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace spanner_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SPANNER_INTERNAL_SPANNER_STUB_H
