---
title: Home
hide:
  - navigation
  - toc
---

# hydrus network - client and server

The hydrus network client is a desktop application written for Anonymous and other internet enthusiasts with large media collections. It organises your files into an internal database and browses them with tags instead of folders, a little like a booru on your desktop. Tags and files can be anonymously shared through custom servers that any user may run. Everything is free, nothing phones home, and the source code is included with the release. It is developed mostly for Windows, but builds for Linux and macOS are available (perhaps with some limitations, depending on your situation).

The software is constantly being improved. I try to put out a new release every Wednesday by 8pm Eastern.

Hydrus supports various filetypes for images, video and audio files, image project files, and more. A full list of supported filetypes is [here](filetypes.md).

On the Windows and Linux builds, an MPV window is embedded to play video and audio smoothly. For files like pdf, which cannot currently be viewed in the client, it is easy to launch any file with your OS's default program.

The client can download files and parse tags from a number of websites, including by default:

*   4chan and other imageboards, with a thread watcher
*   the popular boorus
*   gallery sites like deviant art, hentai foundry, and pixiv
*   tumblr and twitter

And can be extended to download from more locations using easily shareable user-made downloaders. It can also be set to 'subscribe' to any gallery search, repeating it every few days to keep up with new results.

The program's emphasis is on your freedom. There is no DRM, no spying, no censorship. The program never phones home.

## Start Here

If you would like to try hydrus, I _**strongly**_ recommend you check out the **[help and getting started guide](introduction.md)**. It will take you through all the main systems.

## links

* [homepage](https://hydrusnetwork.github.io/hydrus/)
* [github](https://github.com/hydrusnetwork/hydrus) ([latest build](https://github.com/hydrusnetwork/hydrus/releases/latest))
* [issue tracker](https://github.com/hydrusnetwork/hydrus/issues)
* [8chan.moe /t/ (Hydrus Network General)](https://8chan.moe/t/catalog.html)
* [tumblr](https://hydrus.tumblr.com)
* [x](https://x.com/hydrusnetwork)
* [discord](https://discord.gg/wPHPCUZ)
* [patreon](https://www.patreon.com/hydrus_dev)
* [user-run repository and wiki (including download presets for several non-default boorus)](https://github.com/CuddleBear92/Hydrus-Presets-and-Scripts)
* [more links and contact info](contact.md)

## Screenshots

[![](images/screenshot_empty_thumb.png)](images/screenshot_empty.png "An empty page. You can search based on file metadata such as filesize and image resolution, not just tags.") 
[![](images/screenshot_general_search_thumb.png)](images/screenshot_general_search.png "A simple tag search.") 
[![](images/screenshot_desu_thumb.png)](images/screenshot_desu.png "You can add more tags to specify a search. Also pictured is the media viewer, for viewing media in larger size.") 
[![](images/screenshot_thread_watcher_thumb.png)](images/screenshot_thread_watcher.png "The thread watcher works for 4chan and 8chan.") 
[![](images/screenshot_deviant_art_thumb.png)](images/screenshot_deviant_art.png "The gallery downloader will search for all the files for a particular artist or tag and download them, parsing tags as it goes.") 
[![](images/screenshot_big_search_thumb.png)](images/screenshot_big_search.png "The client can easily search, display and manage thousands of files.") 
[![](images/screenshot_gunnerkrigg_collect_thumb.png)](images/screenshot_gunnerkrigg_collect.png "Files can be sorted and collected by their tags.") 
[![](images/screenshot_fullscreen_blame_thumb.png)](images/screenshot_fullscreen_blame.png "The media viewer can work as a resizable window or completely fullscreen. It is clean and fast.") 
[![](images/screenshot_video_thumb.png)](images/screenshot_video.png "Many file formats are supported.") 
[![](images/screenshot_advanced_autocomplete_thumb.png)](images/screenshot_advanced_autocomplete.png "The client can get complicated if you want it to. This screenshot shows a tag sibling, where one tag is immediately swapped with another, and a non-local search, where results that are known but not on the computer are shown.")
