// Copyright © Advanced Micro Devices, Inc., or its affiliates.
// SPDX-License-Identifier:  MIT

#pragma once

#include <memory>

#include <hipdnn_sdk/data_objects/convolution_fwd_attributes_generated.h>
#include <hipdnn_sdk/data_objects/tensor_attributes_generated.h>
#include <miopen/miopen.h>

#include "MiopenConvDescriptor.hpp"
#include "MiopenTensor.hpp"
#include "PlanInterface.hpp"

namespace miopen_legacy_plugin
{

class ConvFwdParams
{
public:
    ConvFwdParams(
        const hipdnn_sdk::data_objects::ConvolutionFwdAttributes& attributes,
        const std::unordered_map<int64_t, const hipdnn_sdk::data_objects::TensorAttributes*>&
            tensorMap);

    ConvFwdParams(const ConvFwdParams&) = delete;
    ConvFwdParams& operator=(const ConvFwdParams&) = delete;

    ConvFwdParams(ConvFwdParams&&) = default;
    ConvFwdParams& operator=(ConvFwdParams&&) = default;

    const MiopenTensor& x() const;
    const MiopenTensor& w() const;
    const MiopenTensor& y() const;
    const MiopenConvDescriptor& conv() const;

private:
    size_t _spatialDimCount;
    MiopenTensor _x;
    MiopenTensor _w;
    MiopenTensor _y;
    MiopenConvDescriptor _conv;
};

class ConvFwdPlan : public IPlan
{
public:
    ConvFwdPlan(const HipdnnEnginePluginHandle& handle, ConvFwdParams&& params);
    ~ConvFwdPlan() override;

    ConvFwdPlan(const ConvFwdPlan&) = delete;
    ConvFwdPlan& operator=(const ConvFwdPlan&) = delete;

    ConvFwdPlan(ConvFwdPlan&& other) noexcept;
    ConvFwdPlan& operator=(ConvFwdPlan&& other) noexcept;

    void execute(const HipdnnEnginePluginHandle& handle,
                 const hipdnnPluginDeviceBuffer_t* deviceBuffers,
                 uint32_t numDeviceBuffers,
                 void* workspace = nullptr) const override;

private:
    ConvFwdParams _params;
    miopenSolution_t _solution = nullptr;
};

} // namespace miopen_legacy_plugin
