/*******************************************************************************
 *
 * MIT License
 *
 * Copyright 2024-2025 AMD ROCm(TM) Software
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 *******************************************************************************/

#pragma once

#include <array>

#include <dataTypeInfo.hpp>

// Approximated to 40 decimal places
constexpr std::array<double, 256> e8m0Values
    = {0.0000000000000000000000000000000000000000,
       0.0000000000000000000000000000000000000118,
       0.0000000000000000000000000000000000000235,
       0.0000000000000000000000000000000000000470,
       0.0000000000000000000000000000000000000940,
       0.0000000000000000000000000000000000001881,
       0.0000000000000000000000000000000000003762,
       0.0000000000000000000000000000000000007523,
       0.0000000000000000000000000000000000015046,
       0.0000000000000000000000000000000000030093,
       0.0000000000000000000000000000000000060185,
       0.0000000000000000000000000000000000120371,
       0.0000000000000000000000000000000000240741,
       0.0000000000000000000000000000000000481482,
       0.0000000000000000000000000000000000962965,
       0.0000000000000000000000000000000001925930,
       0.0000000000000000000000000000000003851860,
       0.0000000000000000000000000000000007703720,
       0.0000000000000000000000000000000015407440,
       0.0000000000000000000000000000000030814879,
       0.0000000000000000000000000000000061629758,
       0.0000000000000000000000000000000123259516,
       0.0000000000000000000000000000000246519033,
       0.0000000000000000000000000000000493038066,
       0.0000000000000000000000000000000986076132,
       0.0000000000000000000000000000001972152263,
       0.0000000000000000000000000000003944304526,
       0.0000000000000000000000000000007888609052,
       0.0000000000000000000000000000015777218104,
       0.0000000000000000000000000000031554436209,
       0.0000000000000000000000000000063108872418,
       0.0000000000000000000000000000126217744835,
       0.0000000000000000000000000000252435489671,
       0.0000000000000000000000000000504870979341,
       0.0000000000000000000000000001009741958683,
       0.0000000000000000000000000002019483917366,
       0.0000000000000000000000000004038967834732,
       0.0000000000000000000000000008077935669463,
       0.0000000000000000000000000016155871338926,
       0.0000000000000000000000000032311742677853,
       0.0000000000000000000000000064623485355705,
       0.0000000000000000000000000129246970711411,
       0.0000000000000000000000000258493941422821,
       0.0000000000000000000000000516987882845642,
       0.0000000000000000000000001033975765691285,
       0.0000000000000000000000002067951531382569,
       0.0000000000000000000000004135903062765138,
       0.0000000000000000000000008271806125530277,
       0.0000000000000000000000016543612251060553,
       0.0000000000000000000000033087224502121107,
       0.0000000000000000000000066174449004242214,
       0.0000000000000000000000132348898008484428,
       0.0000000000000000000000264697796016968856,
       0.0000000000000000000000529395592033937712,
       0.0000000000000000000001058791184067875424,
       0.0000000000000000000002117582368135750848,
       0.0000000000000000000004235164736271501695,
       0.0000000000000000000008470329472543003391,
       0.0000000000000000000016940658945086006781,
       0.0000000000000000000033881317890172013563,
       0.0000000000000000000067762635780344027125,
       0.0000000000000000000135525271560688054251,
       0.0000000000000000000271050543121376108502,
       0.0000000000000000000542101086242752217004,
       0.0000000000000000001084202172485504434007,
       0.0000000000000000002168404344971008868015,
       0.0000000000000000004336808689942017736030,
       0.0000000000000000008673617379884035472060,
       0.0000000000000000017347234759768070944119,
       0.0000000000000000034694469519536141888238,
       0.0000000000000000069388939039072283776477,
       0.0000000000000000138777878078144567552954,
       0.0000000000000000277555756156289135105908,
       0.0000000000000000555111512312578270211816,
       0.0000000000000001110223024625156540423632,
       0.0000000000000002220446049250313080847263,
       0.0000000000000004440892098500626161694527,
       0.0000000000000008881784197001252323389053,
       0.0000000000000017763568394002504646778107,
       0.0000000000000035527136788005009293556213,
       0.0000000000000071054273576010018587112427,
       0.0000000000000142108547152020037174224854,
       0.0000000000000284217094304040074348449707,
       0.0000000000000568434188608080148696899414,
       0.0000000000001136868377216160297393798828,
       0.0000000000002273736754432320594787597656,
       0.0000000000004547473508864641189575195312,
       0.0000000000009094947017729282379150390625,
       0.0000000000018189894035458564758300781250,
       0.0000000000036379788070917129516601562500,
       0.0000000000072759576141834259033203125000,
       0.0000000000145519152283668518066406250000,
       0.0000000000291038304567337036132812500000,
       0.0000000000582076609134674072265625000000,
       0.0000000001164153218269348144531250000000,
       0.0000000002328306436538696289062500000000,
       0.0000000004656612873077392578125000000000,
       0.0000000009313225746154785156250000000000,
       0.0000000018626451492309570312500000000000,
       0.0000000037252902984619140625000000000000,
       0.0000000074505805969238281250000000000000,
       0.0000000149011611938476562500000000000000,
       0.0000000298023223876953125000000000000000,
       0.0000000596046447753906250000000000000000,
       0.0000001192092895507812500000000000000000,
       0.0000002384185791015625000000000000000000,
       0.0000004768371582031250000000000000000000,
       0.0000009536743164062500000000000000000000,
       0.0000019073486328125000000000000000000000,
       0.0000038146972656250000000000000000000000,
       0.0000076293945312500000000000000000000000,
       0.0000152587890625000000000000000000000000,
       0.0000305175781250000000000000000000000000,
       0.0000610351562500000000000000000000000000,
       0.0001220703125000000000000000000000000000,
       0.0002441406250000000000000000000000000000,
       0.0004882812500000000000000000000000000000,
       0.0009765625000000000000000000000000000000,
       0.0019531250000000000000000000000000000000,
       0.0039062500000000000000000000000000000000,
       0.0078125000000000000000000000000000000000,
       0.0156250000000000000000000000000000000000,
       0.0312500000000000000000000000000000000000,
       0.0625000000000000000000000000000000000000,
       0.1250000000000000000000000000000000000000,
       0.2500000000000000000000000000000000000000,
       0.5000000000000000000000000000000000000000,
       1.0000000000000000000000000000000000000000,
       2.0000000000000000000000000000000000000000,
       4.0000000000000000000000000000000000000000,
       8.0000000000000000000000000000000000000000,
       16.0000000000000000000000000000000000000000,
       32.0000000000000000000000000000000000000000,
       64.0000000000000000000000000000000000000000,
       128.0000000000000000000000000000000000000000,
       256.0000000000000000000000000000000000000000,
       512.0000000000000000000000000000000000000000,
       1024.0000000000000000000000000000000000000000,
       2048.0000000000000000000000000000000000000000,
       4096.0000000000000000000000000000000000000000,
       8192.0000000000000000000000000000000000000000,
       16384.0000000000000000000000000000000000000000,
       32768.0000000000000000000000000000000000000000,
       65536.0000000000000000000000000000000000000000,
       131072.0000000000000000000000000000000000000000,
       262144.0000000000000000000000000000000000000000,
       524288.0000000000000000000000000000000000000000,
       1048576.0000000000000000000000000000000000000000,
       2097152.0000000000000000000000000000000000000000,
       4194304.0000000000000000000000000000000000000000,
       8388608.0000000000000000000000000000000000000000,
       16777216.0000000000000000000000000000000000000000,
       33554432.0000000000000000000000000000000000000000,
       67108864.0000000000000000000000000000000000000000,
       134217728.0000000000000000000000000000000000000000,
       268435456.0000000000000000000000000000000000000000,
       536870912.0000000000000000000000000000000000000000,
       1073741824.0000000000000000000000000000000000000000,
       2147483648.0000000000000000000000000000000000000000,
       4294967296.0000000000000000000000000000000000000000,
       8589934592.0000000000000000000000000000000000000000,
       17179869184.0000000000000000000000000000000000000000,
       34359738368.0000000000000000000000000000000000000000,
       68719476736.0000000000000000000000000000000000000000,
       137438953472.0000000000000000000000000000000000000000,
       274877906944.0000000000000000000000000000000000000000,
       549755813888.0000000000000000000000000000000000000000,
       1099511627776.0000000000000000000000000000000000000000,
       2199023255552.0000000000000000000000000000000000000000,
       4398046511104.0000000000000000000000000000000000000000,
       8796093022208.0000000000000000000000000000000000000000,
       17592186044416.0000000000000000000000000000000000000000,
       35184372088832.0000000000000000000000000000000000000000,
       70368744177664.0000000000000000000000000000000000000000,
       140737488355328.0000000000000000000000000000000000000000,
       281474976710656.0000000000000000000000000000000000000000,
       562949953421312.0000000000000000000000000000000000000000,
       1125899906842624.0000000000000000000000000000000000000000,
       2251799813685248.0000000000000000000000000000000000000000,
       4503599627370496.0000000000000000000000000000000000000000,
       9007199254740992.0000000000000000000000000000000000000000,
       18014398509481984.0000000000000000000000000000000000000000,
       36028797018963968.0000000000000000000000000000000000000000,
       72057594037927936.0000000000000000000000000000000000000000,
       144115188075855872.0000000000000000000000000000000000000000,
       288230376151711744.0000000000000000000000000000000000000000,
       576460752303423488.0000000000000000000000000000000000000000,
       1152921504606846976.0000000000000000000000000000000000000000,
       2305843009213693952.0000000000000000000000000000000000000000,
       4611686018427387904.0000000000000000000000000000000000000000,
       9223372036854775808.0000000000000000000000000000000000000000,
       18446744073709551616.0000000000000000000000000000000000000000,
       36893488147419103232.0000000000000000000000000000000000000000,
       73786976294838206464.0000000000000000000000000000000000000000,
       147573952589676412928.0000000000000000000000000000000000000000,
       295147905179352825856.0000000000000000000000000000000000000000,
       590295810358705651712.0000000000000000000000000000000000000000,
       1180591620717411303424.0000000000000000000000000000000000000000,
       2361183241434822606848.0000000000000000000000000000000000000000,
       4722366482869645213696.0000000000000000000000000000000000000000,
       9444732965739290427392.0000000000000000000000000000000000000000,
       18889465931478580854784.0000000000000000000000000000000000000000,
       37778931862957161709568.0000000000000000000000000000000000000000,
       75557863725914323419136.0000000000000000000000000000000000000000,
       151115727451828646838272.0000000000000000000000000000000000000000,
       302231454903657293676544.0000000000000000000000000000000000000000,
       604462909807314587353088.0000000000000000000000000000000000000000,
       1208925819614629174706176.0000000000000000000000000000000000000000,
       2417851639229258349412352.0000000000000000000000000000000000000000,
       4835703278458516698824704.0000000000000000000000000000000000000000,
       9671406556917033397649408.0000000000000000000000000000000000000000,
       19342813113834066795298816.0000000000000000000000000000000000000000,
       38685626227668133590597632.0000000000000000000000000000000000000000,
       77371252455336267181195264.0000000000000000000000000000000000000000,
       154742504910672534362390528.0000000000000000000000000000000000000000,
       309485009821345068724781056.0000000000000000000000000000000000000000,
       618970019642690137449562112.0000000000000000000000000000000000000000,
       1237940039285380274899124224.0000000000000000000000000000000000000000,
       2475880078570760549798248448.0000000000000000000000000000000000000000,
       4951760157141521099596496896.0000000000000000000000000000000000000000,
       9903520314283042199192993792.0000000000000000000000000000000000000000,
       19807040628566084398385987584.0000000000000000000000000000000000000000,
       39614081257132168796771975168.0000000000000000000000000000000000000000,
       79228162514264337593543950336.0000000000000000000000000000000000000000,
       158456325028528675187087900672.0000000000000000000000000000000000000000,
       316912650057057350374175801344.0000000000000000000000000000000000000000,
       633825300114114700748351602688.0000000000000000000000000000000000000000,
       1267650600228229401496703205376.0000000000000000000000000000000000000000,
       2535301200456458802993406410752.0000000000000000000000000000000000000000,
       5070602400912917605986812821504.0000000000000000000000000000000000000000,
       10141204801825835211973625643008.0000000000000000000000000000000000000000,
       20282409603651670423947251286016.0000000000000000000000000000000000000000,
       40564819207303340847894502572032.0000000000000000000000000000000000000000,
       81129638414606681695789005144064.0000000000000000000000000000000000000000,
       162259276829213363391578010288128.0000000000000000000000000000000000000000,
       324518553658426726783156020576256.0000000000000000000000000000000000000000,
       649037107316853453566312041152512.0000000000000000000000000000000000000000,
       1298074214633706907132624082305024.0000000000000000000000000000000000000000,
       2596148429267413814265248164610048.0000000000000000000000000000000000000000,
       5192296858534827628530496329220096.0000000000000000000000000000000000000000,
       10384593717069655257060992658440192.0000000000000000000000000000000000000000,
       20769187434139310514121985316880384.0000000000000000000000000000000000000000,
       41538374868278621028243970633760768.0000000000000000000000000000000000000000,
       83076749736557242056487941267521536.0000000000000000000000000000000000000000,
       166153499473114484112975882535043072.0000000000000000000000000000000000000000,
       332306998946228968225951765070086144.0000000000000000000000000000000000000000,
       664613997892457936451903530140172288.0000000000000000000000000000000000000000,
       1329227995784915872903807060280344576.0000000000000000000000000000000000000000,
       2658455991569831745807614120560689152.0000000000000000000000000000000000000000,
       5316911983139663491615228241121378304.0000000000000000000000000000000000000000,
       10633823966279326983230456482242756608.0000000000000000000000000000000000000000,
       21267647932558653966460912964485513216.0000000000000000000000000000000000000000,
       42535295865117307932921825928971026432.0000000000000000000000000000000000000000,
       85070591730234615865843651857942052864.0000000000000000000000000000000000000000,
       170141183460469231731687303715884105728.0000000000000000000000000000000000000000,
       DGen::Constants::QNaN};

constexpr uint8_t e8m0Bits[] = {
    0b00000000, 0b00000001, 0b00000010, 0b00000011, 0b00000100, 0b00000101, 0b00000110, 0b00000111,
    0b00001000, 0b00001001, 0b00001010, 0b00001011, 0b00001100, 0b00001101, 0b00001110, 0b00001111,
    0b00010000, 0b00010001, 0b00010010, 0b00010011, 0b00010100, 0b00010101, 0b00010110, 0b00010111,
    0b00011000, 0b00011001, 0b00011010, 0b00011011, 0b00011100, 0b00011101, 0b00011110, 0b00011111,
    0b00100000, 0b00100001, 0b00100010, 0b00100011, 0b00100100, 0b00100101, 0b00100110, 0b00100111,
    0b00101000, 0b00101001, 0b00101010, 0b00101011, 0b00101100, 0b00101101, 0b00101110, 0b00101111,
    0b00110000, 0b00110001, 0b00110010, 0b00110011, 0b00110100, 0b00110101, 0b00110110, 0b00110111,
    0b00111000, 0b00111001, 0b00111010, 0b00111011, 0b00111100, 0b00111101, 0b00111110, 0b00111111,
    0b01000000, 0b01000001, 0b01000010, 0b01000011, 0b01000100, 0b01000101, 0b01000110, 0b01000111,
    0b01001000, 0b01001001, 0b01001010, 0b01001011, 0b01001100, 0b01001101, 0b01001110, 0b01001111,
    0b01010000, 0b01010001, 0b01010010, 0b01010011, 0b01010100, 0b01010101, 0b01010110, 0b01010111,
    0b01011000, 0b01011001, 0b01011010, 0b01011011, 0b01011100, 0b01011101, 0b01011110, 0b01011111,
    0b01100000, 0b01100001, 0b01100010, 0b01100011, 0b01100100, 0b01100101, 0b01100110, 0b01100111,
    0b01101000, 0b01101001, 0b01101010, 0b01101011, 0b01101100, 0b01101101, 0b01101110, 0b01101111,
    0b01110000, 0b01110001, 0b01110010, 0b01110011, 0b01110100, 0b01110101, 0b01110110, 0b01110111,
    0b01111000, 0b01111001, 0b01111010, 0b01111011, 0b01111100, 0b01111101, 0b01111110, 0b01111111,
    0b10000000, 0b10000001, 0b10000010, 0b10000011, 0b10000100, 0b10000101, 0b10000110, 0b10000111,
    0b10001000, 0b10001001, 0b10001010, 0b10001011, 0b10001100, 0b10001101, 0b10001110, 0b10001111,
    0b10010000, 0b10010001, 0b10010010, 0b10010011, 0b10010100, 0b10010101, 0b10010110, 0b10010111,
    0b10011000, 0b10011001, 0b10011010, 0b10011011, 0b10011100, 0b10011101, 0b10011110, 0b10011111,
    0b10100000, 0b10100001, 0b10100010, 0b10100011, 0b10100100, 0b10100101, 0b10100110, 0b10100111,
    0b10101000, 0b10101001, 0b10101010, 0b10101011, 0b10101100, 0b10101101, 0b10101110, 0b10101111,
    0b10110000, 0b10110001, 0b10110010, 0b10110011, 0b10110100, 0b10110101, 0b10110110, 0b10110111,
    0b10111000, 0b10111001, 0b10111010, 0b10111011, 0b10111100, 0b10111101, 0b10111110, 0b10111111,
    0b11000000, 0b11000001, 0b11000010, 0b11000011, 0b11000100, 0b11000101, 0b11000110, 0b11000111,
    0b11001000, 0b11001001, 0b11001010, 0b11001011, 0b11001100, 0b11001101, 0b11001110, 0b11001111,
    0b11010000, 0b11010001, 0b11010010, 0b11010011, 0b11010100, 0b11010101, 0b11010110, 0b11010111,
    0b11011000, 0b11011001, 0b11011010, 0b11011011, 0b11011100, 0b11011101, 0b11011110, 0b11011111,
    0b11100000, 0b11100001, 0b11100010, 0b11100011, 0b11100100, 0b11100101, 0b11100110, 0b11100111,
    0b11101000, 0b11101001, 0b11101010, 0b11101011, 0b11101100, 0b11101101, 0b11101110, 0b11101111,
    0b11110000, 0b11110001, 0b11110010, 0b11110011, 0b11110100, 0b11110101, 0b11110110, 0b11110111,
    0b11111000, 0b11111001, 0b11111010, 0b11111011, 0b11111100, 0b11111101, 0b11111110, 0b11111111};
