/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.common.collect.Lists;
import com.google.jstestdriver.FileInfo;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelativePathConverter {
    private final String baseDir;
    private final List<FileInfo> files;

    public RelativePathConverter(String baseDir, List<FileInfo> files) {
        this.baseDir = baseDir;
        this.files = files;
    }

    public List<FileInfo> convert() {
        LinkedList<FileInfo> convertedPaths = Lists.newLinkedList();
        for (FileInfo f : this.files) {
            convertedPaths.add(new FileInfo(f.getFilePath().replace(this.baseDir, ""), f.getTimestamp(), -1L, f.isPatch(), f.isServeOnly(), f.getData(), f.getDisplayPath()));
        }
        return convertedPaths;
    }
}

