/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.coverage;

import com.google.inject.Inject;
import com.google.jstestdriver.Response;
import com.google.jstestdriver.ResponseStream;
import com.google.jstestdriver.ResponseStreamFactory;
import com.google.jstestdriver.TestResultGenerator;
import com.google.jstestdriver.coverage.CoverageAccumulator;
import com.google.jstestdriver.coverage.CoverageTestResponseStream;

public class CoverageResponseStreamFactory
implements ResponseStreamFactory {
    static final ResponseStream NULL_RESPONSE_STREAM = new NullResponseStream();
    private final CoverageAccumulator coverageAccumulator;
    private final TestResultGenerator testResultGenerator;

    @Inject
    public CoverageResponseStreamFactory(CoverageAccumulator coverageAccumulator, TestResultGenerator testResultGenerator) {
        this.coverageAccumulator = coverageAccumulator;
        this.testResultGenerator = testResultGenerator;
    }

    public ResponseStream getDryRunActionResponseStream() {
        return NULL_RESPONSE_STREAM;
    }

    public ResponseStream getEvalActionResponseStream() {
        return NULL_RESPONSE_STREAM;
    }

    public ResponseStream getResetActionResponseStream() {
        return NULL_RESPONSE_STREAM;
    }

    public ResponseStream getRunTestsActionResponseStream(String browserId) {
        return new CoverageTestResponseStream(browserId, this.coverageAccumulator, this.testResultGenerator);
    }

    public static class NullResponseStream
    implements ResponseStream {
        public void finish() {
        }

        public void stream(Response response) {
        }
    }
}

