/* metaChromGraph.c was originally generated by the autoSql program, which also 
 * generated metaChromGraph.h and metaChromGraph.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "metaChromGraph.h"


void metaChromGraphStaticLoad(char **row, struct metaChromGraph *ret)
/* Load a row from metaChromGraph table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->name = row[0];
ret->minVal = atof(row[1]);
ret->maxVal = atof(row[2]);
ret->binaryFile = row[3];
}

struct metaChromGraph *metaChromGraphLoad(char **row)
/* Load a metaChromGraph from row fetched with select * from metaChromGraph
 * from database.  Dispose of this with metaChromGraphFree(). */
{
struct metaChromGraph *ret;

AllocVar(ret);
ret->name = cloneString(row[0]);
ret->minVal = atof(row[1]);
ret->maxVal = atof(row[2]);
ret->binaryFile = cloneString(row[3]);
return ret;
}

struct metaChromGraph *metaChromGraphLoadAll(char *fileName) 
/* Load all metaChromGraph from a whitespace-separated file.
 * Dispose of this with metaChromGraphFreeList(). */
{
struct metaChromGraph *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileRow(lf, row))
    {
    el = metaChromGraphLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct metaChromGraph *metaChromGraphLoadAllByChar(char *fileName, char chopper) 
/* Load all metaChromGraph from a chopper separated file.
 * Dispose of this with metaChromGraphFreeList(). */
{
struct metaChromGraph *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = metaChromGraphLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct metaChromGraph *metaChromGraphCommaIn(char **pS, struct metaChromGraph *ret)
/* Create a metaChromGraph out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new metaChromGraph */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->name = sqlStringComma(&s);
ret->minVal = sqlDoubleComma(&s);
ret->maxVal = sqlDoubleComma(&s);
ret->binaryFile = sqlStringComma(&s);
*pS = s;
return ret;
}

void metaChromGraphFree(struct metaChromGraph **pEl)
/* Free a single dynamically allocated metaChromGraph such as created
 * with metaChromGraphLoad(). */
{
struct metaChromGraph *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freeMem(el->binaryFile);
freez(pEl);
}

void metaChromGraphFreeList(struct metaChromGraph **pList)
/* Free a list of dynamically allocated metaChromGraph's */
{
struct metaChromGraph *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    metaChromGraphFree(&el);
    }
*pList = NULL;
}

void metaChromGraphOutput(struct metaChromGraph *el, FILE *f, char sep, char lastSep) 
/* Print out metaChromGraph.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%g", el->minVal);
fputc(sep,f);
fprintf(f, "%g", el->maxVal);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->binaryFile);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

