/* splignAlign.c was originally generated by the autoSql program, which also 
 * generated splignAlign.h and splignAlign.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "splignAlign.h"


void splignAlignStaticLoad(char **row, struct splignAlign *ret)
/* Load a row from splignAlign table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->query = row[0];
ret->target = row[1];
ret->perId = atof(row[2]);
ret->match = sqlSigned(row[3]);
ret->qStart = sqlSigned(row[4]);
ret->qEnd = sqlSigned(row[5]);
ret->tStart = sqlSigned(row[6]);
ret->tEnd = sqlSigned(row[7]);
ret->type = row[8];
ret->anotation = row[9];
}

struct splignAlign *splignAlignLoad(char **row)
/* Load a splignAlign from row fetched with select * from splignAlign
 * from database.  Dispose of this with splignAlignFree(). */
{
struct splignAlign *ret;

AllocVar(ret);
ret->query = cloneString(row[0]);
ret->target = cloneString(row[1]);
ret->perId = atof(row[2]);
ret->match = sqlSigned(row[3]);
ret->qStart = sqlSigned(row[4]);
ret->qEnd = sqlSigned(row[5]);
ret->tStart = sqlSigned(row[6]);
ret->tEnd = sqlSigned(row[7]);
ret->type = cloneString(row[8]);
ret->anotation = cloneString(row[9]);
return ret;
}

struct splignAlign *splignAlignLoadAll(char *fileName) 
/* Load all splignAlign from a whitespace-separated file.
 * Dispose of this with splignAlignFreeList(). */
{
struct splignAlign *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[10];

while (lineFileRow(lf, row))
    {
    el = splignAlignLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct splignAlign *splignAlignLoadAllByChar(char *fileName, char chopper) 
/* Load all splignAlign from a chopper separated file.
 * Dispose of this with splignAlignFreeList(). */
{
struct splignAlign *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[10];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = splignAlignLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct splignAlign *splignAlignCommaIn(char **pS, struct splignAlign *ret)
/* Create a splignAlign out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new splignAlign */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->query = sqlStringComma(&s);
ret->target = sqlStringComma(&s);
ret->perId = sqlFloatComma(&s);
ret->match = sqlSignedComma(&s);
ret->qStart = sqlSignedComma(&s);
ret->qEnd = sqlSignedComma(&s);
ret->tStart = sqlSignedComma(&s);
ret->tEnd = sqlSignedComma(&s);
ret->type = sqlStringComma(&s);
ret->anotation = sqlStringComma(&s);
*pS = s;
return ret;
}

void splignAlignFree(struct splignAlign **pEl)
/* Free a single dynamically allocated splignAlign such as created
 * with splignAlignLoad(). */
{
struct splignAlign *el;

if ((el = *pEl) == NULL) return;
freeMem(el->query);
freeMem(el->target);
freeMem(el->type);
freeMem(el->anotation);
freez(pEl);
}

void splignAlignFreeList(struct splignAlign **pList)
/* Free a list of dynamically allocated splignAlign's */
{
struct splignAlign *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    splignAlignFree(&el);
    }
*pList = NULL;
}

void splignAlignOutput(struct splignAlign *el, FILE *f, char sep, char lastSep) 
/* Print out splignAlign.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->query);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->target);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%f", el->perId);
fputc(sep,f);
fprintf(f, "%d", el->match);
fputc(sep,f);
fprintf(f, "%d", el->qStart);
fputc(sep,f);
fprintf(f, "%d", el->qEnd);
fputc(sep,f);
fprintf(f, "%d", el->tStart);
fputc(sep,f);
fprintf(f, "%d", el->tEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->type);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->anotation);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

