#include "regs.h"

//-----------------------------------------------------------------------------
// registers (and related) to string
//-----------------------------------------------------------------------------

static const char* RegisterString[] = {"NONE", "w0", "w1", "w2", "w3", "w4", "w5", "w6", "w7", "w8",
    "w9", "w10", "w11", "w12", "w13", "w14", "w15", "w16", "w17", "w18", "w19", "w20", "w21", "w22",
    "w23", "w24", "w25", "w26", "w27", "w28", "w29", "w30", "wzr", "wsp", "x0", "x1", "x2", "x3",
    "x4", "x5", "x6", "x7", "x8", "x9", "x10", "x11", "x12", "x13", "x14", "x15", "x16", "x17",
    "x18", "x19", "x20", "x21", "x22", "x23", "x24", "x25", "x26", "x27", "x28", "x29", "x30",
    "xzr", "sp", "v0", "v1", "v2", "v3", "v4", "v5", "v6", "v7", "v8", "v9", "v10", "v11", "v12",
    "v13", "v14", "v15", "v16", "v17", "v18", "v19", "v20", "v21", "v22", "v23", "v24", "v25",
    "v26", "v27", "v28", "v29", "v30", "v31", "b0", "b1", "b2", "b3", "b4", "b5", "b6", "b7",
    "b8", "b9", "b10", "b11", "b12", "b13", "b14", "b15", "b16", "b17", "b18", "b19", "b20", "b21",
    "b22", "b23", "b24", "b25", "b26", "b27", "b28", "b29", "b30", "b31", "h0", "h1", "h2",
    "h3", "h4", "h5", "h6", "h7", "h8", "h9", "h10", "h11", "h12", "h13", "h14", "h15", "h16",
    "h17", "h18", "h19", "h20", "h21", "h22", "h23", "h24", "h25", "h26", "h27", "h28", "h29",
    "h30", "h31", "s0", "s1", "s2", "s3", "s4", "s5", "s6", "s7", "s8", "s9", "s10", "s11",
    "s12", "s13", "s14", "s15", "s16", "s17", "s18", "s19", "s20", "s21", "s22", "s23", "s24",
    "s25", "s26", "s27", "s28", "s29", "s30", "s31", "d0", "d1", "d2", "d3", "d4", "d5",
    "d6", "d7", "d8", "d9", "d10", "d11", "d12", "d13", "d14", "d15", "d16", "d17", "d18", "d19",
    "d20", "d21", "d22", "d23", "d24", "d25", "d26", "d27", "d28", "d29", "d30", "d31", "q0",
    "q1", "q2", "q3", "q4", "q5", "q6", "q7", "q8", "q9", "q10", "q11", "q12", "q13", "q14", "q15",
    "q16", "q17", "q18", "q19", "q20", "q21", "q22", "q23", "q24", "q25", "q26", "q27", "q28",
    "q29", "q30", "q31",
    // B vectors
    "v0.b[0]", "v0.b[1]", "v0.b[2]", "v0.b[3]", "v0.b[4]", "v0.b[5]", "v0.b[6]", "v0.b[7]",
    "v0.b[8]", "v0.b[9]", "v0.b[10]", "v0.b[11]", "v0.b[12]", "v0.b[13]", "v0.b[14]", "v0.b[15]",
    "v1.b[0]", "v1.b[1]", "v1.b[2]", "v1.b[3]", "v1.b[4]", "v1.b[5]", "v1.b[6]", "v1.b[7]",
    "v1.b[8]", "v1.b[9]", "v1.b[10]", "v1.b[11]", "v1.b[12]", "v1.b[13]", "v1.b[14]", "v1.b[15]",
    "v2.b[0]", "v2.b[1]", "v2.b[2]", "v2.b[3]", "v2.b[4]", "v2.b[5]", "v2.b[6]", "v2.b[7]",
    "v2.b[8]", "v2.b[9]", "v2.b[10]", "v2.b[11]", "v2.b[12]", "v2.b[13]", "v2.b[14]", "v2.b[15]",
    "v3.b[0]", "v3.b[1]", "v3.b[2]", "v3.b[3]", "v3.b[4]", "v3.b[5]", "v3.b[6]", "v3.b[7]",
    "v3.b[8]", "v3.b[9]", "v3.b[10]", "v3.b[11]", "v3.b[12]", "v3.b[13]", "v3.b[14]", "v3.b[15]",
    "v4.b[0]", "v4.b[1]", "v4.b[2]", "v4.b[3]", "v4.b[4]", "v4.b[5]", "v4.b[6]", "v4.b[7]",
    "v4.b[8]", "v4.b[9]", "v4.b[10]", "v4.b[11]", "v4.b[12]", "v4.b[13]", "v4.b[14]", "v4.b[15]",
    "v5.b[0]", "v5.b[1]", "v5.b[2]", "v5.b[3]", "v5.b[4]", "v5.b[5]", "v5.b[6]", "v5.b[7]",
    "v5.b[8]", "v5.b[9]", "v5.b[10]", "v5.b[11]", "v5.b[12]", "v5.b[13]", "v5.b[14]", "v5.b[15]",
    "v6.b[0]", "v6.b[1]", "v6.b[2]", "v6.b[3]", "v6.b[4]", "v6.b[5]", "v6.b[6]", "v6.b[7]",
    "v6.b[8]", "v6.b[9]", "v6.b[10]", "v6.b[11]", "v6.b[12]", "v6.b[13]", "v6.b[14]", "v6.b[15]",
    "v7.b[0]", "v7.b[1]", "v7.b[2]", "v7.b[3]", "v7.b[4]", "v7.b[5]", "v7.b[6]", "v7.b[7]",
    "v7.b[8]", "v7.b[9]", "v7.b[10]", "v7.b[11]", "v7.b[12]", "v7.b[13]", "v7.b[14]", "v7.b[15]",
    "v8.b[0]", "v8.b[1]", "v8.b[2]", "v8.b[3]", "v8.b[4]", "v8.b[5]", "v8.b[6]", "v8.b[7]",
    "v8.b[8]", "v8.b[9]", "v8.b[10]", "v8.b[11]", "v8.b[12]", "v8.b[13]", "v8.b[14]", "v8.b[15]",
    "v9.b[0]", "v9.b[1]", "v9.b[2]", "v9.b[3]", "v9.b[4]", "v9.b[5]", "v9.b[6]", "v9.b[7]",
    "v9.b[8]", "v9.b[9]", "v9.b[10]", "v9.b[11]", "v9.b[12]", "v9.b[13]", "v9.b[14]", "v9.b[15]",
    "v10.b[0]", "v10.b[1]", "v10.b[2]", "v10.b[3]", "v10.b[4]", "v10.b[5]", "v10.b[6]", "v10.b[7]",
    "v10.b[8]", "v10.b[9]", "v10.b[10]", "v10.b[11]", "v10.b[12]", "v10.b[13]", "v10.b[14]",
    "v10.b[15]", "v11.b[0]", "v11.b[1]", "v11.b[2]", "v11.b[3]", "v11.b[4]", "v11.b[5]", "v11.b[6]",
    "v11.b[7]", "v11.b[8]", "v11.b[9]", "v11.b[10]", "v11.b[11]", "v11.b[12]", "v11.b[13]",
    "v11.b[14]", "v11.b[15]", "v12.b[0]", "v12.b[1]", "v12.b[2]", "v12.b[3]", "v12.b[4]",
    "v12.b[5]", "v12.b[6]", "v12.b[7]", "v12.b[8]", "v12.b[9]", "v12.b[10]", "v12.b[11]",
    "v12.b[12]", "v12.b[13]", "v12.b[14]", "v12.b[15]", "v13.b[0]", "v13.b[1]", "v13.b[2]",
    "v13.b[3]", "v13.b[4]", "v13.b[5]", "v13.b[6]", "v13.b[7]", "v13.b[8]", "v13.b[9]", "v13.b[10]",
    "v13.b[11]", "v13.b[12]", "v13.b[13]", "v13.b[14]", "v13.b[15]", "v14.b[0]", "v14.b[1]",
    "v14.b[2]", "v14.b[3]", "v14.b[4]", "v14.b[5]", "v14.b[6]", "v14.b[7]", "v14.b[8]", "v14.b[9]",
    "v14.b[10]", "v14.b[11]", "v14.b[12]", "v14.b[13]", "v14.b[14]", "v14.b[15]", "v15.b[0]",
    "v15.b[1]", "v15.b[2]", "v15.b[3]", "v15.b[4]", "v15.b[5]", "v15.b[6]", "v15.b[7]", "v15.b[8]",
    "v15.b[9]", "v15.b[10]", "v15.b[11]", "v15.b[12]", "v15.b[13]", "v15.b[14]", "v15.b[15]",
    "v16.b[0]", "v16.b[1]", "v16.b[2]", "v16.b[3]", "v16.b[4]", "v16.b[5]", "v16.b[6]", "v16.b[7]",
    "v16.b[8]", "v16.b[9]", "v16.b[10]", "v16.b[11]", "v16.b[12]", "v16.b[13]", "v16.b[14]",
    "v16.b[15]", "v17.b[0]", "v17.b[1]", "v17.b[2]", "v17.b[3]", "v17.b[4]", "v17.b[5]", "v17.b[6]",
    "v17.b[7]", "v17.b[8]", "v17.b[9]", "v17.b[10]", "v17.b[11]", "v17.b[12]", "v17.b[13]",
    "v17.b[14]", "v17.b[15]", "v18.b[0]", "v18.b[1]", "v18.b[2]", "v18.b[3]", "v18.b[4]",
    "v18.b[5]", "v18.b[6]", "v18.b[7]", "v18.b[8]", "v18.b[9]", "v18.b[10]", "v18.b[11]",
    "v18.b[12]", "v18.b[13]", "v18.b[14]", "v18.b[15]", "v19.b[0]", "v19.b[1]", "v19.b[2]",
    "v19.b[3]", "v19.b[4]", "v19.b[5]", "v19.b[6]", "v19.b[7]", "v19.b[8]", "v19.b[9]", "v19.b[10]",
    "v19.b[11]", "v19.b[12]", "v19.b[13]", "v19.b[14]", "v19.b[15]", "v20.b[0]", "v20.b[1]",
    "v20.b[2]", "v20.b[3]", "v20.b[4]", "v20.b[5]", "v20.b[6]", "v20.b[7]", "v20.b[8]", "v20.b[9]",
    "v20.b[10]", "v20.b[11]", "v20.b[12]", "v20.b[13]", "v20.b[14]", "v20.b[15]", "v21.b[0]",
    "v21.b[1]", "v21.b[2]", "v21.b[3]", "v21.b[4]", "v21.b[5]", "v21.b[6]", "v21.b[7]", "v21.b[8]",
    "v21.b[9]", "v21.b[10]", "v21.b[11]", "v21.b[12]", "v21.b[13]", "v21.b[14]", "v21.b[15]",
    "v22.b[0]", "v22.b[1]", "v22.b[2]", "v22.b[3]", "v22.b[4]", "v22.b[5]", "v22.b[6]", "v22.b[7]",
    "v22.b[8]", "v22.b[9]", "v22.b[10]", "v22.b[11]", "v22.b[12]", "v22.b[13]", "v22.b[14]",
    "v22.b[15]", "v23.b[0]", "v23.b[1]", "v23.b[2]", "v23.b[3]", "v23.b[4]", "v23.b[5]", "v23.b[6]",
    "v23.b[7]", "v23.b[8]", "v23.b[9]", "v23.b[10]", "v23.b[11]", "v23.b[12]", "v23.b[13]",
    "v23.b[14]", "v23.b[15]", "v24.b[0]", "v24.b[1]", "v24.b[2]", "v24.b[3]", "v24.b[4]",
    "v24.b[5]", "v24.b[6]", "v24.b[7]", "v24.b[8]", "v24.b[9]", "v24.b[10]", "v24.b[11]",
    "v24.b[12]", "v24.b[13]", "v24.b[14]", "v24.b[15]", "v25.b[0]", "v25.b[1]", "v25.b[2]",
    "v25.b[3]", "v25.b[4]", "v25.b[5]", "v25.b[6]", "v25.b[7]", "v25.b[8]", "v25.b[9]", "v25.b[10]",
    "v25.b[11]", "v25.b[12]", "v25.b[13]", "v25.b[14]", "v25.b[15]", "v26.b[0]", "v26.b[1]",
    "v26.b[2]", "v26.b[3]", "v26.b[4]", "v26.b[5]", "v26.b[6]", "v26.b[7]", "v26.b[8]", "v26.b[9]",
    "v26.b[10]", "v26.b[11]", "v26.b[12]", "v26.b[13]", "v26.b[14]", "v26.b[15]", "v27.b[0]",
    "v27.b[1]", "v27.b[2]", "v27.b[3]", "v27.b[4]", "v27.b[5]", "v27.b[6]", "v27.b[7]", "v27.b[8]",
    "v27.b[9]", "v27.b[10]", "v27.b[11]", "v27.b[12]", "v27.b[13]", "v27.b[14]", "v27.b[15]",
    "v28.b[0]", "v28.b[1]", "v28.b[2]", "v28.b[3]", "v28.b[4]", "v28.b[5]", "v28.b[6]", "v28.b[7]",
    "v28.b[8]", "v28.b[9]", "v28.b[10]", "v28.b[11]", "v28.b[12]", "v28.b[13]", "v28.b[14]",
    "v28.b[15]", "v29.b[0]", "v29.b[1]", "v29.b[2]", "v29.b[3]", "v29.b[4]", "v29.b[5]", "v29.b[6]",
    "v29.b[7]", "v29.b[8]", "v29.b[9]", "v29.b[10]", "v29.b[11]", "v29.b[12]", "v29.b[13]",
    "v29.b[14]", "v29.b[15]", "v30.b[0]", "v30.b[1]", "v30.b[2]", "v30.b[3]", "v30.b[4]",
    "v30.b[5]", "v30.b[6]", "v30.b[7]", "v30.b[8]", "v30.b[9]", "v30.b[10]", "v30.b[11]",
    "v30.b[12]", "v30.b[13]", "v30.b[14]", "v30.b[15]", "v31.b[0]", "v31.b[1]", "v31.b[2]",
    "v31.b[3]", "v31.b[4]", "v31.b[5]", "v31.b[6]", "v31.b[7]", "v31.b[8]", "v31.b[9]", "v31.b[10]",
    "v31.b[11]", "v31.b[12]", "v31.b[13]", "v31.b[14]", "v31.b[15]",
    // H vectors
    "v0.h[0]", "v0.h[1]", "v0.h[2]", "v0.h[3]", "v0.h[4]", "v0.h[5]", "v0.h[6]", "v0.h[7]",
    "v1.h[0]", "v1.h[1]", "v1.h[2]", "v1.h[3]", "v1.h[4]", "v1.h[5]", "v1.h[6]", "v1.h[7]",
    "v2.h[0]", "v2.h[1]", "v2.h[2]", "v2.h[3]", "v2.h[4]", "v2.h[5]", "v2.h[6]", "v2.h[7]",
    "v3.h[0]", "v3.h[1]", "v3.h[2]", "v3.h[3]", "v3.h[4]", "v3.h[5]", "v3.h[6]", "v3.h[7]",
    "v4.h[0]", "v4.h[1]", "v4.h[2]", "v4.h[3]", "v4.h[4]", "v4.h[5]", "v4.h[6]", "v4.h[7]",
    "v5.h[0]", "v5.h[1]", "v5.h[2]", "v5.h[3]", "v5.h[4]", "v5.h[5]", "v5.h[6]", "v5.h[7]",
    "v6.h[0]", "v6.h[1]", "v6.h[2]", "v6.h[3]", "v6.h[4]", "v6.h[5]", "v6.h[6]", "v6.h[7]",
    "v7.h[0]", "v7.h[1]", "v7.h[2]", "v7.h[3]", "v7.h[4]", "v7.h[5]", "v7.h[6]", "v7.h[7]",
    "v8.h[0]", "v8.h[1]", "v8.h[2]", "v8.h[3]", "v8.h[4]", "v8.h[5]", "v8.h[6]", "v8.h[7]",
    "v9.h[0]", "v9.h[1]", "v9.h[2]", "v9.h[3]", "v9.h[4]", "v9.h[5]", "v9.h[6]", "v9.h[7]",
    "v10.h[0]", "v10.h[1]", "v10.h[2]", "v10.h[3]", "v10.h[4]", "v10.h[5]", "v10.h[6]", "v10.h[7]",
    "v11.h[0]", "v11.h[1]", "v11.h[2]", "v11.h[3]", "v11.h[4]", "v11.h[5]", "v11.h[6]", "v11.h[7]",
    "v12.h[0]", "v12.h[1]", "v12.h[2]", "v12.h[3]", "v12.h[4]", "v12.h[5]", "v12.h[6]", "v12.h[7]",
    "v13.h[0]", "v13.h[1]", "v13.h[2]", "v13.h[3]", "v13.h[4]", "v13.h[5]", "v13.h[6]", "v13.h[7]",
    "v14.h[0]", "v14.h[1]", "v14.h[2]", "v14.h[3]", "v14.h[4]", "v14.h[5]", "v14.h[6]", "v14.h[7]",
    "v15.h[0]", "v15.h[1]", "v15.h[2]", "v15.h[3]", "v15.h[4]", "v15.h[5]", "v15.h[6]", "v15.h[7]",
    "v16.h[0]", "v16.h[1]", "v16.h[2]", "v16.h[3]", "v16.h[4]", "v16.h[5]", "v16.h[6]", "v16.h[7]",
    "v17.h[0]", "v17.h[1]", "v17.h[2]", "v17.h[3]", "v17.h[4]", "v17.h[5]", "v17.h[6]", "v17.h[7]",
    "v18.h[0]", "v18.h[1]", "v18.h[2]", "v18.h[3]", "v18.h[4]", "v18.h[5]", "v18.h[6]", "v18.h[7]",
    "v19.h[0]", "v19.h[1]", "v19.h[2]", "v19.h[3]", "v19.h[4]", "v19.h[5]", "v19.h[6]", "v19.h[7]",
    "v20.h[0]", "v20.h[1]", "v20.h[2]", "v20.h[3]", "v20.h[4]", "v20.h[5]", "v20.h[6]", "v20.h[7]",
    "v21.h[0]", "v21.h[1]", "v21.h[2]", "v21.h[3]", "v21.h[4]", "v21.h[5]", "v21.h[6]", "v21.h[7]",
    "v22.h[0]", "v22.h[1]", "v22.h[2]", "v22.h[3]", "v22.h[4]", "v22.h[5]", "v22.h[6]", "v22.h[7]",
    "v23.h[0]", "v23.h[1]", "v23.h[2]", "v23.h[3]", "v23.h[4]", "v23.h[5]", "v23.h[6]", "v23.h[7]",
    "v24.h[0]", "v24.h[1]", "v24.h[2]", "v24.h[3]", "v24.h[4]", "v24.h[5]", "v24.h[6]", "v24.h[7]",
    "v25.h[0]", "v25.h[1]", "v25.h[2]", "v25.h[3]", "v25.h[4]", "v25.h[5]", "v25.h[6]", "v25.h[7]",
    "v26.h[0]", "v26.h[1]", "v26.h[2]", "v26.h[3]", "v26.h[4]", "v26.h[5]", "v26.h[6]", "v26.h[7]",
    "v27.h[0]", "v27.h[1]", "v27.h[2]", "v27.h[3]", "v27.h[4]", "v27.h[5]", "v27.h[6]", "v27.h[7]",
    "v28.h[0]", "v28.h[1]", "v28.h[2]", "v28.h[3]", "v28.h[4]", "v28.h[5]", "v28.h[6]", "v28.h[7]",
    "v29.h[0]", "v29.h[1]", "v29.h[2]", "v29.h[3]", "v29.h[4]", "v29.h[5]", "v29.h[6]", "v29.h[7]",
    "v30.h[0]", "v30.h[1]", "v30.h[2]", "v30.h[3]", "v30.h[4]", "v30.h[5]", "v30.h[6]", "v30.h[7]",
    "v31.h[0]", "v31.h[1]", "v31.h[2]", "v31.h[3]", "v31.h[4]", "v31.h[5]", "v31.h[6]", "v31.h[7]",
    // S vectors
    "v0.s[0]", "v0.s[1]", "v0.s[2]", "v0.s[3]", "v1.s[0]", "v1.s[1]", "v1.s[2]", "v1.s[3]",
    "v2.s[0]", "v2.s[1]", "v2.s[2]", "v2.s[3]", "v3.s[0]", "v3.s[1]", "v3.s[2]", "v3.s[3]",
    "v4.s[0]", "v4.s[1]", "v4.s[2]", "v4.s[3]", "v5.s[0]", "v5.s[1]", "v5.s[2]", "v5.s[3]",
    "v6.s[0]", "v6.s[1]", "v6.s[2]", "v6.s[3]", "v7.s[0]", "v7.s[1]", "v7.s[2]", "v7.s[3]",
    "v8.s[0]", "v8.s[1]", "v8.s[2]", "v8.s[3]", "v9.s[0]", "v9.s[1]", "v9.s[2]", "v9.s[3]",
    "v10.s[0]", "v10.s[1]", "v10.s[2]", "v10.s[3]", "v11.s[0]", "v11.s[1]", "v11.s[2]", "v11.s[3]",
    "v12.s[0]", "v12.s[1]", "v12.s[2]", "v12.s[3]", "v13.s[0]", "v13.s[1]", "v13.s[2]", "v13.s[3]",
    "v14.s[0]", "v14.s[1]", "v14.s[2]", "v14.s[3]", "v15.s[0]", "v15.s[1]", "v15.s[2]", "v15.s[3]",
    "v16.s[0]", "v16.s[1]", "v16.s[2]", "v16.s[3]", "v17.s[0]", "v17.s[1]", "v17.s[2]", "v17.s[3]",
    "v18.s[0]", "v18.s[1]", "v18.s[2]", "v18.s[3]", "v19.s[0]", "v19.s[1]", "v19.s[2]", "v19.s[3]",
    "v20.s[0]", "v20.s[1]", "v20.s[2]", "v20.s[3]", "v21.s[0]", "v21.s[1]", "v21.s[2]", "v21.s[3]",
    "v22.s[0]", "v22.s[1]", "v22.s[2]", "v22.s[3]", "v23.s[0]", "v23.s[1]", "v23.s[2]", "v23.s[3]",
    "v24.s[0]", "v24.s[1]", "v24.s[2]", "v24.s[3]", "v25.s[0]", "v25.s[1]", "v25.s[2]", "v25.s[3]",
    "v26.s[0]", "v26.s[1]", "v26.s[2]", "v26.s[3]", "v27.s[0]", "v27.s[1]", "v27.s[2]", "v27.s[3]",
    "v28.s[0]", "v28.s[1]", "v28.s[2]", "v28.s[3]", "v29.s[0]", "v29.s[1]", "v29.s[2]", "v29.s[3]",
    "v30.s[0]", "v30.s[1]", "v30.s[2]", "v30.s[3]", "v31.s[0]", "v31.s[1]", "v31.s[2]", "v31.s[3]",
    // D vectors
    "v0.d[0]", "v0.d[1]", "v1.d[0]", "v1.d[1]", "v2.d[0]", "v2.d[1]", "v3.d[0]", "v3.d[1]",
    "v4.d[0]", "v4.d[1]", "v5.d[0]", "v5.d[1]", "v6.d[0]", "v6.d[1]", "v7.d[0]", "v7.d[1]",
    "v8.d[0]", "v8.d[1]", "v9.d[0]", "v9.d[1]", "v10.d[0]", "v10.d[1]", "v11.d[0]", "v11.d[1]",
    "v12.d[0]", "v12.d[1]", "v13.d[0]", "v13.d[1]", "v14.d[0]", "v14.d[1]", "v15.d[0]", "v15.d[1]",
    "v16.d[0]", "v16.d[1]", "v17.d[0]", "v17.d[1]", "v18.d[0]", "v18.d[1]", "v19.d[0]", "v19.d[1]",
    "v20.d[0]", "v20.d[1]", "v21.d[0]", "v21.d[1]", "v22.d[0]", "v22.d[1]", "v23.d[0]", "v23.d[1]",
    "v24.d[0]", "v24.d[1]", "v25.d[0]", "v25.d[1]", "v26.d[0]", "v26.d[1]", "v27.d[0]", "v27.d[1]",
    "v28.d[0]", "v28.d[1]", "v29.d[0]", "v29.d[1]", "v30.d[0]", "v30.d[1]", "v31.d[0]", "v31.d[1]",
    // SVE
    "z0", "z1", "z2", "z3", "z4", "z5", "z6", "z7", "z8", "z9", "z10", "z11", "z12", "z13", "z14",
    "z15", "z16", "z17", "z18", "z19", "z20", "z21", "z22", "z23", "z24", "z25", "z26", "z27",
    "z28", "z29", "z30", "z31",
    /* scalable predicate registers */
    "p0", "p1", "p2", "p3", "p4", "p5", "p6", "p7", "p8", "p9", "p10", "p11", "p12", "p13", "p14",
    "p15", "p16", "p17", "p18", "p19", "p20", "p21", "p22", "p23", "p24", "p25", "p26", "p27",
    "p28", "p29", "p30", "p31",
    /* prefetch operations (TODO: remove these as registers) */
    "pldl1keep", "pldl1strm", "pldl2keep", "pldl2strm", "pldl3keep", "pldl3strm", "#0x6", "#0x7",
    "plil1keep", "plil1strm", "plil2keep", "plil2strm", "plil3keep", "plil3strm", "#0xe", "#0xf",
    "pstl1keep", "pstl1strm", "pstl2keep", "pstl2strm", "pstl3keep", "pstl3strm", "#0x16", "#0x17",
    "#0x18", "#0x19", "#0x1a", "#0x1b", "#0x1c", "#0x1d", "#0x1e", "#0x1f", "END"};

const char* get_register_name(enum Register r)
{
	if (r > REG_NONE && r < REG_END)
		return RegisterString[r];

	return "";
}

size_t get_register_size(enum Register r)
{
	// Comparison done in order of likelyhood to occur
	if ((r >= REG_X0 && r <= REG_SP) || (r >= REG_D0 && r <= REG_D31))
		return 8;
	else if ((r >= REG_W0 && r <= REG_WSP) || (r >= REG_S0 && r <= REG_S31))
		return 4;
	else if (r >= REG_B0 && r <= REG_B31)
		return 1;
	else if (r >= REG_H0 && r <= REG_H31)
		return 2;
	else if ((r >= REG_Q0 && r <= REG_Q31) || (r >= REG_V0 && r <= REG_V31))
		return 16;
	else if (r >= REG_V0_B0 && r <= REG_V31_B15)
		return 1;
	else if (r >= REG_V0_H0 && r <= REG_V31_H7)
		return 2;
	else if (r >= REG_V0_S0 && r <= REG_V31_S3)
		return 4;
	else if (r >= REG_V0_D0 && r <= REG_V31_D1)
		return 8;
	return 0;
}
