/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.browser.config.classpath;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gjt.jclasslib.browser.BrowserMDIFrame;
import org.gjt.jclasslib.browser.config.BrowserConfig;
import org.gjt.jclasslib.browser.config.classpath.ClasspathArchiveEntry;
import org.gjt.jclasslib.browser.config.classpath.ClasspathCellRenderer;
import org.gjt.jclasslib.browser.config.classpath.ClasspathDirectoryEntry;
import org.gjt.jclasslib.browser.config.classpath.ClasspathEntry;
import org.gjt.jclasslib.mdi.BasicFileFilter;
import org.gjt.jclasslib.util.GUIHelper;

public class ClasspathSetupDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    private static final int DIALOG_WIDTH = 500;
    private static final int DIALOG_HEIGHT = 300;
    private static final Dimension IMAGE_BUTTON_SIZE = new Dimension(28, 28);
    private static final Icon ICON_ADD = BrowserMDIFrame.loadIcon("add.png");
    private static final Icon ICON_REMOVE = BrowserMDIFrame.loadIcon("remove.png");
    private static final Icon ICON_UP = BrowserMDIFrame.loadIcon("up.png");
    private static final Icon ICON_DOWN = BrowserMDIFrame.loadIcon("down.png");
    private BrowserMDIFrame frame;
    private DefaultListModel listModel;
    private JList lstElements;
    private JScrollPane scpLstElements;
    private JButton btnAdd;
    private JButton btnRemove;
    private JButton btnUp;
    private JButton btnDown;
    private JButton btnOk;
    private JButton btnCancel;
    private JFileChooser fileChooser;

    public ClasspathSetupDialog(BrowserMDIFrame browserMDIFrame) {
        super(browserMDIFrame);
        this.frame = browserMDIFrame;
        this.setupControls();
        this.setupAccelerators();
        this.setupComponent();
        this.setupEventHandlers();
        this.checkEnabledStatus();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.checkEnabledStatus();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.btnAdd) {
            this.doAdd();
        } else if (object == this.btnRemove) {
            this.doRemove();
        } else if (object == this.btnUp) {
            this.doUp();
        } else if (object == this.btnDown) {
            this.doDown();
        } else if (object == this.btnCancel) {
            this.doCancel();
        } else if (object == this.btnOk) {
            this.doOk();
        }
        this.checkEnabledStatus();
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.updateList();
        }
        super.setVisible(bl);
    }

    private void updateList() {
        this.listModel.clear();
        Iterator iterator = this.frame.getConfig().getClasspath().iterator();
        while (iterator.hasNext()) {
            this.listModel.addElement(iterator.next());
        }
    }

    private void setupControls() {
        this.listModel = new DefaultListModel();
        this.lstElements = new JList(this.listModel);
        this.lstElements.setSelectionMode(0);
        this.lstElements.setCellRenderer(new ClasspathCellRenderer());
        this.scpLstElements = new JScrollPane(this.lstElements);
        this.scpLstElements.setBorder(BorderFactory.createEtchedBorder());
        this.btnAdd = new JButton(ICON_ADD);
        this.btnAdd.setToolTipText("Add a classpath entry (INS)");
        this.makeImageButton(this.btnAdd);
        this.btnRemove = new JButton(ICON_REMOVE);
        this.btnRemove.setToolTipText("Remove a classpath entry (DEL)");
        this.makeImageButton(this.btnRemove);
        this.btnUp = new JButton(ICON_UP);
        this.btnUp.setToolTipText("Move a classpath entry up (ALT-UP)");
        this.makeImageButton(this.btnUp);
        this.btnDown = new JButton(ICON_DOWN);
        this.btnDown.setToolTipText("Move a classpath entry down (ALT-DOWN)");
        this.makeImageButton(this.btnDown);
        this.btnOk = new JButton("Ok");
        this.btnCancel = new JButton("Cancel");
        this.btnOk.setPreferredSize(this.btnCancel.getPreferredSize());
    }

    private void setupComponent() {
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        container.add((Component)new JLabel("Classpath:"), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.fill = 1;
        container.add((Component)this.createListPanel(), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.top = 3;
        gridBagConstraints.insets.bottom = 5;
        container.add((Component)this.createButtonBox(), gridBagConstraints);
        this.getRootPane().setDefaultButton(this.btnOk);
        this.setSize(500, 300);
        this.setModal(true);
        this.setTitle("Setup classpath");
        GUIHelper.centerOnParentWindow(this, this.getOwner());
        this.setDefaultCloseOperation(0);
    }

    private void setupEventHandlers() {
        this.btnCancel.addActionListener(this);
        this.btnOk.addActionListener(this);
        this.btnAdd.addActionListener(this);
        this.btnRemove.addActionListener(this);
        this.btnUp.addActionListener(this);
        this.btnDown.addActionListener(this);
        this.lstElements.addListSelectionListener(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ClasspathSetupDialog.this.doCancel();
            }
        });
    }

    private void setupAccelerators() {
        this.addAccelerator((JComponent)this.getContentPane(), 27, 0, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClasspathSetupDialog.this.doCancel();
            }
        });
        this.addAccelerator(this.lstElements, 155, 0, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClasspathSetupDialog.this.doAdd();
            }
        });
        this.addAccelerator(this.lstElements, 127, 0, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClasspathSetupDialog.this.doRemove();
            }
        });
        this.addAccelerator(this.lstElements, 38, 8, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClasspathSetupDialog.this.doUp();
            }
        });
        this.addAccelerator(this.lstElements, 40, 8, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClasspathSetupDialog.this.doDown();
            }
        });
    }

    private void addAccelerator(JComponent jComponent, int n, int n2, AbstractAction abstractAction) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(n, n2);
        Object object = new Object();
        jComponent.getInputMap(1).put(keyStroke, object);
        jComponent.getActionMap().put(object, abstractAction);
    }

    private JPanel createListPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.scpLstElements, "Center");
        jPanel.add((Component)this.createModificationButtonBox(), "East");
        return jPanel;
    }

    private Box createModificationButtonBox() {
        Box box = Box.createVerticalBox();
        box.add(this.btnAdd);
        box.add(this.btnRemove);
        box.add(Box.createVerticalGlue());
        box.add(this.btnUp);
        box.add(this.btnDown);
        return box;
    }

    private Box createButtonBox() {
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(this.btnOk);
        box.add(this.btnCancel);
        return box;
    }

    private void makeImageButton(AbstractButton abstractButton) {
        abstractButton.setMinimumSize(IMAGE_BUTTON_SIZE);
        abstractButton.setPreferredSize(IMAGE_BUTTON_SIZE);
        abstractButton.setMaximumSize(IMAGE_BUTTON_SIZE);
    }

    private void doCancel() {
        this.setVisible(false);
    }

    private void doOk() {
        Object object;
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            arrayList.add(this.listModel.getElementAt(i));
        }
        BrowserConfig browserConfig = this.frame.getConfig();
        ArrayList arrayList2 = new ArrayList(browserConfig.getClasspath());
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            object = (ClasspathEntry)iterator.next();
            if (arrayList.contains(object)) continue;
            browserConfig.removeClasspathEntry((ClasspathEntry)object);
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            ClasspathEntry classpathEntry = (ClasspathEntry)object.next();
            if (arrayList2.contains(classpathEntry)) continue;
            browserConfig.addClasspathEntry(classpathEntry);
        }
        browserConfig.setClasspath(arrayList);
        this.setVisible(false);
    }

    private void doAdd() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser(this.frame.getClassesChooserPath());
            this.fileChooser.setDialogTitle("Choose directory or jar file");
            this.fileChooser.setFileFilter(new BasicFileFilter("jar", "jar files and directories"));
            this.fileChooser.setFileSelectionMode(2);
            this.fileChooser.setMultiSelectionEnabled(true);
        }
        if (this.fileChooser.showOpenDialog(this) == 0) {
            this.frame.setClassesChooserPath(this.fileChooser.getCurrentDirectory().getAbsolutePath());
            File[] fileArray = this.fileChooser.getSelectedFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                ClasspathEntry classpathEntry;
                File file = fileArray[i];
                if (file.isDirectory()) {
                    classpathEntry = new ClasspathDirectoryEntry();
                    classpathEntry.setFileName(file.getPath());
                } else {
                    classpathEntry = new ClasspathArchiveEntry();
                    classpathEntry.setFileName(file.getPath());
                }
                if (this.isInModel(classpathEntry)) continue;
                this.listModel.addElement(classpathEntry);
                this.selectIndex(this.listModel.getSize() - 1);
            }
        }
    }

    private boolean isInModel(ClasspathEntry classpathEntry) {
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            if (!this.listModel.getElementAt(i).equals(classpathEntry)) continue;
            return true;
        }
        return false;
    }

    private void doRemove() {
        int n = this.lstElements.getSelectedIndex();
        if (n > -1) {
            this.listModel.remove(n);
            this.selectIndex(n);
        }
    }

    private void doUp() {
        int n = this.lstElements.getSelectedIndex();
        if (n > 0) {
            Object e = this.listModel.remove(n);
            int n2 = n - 1;
            this.listModel.insertElementAt(e, n2);
            this.selectIndex(n2);
        }
    }

    private void doDown() {
        int n = this.lstElements.getSelectedIndex();
        if (n < this.listModel.getSize() - 1) {
            Object e = this.listModel.remove(n);
            int n2 = n + 1;
            this.listModel.insertElementAt(e, n2);
            this.selectIndex(n2);
        }
    }

    private void selectIndex(int n) {
        if ((n = Math.min(n, this.listModel.getSize() - 1)) > -1) {
            this.lstElements.setSelectedIndex(n);
            this.lstElements.ensureIndexIsVisible(n);
        }
    }

    private void checkEnabledStatus() {
        int n = this.lstElements.getSelectedIndex();
        boolean bl = n > -1;
        boolean bl2 = n > 0;
        boolean bl3 = n > -1 && n < this.listModel.getSize() - 1;
        this.btnRemove.setEnabled(bl);
        this.btnUp.setEnabled(bl2);
        this.btnDown.setEnabled(bl3);
    }
}

