# Pure Go implementation of jq
# https://github.com/itchyny/gojq

complete -c gojq -s c -l compact-output -d "Compact output, no pretty-print"
complete -c gojq -s r -l raw-output -d "Output raw strings without quotes"
complete -c gojq -s j -l join-output -d "Stop printing a newline after each output"
complete -c gojq -s 0 -l nul-output -d "Print NUL after each output"
complete -c gojq -s C -l color-output -d "Colorize output even if piped"
complete -c gojq -s M -l monochrome-output -d "Stop colorizing output"
complete -c gojq -l yaml-output -d "Output as YAML"
complete -c gojq -l indent -x -d "Number of spaces for indentation"
complete -c gojq -l tab -d "Use tabs for indentation"
complete -c gojq -s n -l null-input -d "Use null as input value"
complete -c gojq -s R -l raw-input -d "Read input as raw strings"
complete -c gojq -s s -l slurp -d "Read all inputs into an array"
complete -c gojq -l stream -d "Parse input in stream fashion"
complete -c gojq -l yaml-input -d "Read input as YAML"
complete -c gojq -s f -l from-file -rF -d "Load query from file"
complete -c gojq -s L -xa "(__fish_complete_directories)" -d "Directory to search modules from"
complete -c gojq -l arg -x -d "Set variable to string value"
complete -c gojq -l argjson -x -d "Set variable to JSON value"
complete -c gojq -l slurpfile -x -d "Set variable to the JSON contents of the file"
complete -c gojq -l rawfile -x -d "Set variable to the contents of the file"
complete -c gojq -l args -d "Consume remaining arguments as positional string values"
complete -c gojq -l jsonargs -d "Consume remaining arguments as positional JSON values"
complete -c gojq -s e -l exit-status -d "Exit 1 when the last value is false or null"
complete -c gojq -s v -l version -d "Print gojq version"
complete -c gojq -s h -l help -d "Print help"
