// Code generated by go generate
package gateway

const (
	darwinBadRoute          = "darwinBadRoute"
	darwinNoRoute           = "darwinNoRoute"
	darwin                  = "darwin"
	freeBSDBadRoute         = "freeBSDBadRoute"
	freeBSDNoRoute          = "freeBSDNoRoute"
	freeBSD                 = "freeBSD"
	linuxNoRoute            = "linuxNoRoute"
	linux                   = "linux"
	netBSDBadRoute          = "netBSDBadRoute"
	netBSDNoRoute           = "netBSDNoRoute"
	netBSD                  = "netBSD"
	randomData              = "randomData"
	solarisBadRoute         = "solarisBadRoute"
	solarisNoRoute          = "solarisNoRoute"
	solaris                 = "solaris"
	solarisNoInterface      = "solarisNoInterface"
	windowsBadRoute1        = "windowsBadRoute1"
	windowsBadRoute2        = "windowsBadRoute2"
	windowsLocalized        = "windowsLocalized"
	windowsMultipleGateways = "windowsMultipleGateways"
	windowsNoDefaultRoute   = "windowsNoDefaultRoute"
	windowsNoRoute          = "windowsNoRoute"
	windows                 = "windows"
)

var routeTables = map[string][]byte{
	darwinBadRoute: []byte(`
Routing tables

Internet:
Destination        Gateway            Flags      Netif Expire
default            foo                UGSg        en0
10.88.88.0/24      link#1             U           en0
10.88.88.148       link#1             UHS         lo0
127.0.0.1          link#2             UH          lo0
`),

	darwinNoRoute: []byte(`
Routing tables

Internet:
Destination        Gateway            Flags      Netif Expire
10.88.88.0/24      link#1             U           en0
10.88.88.148       link#1             UHS         lo0
127.0.0.1          link#2             UH          lo0
`),

	darwin: []byte(`
Routing tables

Internet:
Destination        Gateway            Flags           Netif Expire
default            link#17            UCSg            utun3
default            192.168.1.254      UGScIg            en0
                            `),

	freeBSDBadRoute: []byte(`
Routing tables

Internet:
Destination        Gateway            Flags      Netif Expire
default            foo                UGS        ena0
10.88.88.0/24      link#1             U          ena0
10.88.88.148       link#1             UHS         lo0
127.0.0.1          link#2             UH          lo0
`),

	freeBSDNoRoute: []byte(`
Routing tables

Internet:
Destination        Gateway            Flags      Netif Expire
10.88.88.0/24      link#1             U          ena0
10.88.88.148       link#1             UHS         lo0
127.0.0.1          link#2             UH          lo0
`),

	freeBSD: []byte(`
Routing tables

Internet:
Destination        Gateway            Flags     Netif Expire
default            10.88.88.2         UGS        ena0
127.0.0.1          link#2             UH          lo0
172.31.16.0/20     link#1             U          ena0
172.31.29.64       link#1             UHS         lo0

Internet6:
Destination                       Gateway                       Flags     Netif Expire
::/96                             ::1                           UGRS        lo0
::1                               link#2                        UHS         lo0
::ffff:0.0.0.0/96                 ::1                           UGRS        lo0
fe80::/10                         ::1                           UGRS        lo0
fe80::%%ena0/64                    link#1                        U          ena0
fe80::4fc:21ff:feeb:60c5%%ena0     link#1                        UHS         lo0
fe80::%%lo0/64                     link#2                        U           lo0
fe80::1%%lo0                       link#2                        UHS         lo0
ff02::/16                         ::1                           UGRS        lo0
`),

	linuxNoRoute: []byte(`
Iface	Destination	Gateway	Flags	RefCnt	Use	Metric	Mask	MTU	Window	IRTT
`),

	linux: []byte(`
Iface	Destination	Gateway 	Flags	RefCnt	Use	Metric	Mask		MTU	Window	IRTT
wlp4s0	0000FEA9	00000000	0001	0	0	1000	0000FFFF	0	0	0
docker0	000011AC	00000000	0001	0	0	0	0000FFFF	0	0	0
docker_gwbridge	000012AC	00000000	0001	0	0	0	0000FFFF	0	0	0
wlp4s0	0008A8C0	00000000	0001	0	0	600	00FFFFFF	0	0	0
wlp4s0	00000000	0108A8C0	0003	0	0	600	00000000	0	0	0
`),

	netBSDBadRoute: []byte(`
Routing tables

Internet:
Destination        Gateway            Flags    Refs      Use    Mtu Interface
default            foo                UG          -        -   9001  ena0
127/8              127.0.0.1          UGRS        -        -  33624  lo0
127.0.0.1          lo0                UHl         -        -  33624  lo0
`),

	netBSDNoRoute: []byte(`
Routing tables

Internet:
Destination        Gateway            Flags    Refs      Use    Mtu Interface
127/8              127.0.0.1          UGRS        -        -  33624  lo0
127.0.0.1          lo0                UHl         -        -  33624  lo0
172.31.16/20       link#1             UC          -        -   9001  ena0
172.31.22.254      link#1             UHl         -        -      -  lo0
172.31.16.1        06:fd:6a:57:a9:12  UHL         -        -      -  ena0
`),

	netBSD: []byte(`
Routing tables

Internet:
Destination        Gateway            Flags    Refs      Use    Mtu Interface
default            172.31.16.1        UG          -        -   9001  ena0
127/8              127.0.0.1          UGRS        -        -  33624  lo0
127.0.0.1          lo0                UHl         -        -  33624  lo0
172.31.16/20       link#1             UC          -        -   9001  ena0
172.31.22.254      link#1             UHl         -        -      -  lo0
172.31.16.1        06:fd:6a:57:a9:12  UHL         -        -      -  ena0

Internet6:
Destination                             Gateway                        Flags    Refs      Use    Mtu Interface
::/104                                  ::1                            UGRS        -        -  33624  lo0
::/96                                   ::1                            UGRS        -        -  33624  lo0
::1                                     lo0                            UHl         -        -  33624  lo0
::127.0.0.0/104                         ::1                            UGRS        -        -  33624  lo0
::224.0.0.0/100                         ::1                            UGRS        -        -  33624  lo0
::255.0.0.0/104                         ::1                            UGRS        -        -  33624  lo0
::ffff:0.0.0.0/96                       ::1                            UGRS        -        -  33624  lo0
2001:db8::/32                           ::1                            UGRS        -        -  33624  lo0
2002::/24                               ::1                            UGRS        -        -  33624  lo0
2002:7f00::/24                          ::1                            UGRS        -        -  33624  lo0
2002:e000::/20                          ::1                            UGRS        -        -  33624  lo0
2002:ff00::/24                          ::1                            UGRS        -        -  33624  lo0
fe80::/10                               ::1                            UGRS        -        -  33624  lo0
fe80::%%ena0/64                          link#1                         UC          -        -      -  ena0
fe80::9508:280a:c38e:4e4a               link#1                         UHl         -        -      -  lo0
fe80::%%lo0/64                           fe80::1                        U           -        -      -  lo0
fe80::1                                 lo0                            UHl         -        -      -  lo0
ff01:1::/32                             link#1                         UC          -        -      -  ena0
ff01:2::/32                             ::1                            UC          -        -  33624  lo0
ff02::%%ena0/32                          link#1                         UC          -        -      -  ena0
ff02::%%lo0/32                           ::1                            UC          -        -  33624  lo0`),

	randomData: []byte(`
test
Lorem ipsum dolor sit amet, consectetur adipiscing elit,
sed do eiusmod tempor incididunt ut labore et dolore magna
aliqua. Ut enim ad minim veniam, quis nostrud exercitation
`),

	solarisBadRoute: []byte(`
Routing Table: IPv4
	Destination           Gateway           Flags  Ref     Use     Interface
-------------------- -------------------- ----- ----- ---------- ---------
default              foo                  UG        2      76419 net0
127.0.0.1            127.0.0.1            UH        2         36 lo0
172.16.32.0          172.16.32.17         U         4       8100 net0

Routing Table: IPv6
	Destination/Mask            Gateway                   Flags Ref   Use    If
--------------------------- --------------------------- ----- --- ------- -----
::1                         ::1                         UH      3   75382 lo0
2001:470:deeb:32::/64       2001:470:deeb:32::17        U       3    2744 net0
fe80::/10                   fe80::6082:52ff:fedc:7df0   U       3    8430 net0
`),

	solarisNoRoute: []byte(`
Routing Table: IPv4
	Destination           Gateway           Flags  Ref     Use     Interface
-------------------- -------------------- ----- ----- ---------- ---------
127.0.0.1            127.0.0.1            UH        2         36 lo0
172.16.32.0          172.16.32.17         U         4       8100 net0

Routing Table: IPv6
	Destination/Mask            Gateway                   Flags Ref   Use    If
--------------------------- --------------------------- ----- --- ------- -----
::1                         ::1                         UH      3   75382 lo0
2001:470:deeb:32::/64       2001:470:deeb:32::17        U       3    2744 net0
fe80::/10                   fe80::6082:52ff:fedc:7df0   U       3    8430 net0
`),

	solaris: []byte(`
Routing Table: IPv4
	Destination           Gateway           Flags  Ref     Use     Interface
-------------------- -------------------- ----- ----- ---------- ---------
default              172.16.32.1          UG        2      76419 net0
127.0.0.1            127.0.0.1            UH        2         36 lo0
172.16.32.0          172.16.32.17         U         4       8100 net0

Routing Table: IPv6
	Destination/Mask            Gateway                   Flags Ref   Use    If
--------------------------- --------------------------- ----- --- ------- -----
::1                         ::1                         UH      3   75382 lo0
2001:470:deeb:32::/64       2001:470:deeb:32::17        U       3    2744 net0
fe80::/10                   fe80::6082:52ff:fedc:7df0   U       3    8430 net0
`),

	solarisNoInterface: []byte(`
Routing Table: IPv4
  Destination            Gateway          Flags  Ref     Use     Interface
-------------------- -------------------- ----- ----- ---------- ---------
default              172.16.32.1          UG       49  681748414
127.0.0.1            127.0.0.1            UH        2      52832 lo0
172.16.32.0          172.16.32.17         U         5    1450483 net0

Routing Table: IPv6
  Destination/Mask            Gateway                   Flags Ref   Use    If
--------------------------- --------------------------- ----- --- ------- -----
::1                         ::1                         UH      2     966 lo0
fe80::/10                   fe80::aabb:ccdd:1234:2      U       5   77620 net0
default                     fe80::aabb:ccdd:1234:1      UG      3 4092447           
`),

	windowsBadRoute1: []byte(`
===========================================================================
Interface List
  8 ...00 12 3f a7 17 ba ...... Intel(R) PRO/100 VE Network Connection
  1 ........................... Software Loopback Interface 1
===========================================================================
IPv4 Route Table
===========================================================================
Active Routes:
===========================================================================
Persistent Routes:
`),

	windowsBadRoute2: []byte(`
===========================================================================
Interface List
  8 ...00 12 3f a7 17 ba ...... Intel(R) PRO/100 VE Network Connection
  1 ........................... Software Loopback Interface 1
===========================================================================
IPv4 Route Table
===========================================================================
Active Routes:
Network Destination        Netmask          Gateway       Interface  Metric
          0.0.0.0          0.0.0.0          foo           10.88.88.149     10
===========================================================================
Persistent Routes:
`),

	windowsLocalized: []byte(`
===========================================================================
Liste d'Interfaces
 17...00 28 f8 39 61 6b ......Microsoft Wi-Fi Direct Virtual Adapter
  1...........................Software Loopback Interface 1
===========================================================================
IPv4 Table de routage
===========================================================================
Itinéraires actifs :
Destination réseau    Masque réseau  Adr. passerelle   Adr. interface Métrique
          0.0.0.0          0.0.0.0      10.88.88.2     10.88.88.149     10
===========================================================================
Itinéraires persistants :
  Aucun`),

	windowsMultipleGateways: []byte(`
===========================================================================
Interface List
 19...00 05 9a 3c 7a 00 ......Cisco AnyConnect Secure Mobility Client Virtual Miniport Adapter for Windows x64
 37...00 15 5d 0e 76 41 ......Hyper-V Virtual Ethernet Adapter
 21...cc 15 31 1e 58 08 ......Microsoft Wi-Fi Direct Virtual Adapter
  9...ce 15 31 1e 58 07 ......Microsoft Wi-Fi Direct Virtual Adapter #2
  6...cc 15 31 1e 58 07 ......Intel(R) Wi-Fi 6 AX201 160MHz
 17...cc 15 31 1e 58 0b ......Bluetooth Device (Personal Area Network)
  1...........................Software Loopback Interface 1
===========================================================================

IPv4 Route Table
===========================================================================
Active Routes:
Network Destination        Netmask          Gateway       Interface  Metric
          0.0.0.0          0.0.0.0    192.168.100.1   192.168.100.74     50
          0.0.0.0          0.0.0.0       10.21.38.1      10.21.38.97      2
===========================================================================
Persistent Routes:
  None

IPv6 Route Table
===========================================================================
Active Routes:
  None
Persistent Routes:
  None`),

	windowsNoDefaultRoute: []byte(`
===========================================================================
Interface List
  8 ...00 12 3f a7 17 ba ...... Intel(R) PRO/100 VE Network Connection
  1 ........................... Software Loopback Interface 1
===========================================================================
IPv4 Route Table
===========================================================================
Active Routes:
Network Destination        Netmask          Gateway       Interface  Metric
        127.0.0.0        255.0.0.0         On-link         127.0.0.1    331
        127.0.0.1  255.255.255.255         On-link         127.0.0.1    331
  127.255.255.255  255.255.255.255         On-link         127.0.0.1    331
===========================================================================
Persistent Routes:
`),

	windowsNoRoute: []byte(`
===========================================================================
Interface List
  8 ...00 12 3f a7 17 ba ...... Intel(R) PRO/100 VE Network Connection
  1 ........................... Software Loopback Interface 1
===========================================================================
IPv4 Route Table
===========================================================================
Active Routes:
`),

	windows: []byte(`
===========================================================================
Interface List
  8 ...00 12 3f a7 17 ba ...... Intel(R) PRO/100 VE Network Connection
  1 ........................... Software Loopback Interface 1
===========================================================================
IPv4 Route Table
===========================================================================
Active Routes:
Network Destination        Netmask          Gateway       Interface  Metric
          0.0.0.0          0.0.0.0       10.88.88.2     10.88.88.149     10
        127.0.0.0        255.0.0.0         On-link         127.0.0.1    331
        127.0.0.1  255.255.255.255         On-link         127.0.0.1    331
  127.255.255.255  255.255.255.255         On-link         127.0.0.1    331
===========================================================================
Persistent Routes:
`),
}
