/*
 * DO NOT EDIT THIS FILE. Generated by checkmk.
 * Edit the original source file "../../libdrgn/tests/recursion_guard.c.in" instead.
 */

#include <check.h>

#line 1 "../../libdrgn/tests/recursion_guard.c.in"
// Copyright (c) Meta Platforms, Inc. and affiliates.
// SPDX-License-Identifier: LGPL-2.1-or-later

#include "test_util.h"
#include "../error.h"

static struct drgn_error *no_recursion_allowed(int *counter)
{
	drgn_recursion_guard(0, "recursive call detected");
	(*counter)++;
	return no_recursion_allowed(counter);
}

static struct drgn_error *limited_recursion_allowed(int *counter)
{
	drgn_recursion_guard(10, "maximum recursion depth exceeded");
	(*counter)++;
	return limited_recursion_allowed(counter);
}


START_TEST(no_recursion)
{
#line 24
{
	int counter = 0;
	struct drgn_error *err = no_recursion_allowed(&counter);
	ck_assert_ptr_nonnull(err);
	ck_assert_int_eq(err->code, DRGN_ERROR_RECURSION);
	ck_assert_str_eq(err->message, "recursive call detected");
	drgn_error_destroy(err);
	ck_assert_int_eq(counter, 1);
}

}
END_TEST

START_TEST(limited_recursion)
{
#line 35
{
	int counter = 0;
	struct drgn_error *err = limited_recursion_allowed(&counter);
	ck_assert_ptr_nonnull(err);
	ck_assert_int_eq(err->code, DRGN_ERROR_RECURSION);
	ck_assert_str_eq(err->message, "maximum recursion depth exceeded");
	drgn_error_destroy(err);
	ck_assert_int_eq(counter, 11);
}
}
END_TEST

int main(void)
{
    Suite *s1 = suite_create("recursion_guard");
    TCase *tc1_1 = tcase_create("recursion_guard");
    SRunner *sr = srunner_create(s1);
    int nf;

    suite_add_tcase(s1, tc1_1);
    tcase_add_test(tc1_1, no_recursion);
    tcase_add_test(tc1_1, limited_recursion);

    srunner_run_all(sr, CK_ENV);
    nf = srunner_ntests_failed(sr);
    srunner_free(sr);

    return nf == 0 ? 0 : 1;
}
