
> **Note**
> Do you want to add yourself to this list? Simply fork the repository and open a PR with the required change.
> We have a short description of the adopter types at the bottom of this page. Each adopter type is in alphabetical order. 
> Once your PR is merged, see our [website repo](https://github.com/kubevirt/kubevirt.github.io?tab=readme-ov-file#adopters) to add your logo to our website.

# KubeVirt Adopters

| Type | Name | Since | Website | Use-Case |
|:-|:-|:-|:-|:-|
| End-user | arm | 2021 | [link](https://www.arm.com) | KubeVirt enables seamless transition from legacy Virtual Machine based workloads to cloud-native container platforms. Arm believes KubeVirt addresses this challenge, allowing Virtual Machines workloads to easily deploy and scale in the cloud and at the edge. <br><br>Arm is an active contributor to the project, focused on enabling and optimizing Kubevirt performance on aarch64 and working with the ecosystem to facilitate users in deploying their workloads on cloud-native platforms. |
| End-user| Bytedance | 2023 | [link](https://www.bytedance.com/en/) | We use KubeVirt as part of our innovation Trusted Container Stack for TEE cluster provisioning. |
| End-user| Civo | 2020 | [link](https://www.civo.com) | We are using KubeVirt as part of our stack to enable tenant cluster provisioning within Civo cloud. |
| End-user | Cloudflare | 2018 | [link](https://www.cloudflare.com/) | Cloudflare uses KubeVirt within its core data centers to accommodate use cases of our teams that are less container friendly, such as our CI runners, while still taking advantage of the Kubernetes environment. |
| End-user | CloudRaft| 2024 | [link](https://cloudraft.io/) | CloudRaft is using KubeVirt to build a GPU Cloud platform for AI workload. KubeVirt allows end users such as Data scientists to experiment on powerful remote VMs equipped with GPUs and AI/ML packages.  |
| End-user | CoreWeave | 2020 | [link](https://www.coreweave.com) | A Kubernetes native cloud provider with focus on GPUs at scale. KubeVirt allows us to co-locate non-containerizable workloads such as Virtual Desktops next to compute intensive containers executing on bare metal. All orchestrated via the Kubernetes API leveraging the same network policies and persistent volumes for both VM and containerized workloads. |
| End-user | Genesis Cloud | 2022 | [link](https://genesiscloud.com/) | Genesis Cloud is basing its public cloud offering for instances with GPUs and other accelerators on kubevirt. |
| End-user | Intel Gaudi | 2024 | [link](https://habana.ai/) | Intel Gaudi utilizes KubeVirt and builds upon open-source projects such as Kubernetes and KubeVirt within its core data centers to empower products like [Intel® Gaudi® 3](https://habana.ai/products/gaudi3/) |
| End-user | Killercoda | 2022 | [link](https://killercoda.com) | Killercoda provides interactive learning environments based on VMs managed by KubeVirt. |
| End-user | The Linux Foundation - Training and Certification | 2022 | [link](https://training.linuxfoundation.org/) | The Linux Foundation uses KubeVirt for provisioning isolated and fully featured environments used to evaluate the hands-on skills required for accreditation in flagship open source technologies. |
| End-user | NVIDIA | 2018 | [link](https://www.nvidia.com) | NVIDIA's latest computing platform is built on open-source projects like Kubernetes and KubeVirt to power products like [GeForce NOW](https://www.nvidia.com/en-us/geforce-now/) with more to come. |
| End-user | S3NS | 2023 | [link](https://www.s3ns.io/en) | S3NS (Thales x Google) is a French cloud provider based on a self-hosted, air-gapped regulated Google Cloud region. We offer public institutions and companies wishing to protect their sensitive data a trusted cloud offer meeting French ANSSI's SecNumCloud label criteria. We are currently using kubevirt for all our underlying core and real-time inspectability private infrastructure.|
| Integration | Kasten by Veeam | 2022 | [link](https://docs.kasten.io/latest/usage/openshift_virtualization.html?highlight=kubevirt) | [Kasten K10](https://www.kasten.io/product/) manages KubeVirt and Red Hat OpenShift Virtualization VMs seamlessly for policy based automation of backup, disaster recovery, and application mobility across different Kubernetes versions, distributions, storage providers, and clouds. |
| Integration | minikube | 2020 | [link](https://minikube.sigs.k8s.io) | |
| Integration | oVirt | 2020 | [link](https://www.ovirt.org/documentation/administration_guide/index.html#proc-adding-kubevirt-openshift-as-an-external-provider_external_providers) | oVirt can view and manage VMs that are running on a KubeVirt cluster. |
| Integration | okd | 2020 | [link](https://www.okd.io) | [OKD Virtualization](https://docs.okd.io/latest/virt/about_virt/about-virt.html) adds KubeVirt functionality to OKD. |
| Integration | osbuild-operator | 2022 | [link](https://github.com/project-flotta/osbuild-operator) | OSBuild-Operator uses KubeVirt to provision its internal worker VMs. |
| Integration | PITS Global Data Recovery Services | 2023 | [link](https://www.pitsdatarecovery.net/) | KubeVirt allows us to manage highly-loaded VMs and containers from one place. |
| Integration | Trilio | 2021 | [link](https://trilio.io/) | TrilioVault has been cloud-native since day one and protects the most demanding environments to maximize stability across all tenants. Our platform is built for flexibility across deployments, integrating seamlessly with Kubernetes, OpenStack and Red Hat Virtualization. That means we can equally backup and restore stateful and stateless applications based on VMs, Containers or VMs in Containers based on KubeVirt.  |
| Vendor | Ænix | 2023 | [link](https://aenix.io/) | Ænix uses KubeVirt in free PaaS platform [Cozystack](https://cozystack.io) for running virtual machines and Kubernetes-as-a-Service. |
| Vendor | Alauda | 2021 | [link](https://www.alauda.io/) | As a distributor we provide KubeVirt-based VM management in Alauda Container Platform. |
| Vendor | Deckhouse | 2022 | [link](https://deckhouse.io/) | Deckhouse is a No-Ops Kubernetes Platform by [Flant](https://flant.com/) which provides out-of-box solution to run any type of production-grade workloads. It includes monitoring, storage, and virtual machines based on KubeVirt. |
| Vendor | EQUINIX | | [link](https://metal.equinix.com/) | |
| Vendor | H3C | 2019 | [link](https://www.h3c.com/en/Products_Technology/Enterprise_Products/Cloud_Computing/Cloud_Computing_Products/H3C_CloudOS/H3C_CloudOS_full-stack/) | We distribute KubeVirt as part of CloudOS to enable VM workloads on Kubernetes at customer sites. |
| Vendor | KUBERMATIC | 2019 | [link](https://www.kubermatic.com/products/kubevirt/) | As a distributor we are running KubeVirt to enable VM workload on Kubermatic Virtualization. |
| Vendor | KUBESPHERE | 2020 | [link](https://kubesphere.cloud/en/ksv/) | KubeSphere Virtualization (KSV) provides lightweight VM management capability based on KubeVirt. |
| Vendor | Microsoft | 2023 | [link](https://www.microsoft.com/) | Microsoft is leveraging KubeVirt to host VM workloads as part of the [Azure Operator Nexus](https://azure.microsoft.com/en-us/products/operator-nexus) platform. |
| Vendor | NCR Voyix | 2024 | [link](https://www.ncrvoyix.com/) | NCR Voyix is leveraging KubeVirt to unify management of virtualized and containerized applications at the edge. |
| Vendor | Oracle | 2023 | [link](https://www.oracle.com) | As a distributor we are leveraging KubeVirt to enable VM workload on [Oracle Cloud Native Environment](https://www.oracle.com/linux/cloud-native-environment/), the Oracle multicloud and on-premises Kubernetes distribution. |
| Vendor | PLATFORM9 | | [link](https://platform9.com/managed-kubevirt/) | Run Legacy and Cloud-Native Applications on Platform9 |
| Vendor | Puzl | 2022 | [link](https://puzl.cloud/) | As a cloud-native computing platform we want to provide users with seamless experience. Many users are familiar with cloud VMs, but not yet with Kubernetes, and with Kubevirt we are giving them a bridge to a cloud-native world to make their migration easier. |
| Vendor | Red Hat, Inc. | 2016 | [link](https://www.redhat.com) | As a distributor we are building OpenShift Virtualization on KubeVirt in order to enable VM workloads and -flows on Kubernetes. |
| Vendor | Spectro Cloud | 2022 | [link](https://www.spectrocloud.com/solutions/vms-on-kubernetes) | Spectro Cloud Palette's Virtual Machine Orchestrator (VMO) feature builds on KubeVirt. It gives enterprises an easy yet powerful way to bring their VM workloads into their Kubernetes clusters, on bare metal and at the edge — with full lifecycle management and unified policies and governance. |
| Vendor | SUSE | 2020 | [link](https://www.suse.com/) | SUSE believes KubeVirt is the best open source way to handle Virtual Machines on Kubernetes today. We offer this additional possibility to our customers by leveraging KubeVirt in our products. |


### Adopter Types

**End-user**: The organization runs KubeVirt in production in some way.

**Integration**: The organization has a product that integrates with KubeVirt, but does not contain KubeVirt.

**Vendor**: The organization packages KubeVirt in their product and sells it as part of their product.

