/*
  Copyright(C) 2002-2007 Pierre Mazire
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

/*
  common.h

  various macros
*/

#ifndef MAMORY_COMMON_H
#define MAMORY_COMMON_H

#include <common/common.h>
#include <stdio.h>
#define LPRINTF(Type, ...) do \
                                 {\
                                  if( Libmamory ## _ ## Type ##  _On)\
                                   {\
				     if(strcmp(#Type,"OUTPUT")==0)\
                                       lprintf(Libmamory_out,\
                                               "Libmamory" ,\
                                               Libmamory_HEADER_ ## Type ## _On,\
                                               Libmamory_HEADER_ ## Type ## _LIBNAME_On,\
                                               FALSE,\
					       LIB_ ## Type,\
                                               __FILE__,__LINE__,\
                                               __VA_ARGS__);\
                                     else\
                                       lprintf(Libmamory_err,\
                                               "Libmamory" ,\
                                               Libmamory_HEADER_ ## Type ## _On,\
                                               Libmamory_HEADER_ ## Type ## _LIBNAME_On,\
                                               FALSE,\
                                               LIB_ ## Type,\
                                               __FILE__,__LINE__,\
                                               __VA_ARGS__);\
                                   };\
                                 } while(0)
  
#define LPRINTFW(Type, ...) do \
                                 {\
                                  if( Libmamory ## _ ## Type ##  _On)\
                                   {\
				     if(strcmp(#Type,"OUTPUT")==0)\
                                       lprintf(Libmamory_out,\
                                               "Libmamory" ,\
                                               Libmamory_HEADER_ ## Type ## _On,\
                                               Libmamory_HEADER_ ## Type ## _LIBNAME_On,\
                                               TRUE,\
					       LIB_ ## Type,\
                                               __FILE__,__LINE__,\
                                               __VA_ARGS__);\
                                     else\
                                       lprintf(Libmamory_err,\
                                               "Libmamory" ,\
                                               Libmamory_HEADER_ ## Type ## _On,\
                                               Libmamory_HEADER_ ## Type ## _LIBNAME_On,\
                                               TRUE,\
                                               LIB_ ## Type,\
                                               __FILE__,__LINE__,\
                                               __VA_ARGS__);\
                                   };\
                                 } while(0)
extern FILE *Libmamory_out;
extern FILE *Libmamory_err;

extern unsigned int Libmamory_WARNING_On;
extern unsigned int Libmamory_ERROR_On;
extern unsigned int Libmamory_OUTPUT_On;
extern unsigned int Libmamory_DEBUG_On;
extern unsigned int Libmamory_HEADER_OUTPUT_On;
extern unsigned int Libmamory_HEADER_WARNING_On;
extern unsigned int Libmamory_HEADER_ERROR_On;
extern unsigned int Libmamory_HEADER_DEBUG_On;
extern unsigned int Libmamory_HEADER_OUTPUT_LIBNAME_On;
extern unsigned int Libmamory_HEADER_WARNING_LIBNAME_On;
extern unsigned int Libmamory_HEADER_ERROR_LIBNAME_On;
extern unsigned int Libmamory_HEADER_DEBUG_LIBNAME_On;

#endif
