#!/bin/bash

file=$1
project=$(echo "$2" | cut -d = -f 2)

if [[ "$file" = "" ]] ; then
    echo "Usage:  $0 <file with smatch messages> -p=<project>"
    exit 1
fi

if [[ "$project" != "kernel" ]] ; then
    exit 0
fi

outfile="kernel.expects_err_ptr"
bin_dir=$(dirname $0)
remove=$(echo ${bin_dir}/../smatch_data/${outfile}.remove)
tmp=$(mktemp /tmp/smatch.XXXX)

echo "// list of functions which expect an ERR_PTR." > $outfile
echo '// generated by `gen_expects_err_ptr.sh`' >> $outfile
grep -w "expects ERR_PTR" $file | cut -d ' ' -f 2,6 | \
    sed -e 's/([1234567890]*)//' | sort -u > $tmp
cat $tmp $remove $remove 2> /dev/null | sort | uniq -u >> $outfile
rm $tmp
echo "Done.  List saved as '$outfile'"
