AC_DEFUN([AM_OPT_FLAGS],[
dnl
dnl figure out how best to optimize
dnl 

gcc_major_version=4
os_system=Linux

if test "$target_cpu" = "powerpc"; then
  AC_DEFINE(POWERPC, 1, "Are we running a ppc CPU?")
  altivecLinux=
  if test "$?" = "0"; then
    AC_DEFINE(HAVE_ALTIVEC_LINUX, 1, "Is there Altivec Support ?")
    if test "$gcc_major_version" = "3"; then
dnl -mcpu=7450 does not reliably work with gcc 3.*
      OPT_FLAGS="-D_REENTRANT -O3 -mcpu=7400 -maltivec -mabi=altivec"
    else
      OPT_FLAGS="-D_REENTRANT -O3 -mcpu=7400"
    fi
  else
    OPT_FLAGS="-D_REENTRANT -O3 -mcpu=750 -mmultiple"
  fi
  OPT_FLAGS="$OPT_FLAGS -mhard-float -mpowerpc-gfxopt"
elif echo $target_cpu | grep "i*86" >/dev/null; then
 if test "$os_system" = "Darwin"; then
   # pretty good assumption
   mmx="-mmmx" 
   sse="-msse -mfpmath=sse"
   OPT_FLAGS="-D_REENTRANT -Os -fomit-frame-pointer $mmx $sse"   
 else
  cat /proc/cpuinfo | grep mmx >/dev/null
  if test $? = 0; then
    mmx="-mmmx"
  fi
  cat /proc/cpuinfo | grep sse >/dev/null
  if test $? = 0; then
    sse="-msse -mfpmath=sse"
  fi
  cat /proc/cpuinfo | grep 3dnow >/dev/null
  if test $? = 0; then
    dreidnow="-m3dnow"
  fi
 
 
  AC_DEFINE(x86, 1, "Nope its intel")
  if test "$target_cpu" = "i586"; then
    OPT_FLAGS="-DREENTRANT -O2 -march=i586 -fomit-frame-pointer"
  elif test "$target_cpu" = "i686"; then
    OPT_FLAGS="-D_REENTRANT -O2 -march=i686 -fomit-frame-pointer"
    if test "$gcc_major_version" -ge "3"; then
      OPT_FLAGS="$OPT_FLAGS $mmx $sse $dreidnow"
    fi
  else
    OPT_FLAGS="-D_REENTRANT -O2 -fomit-frame-pointer"
  fi
 fi
fi

OPT_FLAGS="$OPT_FLAGS -pipe"

# LARGEFILE_FLAGS="`getconf LFS_CFLAGS`"
LARGEFILE_FLAGS="-D_LARGEFILE_SOURCE -D_LARGEFILE64_SOURCE"

CXXFLAGS="-g -D_REENTRANT $LARGEFILE_FLAGS"
if test x"$GXX" = xyes ; then
   CXXFLAGS="$CXXFLAGS -Wall"
fi
if test x"$GXX" = xyes ; then
   OPT_CXXFLAGS="$OPT_FLAGS -Wall $LARGEFILE_FLAGS"
fi

PROF_FLAGS="-pg"

dnl 
dnl some link flags to try to speed linking
dnl

CXXFLAGS="$CXXFLAGS -fno-merge-constants"

])
