# Serialized Data Documentation

This documents all the OpenTimelineIO classes that serialize to and from JSON,
omitting SchemaDef plugins. This document is automatically generated by
running:

`src/py-opentimelineio/opentimelineio/console/autogen_serialized_datamodel.py`

or by running:

`make doc-model`

It is part of the unit tests suite and should be updated whenever the schema
changes.  If it needs to be updated and this file regenerated, run:

`make doc-model-update`

# Class Documentation


## Module: opentimelineio.adapters

### Adapter.1

*full module path*: `opentimelineio.adapters.Adapter`

*documentation*:

```
Adapters convert between OTIO and other formats.

    Note that this class is not subclassed by adapters. Rather, an adapter is
    a python module that implements at least one of the following functions:

    .. code-block:: python

        write_to_string(input_otio)
        write_to_file(input_otio, filepath) (optionally inferred)
        read_from_string(input_str)
        read_from_file(filepath) (optionally inferred)

    ...as well as a small json file that advertises the features of the adapter
    to OTIO.  This class serves as the wrapper around these modules internal
    to OTIO.  You should not need to extend this class to create new adapters
    for OTIO.

    For more information: https://opentimelineio.readthedocs.io/en/latest/tutorials/write-an-
adapter.html. # noqa
    
```

parameters:
- *filepath*: Absolute path or relative path to adapter module from location of json.
- *name*: Adapter name.
- *suffixes*: File suffixes associated with this adapter.

## Module: opentimelineio.core

### Composable.1

*full module path*: `opentimelineio.core.Composable`

*documentation*:

```

An object that can be composed within a :class:`~Composition` (such as :class:`~Track` or 
:class:`.Stack`).

```

parameters:
- *metadata*: 
- *name*: 

### Composition.1

*full module path*: `opentimelineio.core.Composition`

*documentation*:

```

Base class for an :class:`~Item` that contains :class:`~Composable`\s.

Should be subclassed (for example by :class:`.Track` and :class:`.Stack`), not used directly.

```

parameters:
- *effects*: 
- *enabled*: If true, an Item contributes to compositions. For example, when an audio/video clip is ``enabled=false`` the clip is muted/hidden.
- *markers*: 
- *metadata*: 
- *name*: 
- *source_range*: 

### Item.1

*full module path*: `opentimelineio.core.Item`

*documentation*:

```
None
```

parameters:
- *effects*: 
- *enabled*: If true, an Item contributes to compositions. For example, when an audio/video clip is ``enabled=false`` the clip is muted/hidden.
- *markers*: 
- *metadata*: 
- *name*: 
- *source_range*: 

### MediaReference.1

*full module path*: `opentimelineio.core.MediaReference`

*documentation*:

```
None
```

parameters:
- *available_image_bounds*: 
- *available_range*: 
- *metadata*: 
- *name*: 

### SerializableObjectWithMetadata.1

*full module path*: `opentimelineio.core.SerializableObjectWithMetadata`

*documentation*:

```
None
```

parameters:
- *metadata*: 
- *name*: 

## Module: opentimelineio.hooks

### HookScript.1

*full module path*: `opentimelineio.hooks.HookScript`

*documentation*:

```
None
```

parameters:
- *filepath*: Absolute path or relative path to adapter module from location of json.
- *name*: Adapter name.

## Module: opentimelineio.media_linker

### MediaLinker.1

*full module path*: `opentimelineio.media_linker.MediaLinker`

*documentation*:

```
None
```

parameters:
- *filepath*: Absolute path or relative path to adapter module from location of json.
- *name*: Adapter name.

## Module: opentimelineio.opentime

### RationalTime.1

*full module path*: `opentimelineio.opentime.RationalTime`

*documentation*:

```

The RationalTime class represents a measure of time of :math:`rt.value/rt.rate` seconds.
It can be rescaled into another :class:`~RationalTime`'s rate.

```

parameters:
- *rate*: 
- *value*: 

### TimeRange.1

*full module path*: `opentimelineio.opentime.TimeRange`

*documentation*:

```

The TimeRange class represents a range in time. It encodes the start time and the duration,
meaning that :meth:`end_time_inclusive` (last portion of a sample in the time range) and
:meth:`end_time_exclusive` can be computed.

```

parameters:
- *duration*: 
- *start_time*: 

### TimeTransform.1

*full module path*: `opentimelineio.opentime.TimeTransform`

*documentation*:

```
1D transform for :class:`~RationalTime`. Has offset and scale.
```

parameters:
- *offset*: 
- *rate*: 
- *scale*: 

## Module: opentimelineio.plugins

### PluginManifest.1

*full module path*: `opentimelineio.plugins.Manifest`

*documentation*:

```
Defines an OTIO plugin Manifest.

    This is considered an internal OTIO implementation detail.

    A manifest tracks a collection of plugins and enables finding them by name
    or other features (in the case of adapters, what file suffixes they
    advertise support for).

    For more information, consult the documenation.
    
```

parameters:
- *adapters*: Adapters this manifest describes.
- *hook_scripts*: Scripts that can be attached to hooks.
- *hooks*: Hooks that hooks scripts can be attached to.
- *media_linkers*: Media Linkers this manifest describes.
- *schemadefs*: Schemadefs this manifest describes.
- *version_manifests*: Sets of versions to downgrade schemas to.

### SerializableObject.1

*full module path*: `opentimelineio.plugins.PythonPlugin`

*documentation*:

```
A class of plugin that is encoded in a python module, exposed via a
    manifest.
    
```

parameters:
- *filepath*: Absolute path or relative path to adapter module from location of json.
- *name*: Adapter name.

## Module: opentimelineio.schema

### Clip.2

*full module path*: `opentimelineio.schema.Clip`

*documentation*:

```

A :class:`~Clip` is a segment of editable media (usually audio or video).

Contains a :class:`.MediaReference` and a trim on that media reference.

```

parameters:
- *active_media_reference_key*: 
- *effects*: 
- *enabled*: If true, an Item contributes to compositions. For example, when an audio/video clip is ``enabled=false`` the clip is muted/hidden.
- *markers*: 
- *media_references*: 
- *metadata*: 
- *name*: 
- *source_range*: 

### Effect.1

*full module path*: `opentimelineio.schema.Effect`

*documentation*:

```
None
```

parameters:
- *effect_name*: 
- *metadata*: 
- *name*: 

### ExternalReference.1

*full module path*: `opentimelineio.schema.ExternalReference`

*documentation*:

```
None
```

parameters:
- *available_image_bounds*: 
- *available_range*: 
- *metadata*: 
- *name*: 
- *target_url*: 

### FreezeFrame.1

*full module path*: `opentimelineio.schema.FreezeFrame`

*documentation*:

```
Hold the first frame of the clip for the duration of the clip.
```

parameters:
- *effect_name*: 
- *metadata*: 
- *name*: 
- *time_scalar*: Linear time scalar applied to clip. 2.0 means the clip occupies half the time in the parent item, i.e. plays at double speed,
0.5 means the clip occupies twice the time in the parent item, i.e. plays at half speed.

Note that adjusting the time_scalar of a :class:`~LinearTimeWarp` does not affect the duration of the item this effect is attached to.
Instead it affects the speed of the media displayed within that item.

### Gap.1

*full module path*: `opentimelineio.schema.Gap`

*documentation*:

```
None
```

parameters:
- *effects*: 
- *enabled*: If true, an Item contributes to compositions. For example, when an audio/video clip is ``enabled=false`` the clip is muted/hidden.
- *markers*: 
- *metadata*: 
- *name*: 
- *source_range*: 

### GeneratorReference.1

*full module path*: `opentimelineio.schema.GeneratorReference`

*documentation*:

```
None
```

parameters:
- *available_image_bounds*: 
- *available_range*: 
- *generator_kind*: 
- *metadata*: 
- *name*: 
- *parameters*: 

### ImageSequenceReference.1

*full module path*: `opentimelineio.schema.ImageSequenceReference`

*documentation*:

```

An ImageSequenceReference refers to a numbered series of single-frame image files. Each file can be 
referred to by a URL generated by the :class:`~ImageSequenceReference`.

Image sequences can have URLs with discontinuous frame numbers, for instance if you've only rendered
 every other frame in a sequence, your frame numbers may be 1, 3, 5, etc. This is configured using 
the ``frame_step`` attribute. In this case, the 0th image in the sequence is frame 1 and the 1st 
image in the sequence is frame 3. Because of this there are two numbering concepts in the image 
sequence, the image number and the frame number.

Frame numbers are the integer numbers used in the frame file name. Image numbers are the 0-index 
based numbers of the frames available in the reference. Frame numbers can be discontinuous, image 
numbers will always be zero to the total count of frames minus 1.

An example for 24fps media with a sample provided each frame numbered 1-1000 with a path 
``/show/sequence/shot/sample_image_sequence.%04d.exr`` might be

.. code-block:: json

    {
      "available_range": {
        "start_time": {
          "value": 0,
          "rate": 24
        },
        "duration": {
          "value": 1000,
          "rate": 24
        }
      },
      "start_frame": 1,
      "frame_step": 1,
      "rate": 24,
      "target_url_base": "file:///show/sequence/shot/",
      "name_prefix": "sample_image_sequence.",
      "name_suffix": ".exr"
      "frame_zero_padding": 4,
    }

The same duration sequence but with only every 2nd frame available in the sequence would be

.. code-block:: json

    {
      "available_range": {
        "start_time": {
          "value": 0,
          "rate": 24
        },
        "duration": {
          "value": 1000,
          "rate": 24
        }
      },
      "start_frame": 1,
      "frame_step": 2,
      "rate": 24,
      "target_url_base": "file:///show/sequence/shot/",
      "name_prefix": "sample_image_sequence.",
      "name_suffix": ".exr"
      "frame_zero_padding": 4,
    }

A list of all the frame URLs in the sequence can be generated, regardless of frame step, with the 
following list comprehension

.. code-block:: python

    [ref.target_url_for_image_number(i) for i in range(ref.number_of_images_in_sequence())]

Negative ``start_frame`` is also handled. The above example with a ``start_frame`` of ``-1`` would 
yield the first three target urls as:

- ``file:///show/sequence/shot/sample_image_sequence.-0001.exr``
- ``file:///show/sequence/shot/sample_image_sequence.0000.exr``
- ``file:///show/sequence/shot/sample_image_sequence.0001.exr``

```

parameters:
- *available_image_bounds*: 
- *available_range*: 
- *frame_step*: Step between frame numbers in file names.
- *frame_zero_padding*: Number of digits to pad zeros out to in frame numbers.
- *metadata*: 
- *missing_frame_policy*: Directive for how frames in sequence not found during playback or rendering should be handled.
- *name*: 
- *name_prefix*: Everything in the file name leading up to the frame number.
- *name_suffix*: Everything after the frame number in the file name.
- *rate*: Frame rate if every frame in the sequence were played back.
- *start_frame*: The first frame number used in file names.
- *target_url_base*: Everything leading up to the file name in the ``target_url``.

### LinearTimeWarp.1

*full module path*: `opentimelineio.schema.LinearTimeWarp`

*documentation*:

```

A time warp that applies a linear speed up or slow down across the entire clip.

```

parameters:
- *effect_name*: 
- *metadata*: 
- *name*: 
- *time_scalar*: Linear time scalar applied to clip. 2.0 means the clip occupies half the time in the parent item, i.e. plays at double speed,
0.5 means the clip occupies twice the time in the parent item, i.e. plays at half speed.

Note that adjusting the time_scalar of a :class:`~LinearTimeWarp` does not affect the duration of the item this effect is attached to.
Instead it affects the speed of the media displayed within that item.

### Marker.2

*full module path*: `opentimelineio.schema.Marker`

*documentation*:

```

A marker indicates a marked range of time on an item in a timeline, usually with a name, color or 
other metadata.

The marked range may have a zero duration. The marked range is in the owning item's time coordinate 
system.

```

parameters:
- *color*: Color string for this marker (for example: 'RED'), based on the :class:`~Color` enum.
- *comment*: Optional comment for this marker.
- *marked_range*: Range this marker applies to, relative to the :class:`.Item` this marker is attached to (e.g. the :class:`.Clip` or :class:`.Track` that owns this marker).
- *metadata*: 
- *name*: 

### MissingReference.1

*full module path*: `opentimelineio.schema.MissingReference`

*documentation*:

```

Represents media for which a concrete reference is missing.

Note that a :class:`~MissingReference` may have useful metadata, even if the location of the media 
is not known.

```

parameters:
- *available_image_bounds*: 
- *available_range*: 
- *metadata*: 
- *name*: 

### SerializableCollection.1

*full module path*: `opentimelineio.schema.SerializableCollection`

*documentation*:

```

A container which can hold an ordered list of any serializable objects. Note that this is not a 
:class:`.Composition` nor is it :class:`.Composable`.

This container approximates the concept of a bin - a collection of :class:`.SerializableObject`\s 
that do
not have any compositional meaning, but can serialize to/from OTIO correctly, with metadata and
a named collection.

A :class:`~SerializableCollection` is useful for serializing multiple timelines, clips, or media 
references to a single file.

```

parameters:
- *metadata*: 
- *name*: 

### Stack.1

*full module path*: `opentimelineio.schema.Stack`

*documentation*:

```
None
```

parameters:
- *effects*: 
- *enabled*: If true, an Item contributes to compositions. For example, when an audio/video clip is ``enabled=false`` the clip is muted/hidden.
- *markers*: 
- *metadata*: 
- *name*: 
- *source_range*: 

### TimeEffect.1

*full module path*: `opentimelineio.schema.TimeEffect`

*documentation*:

```
Base class for all effects that alter the timing of an item.
```

parameters:
- *effect_name*: 
- *metadata*: 
- *name*: 

### Timeline.1

*full module path*: `opentimelineio.schema.Timeline`

*documentation*:

```
None
```

parameters:
- *global_start_time*: 
- *metadata*: 
- *name*: 
- *tracks*: 

### Track.1

*full module path*: `opentimelineio.schema.Track`

*documentation*:

```
None
```

parameters:
- *effects*: 
- *enabled*: If true, an Item contributes to compositions. For example, when an audio/video clip is ``enabled=false`` the clip is muted/hidden.
- *kind*: 
- *markers*: 
- *metadata*: 
- *name*: 
- *source_range*: 

### Transition.1

*full module path*: `opentimelineio.schema.Transition`

*documentation*:

```
Represents a transition between the two adjacent items in a :class:`.Track`. For example, a cross 
dissolve or wipe.
```

parameters:
- *in_offset*: Amount of the previous clip this transition overlaps, exclusive.
- *metadata*: 
- *name*: 
- *out_offset*: Amount of the next clip this transition overlaps, exclusive.
- *transition_type*: Kind of transition, as defined by the :class:`Type` enum.

### SchemaDef.1

*full module path*: `opentimelineio.schema.SchemaDef`

*documentation*:

```
None
```

parameters:
- *filepath*: Absolute path or relative path to adapter module from location of json.
- *name*: Adapter name.
