/* $Id: Spliced_exon.hpp 393366 2013-03-25 14:12:29Z mozese2 $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Spliced_exon.hpp
/// User-defined methods of the data storage class.
///
/// This file was originally generated by application DATATOOL
/// using the following specifications:
/// 'seqalign.asn'.
///
/// New methods or data members can be added to it if needed.
/// See also: Spliced_exon_.hpp


#ifndef OBJECTS_SEQALIGN_SPLICED_EXON_HPP
#define OBJECTS_SEQALIGN_SPLICED_EXON_HPP


// generated includes
#include <objects/seqalign/Spliced_exon_.hpp>
#include <objects/seqalign/Seq_align.hpp>

#include <util/range_coll.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

class CSeq_interval;
class CSpliced_seg;

/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQALIGN_EXPORT CSpliced_exon : public CSpliced_exon_Base
{
    typedef CSpliced_exon_Base Tparent;
public:
    // constructor
    CSpliced_exon(void);
    // destructor
    ~CSpliced_exon(void);

    CRef<CSeq_interval> CreateRowSeq_interval(CSeq_align::TDim    row,
                                              const CSpliced_seg& seg) const;

    /// Return exon's range within this row
    ///
    /// @param row
    ///   0 for product, 1 for genomic
    /// @param always_as_nuc
    ///   If true, row is 0 and product is a protein, return range as a nucleic
    ///   acid sequence; be default for a protein return range over amino acids
    TSeqRange GetRowSeq_range(CSeq_align::TDim    row,
                              bool always_as_nuc) const;

    /// Return insertions within exon
    ///
    /// @param row
    ///   return gaps in this row; 0 for product, 1 for genomic
    /// @param seg
    ///   Parent SPliced-seg object
    CRangeCollection<TSeqPos> GetRowSeq_insertions(CSeq_align::TDim    row,
                                             const CSpliced_seg& seg) const;

    /// Return insertions within exon
    ///
    /// @param row
    ///   return gaps in this row; 0 for product, 1 for genomic
    /// @param seg
    ///   Parent SPliced-seg object
    /// @param within_product_ranges
    ///   Only return insertions within these ranges on the product. If row is
    /// 1, return genomic insertions aligned to a position within these ranges
    CRangeCollection<TSeqPos> GetRowSeq_insertions(
        CSeq_align::TDim    row,
        const CSpliced_seg& seg,
        const CRangeCollection<TSeqPos> &within_product_ranges) const;

private:
    // Prohibit copy constructor and assignment operator
    CSpliced_exon(const CSpliced_exon& value);
    CSpliced_exon& operator=(const CSpliced_exon& value);

};

/////////////////// CSpliced_exon inline methods

// constructor
inline
CSpliced_exon::CSpliced_exon(void)
{
}


/////////////////// end of CSpliced_exon inline methods


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQALIGN_SPLICED_EXON_HPP
/* Original file checksum: lines: 86, chars: 2479, CRC32: e6b79c71 */
