#ifndef DBAPI_DRIVER_FTDS64_FREETDS___CONFIG__H
#define DBAPI_DRIVER_FTDS64_FREETDS___CONFIG__H

/*  $Id: config.h 362183 2012-05-08 12:21:35Z ivanovp $
 *
 *  FreeTDS 0.64 (TDS ver. 8.0) config file.
 *
 *  NOTE:  Instead of being generated by the FreeTDS's own configure script,
 *         it just uses the NCBI C++ Toolkit config file <ncbiconf.h>.
 */

#define NCBI_FTDS 8
#ifdef NCBI_FTDS_ALLOW_TDS_80
#  define TDS80     1
#else
#  define TDS70     1
#endif
#define VERSION   "0.64"
#define UNIXODBC  1

#include <ncbiconf.h>

#ifndef NCBI_FTDS_RENAME_SYBDB
#  define NCBI_FTDS_RENAME_SYBDB
#endif

#ifdef _DEBUG
#define DEBUG 1
/* Should we leave the extra checks off? */
#define ENABLE_EXTRA_CHECKS 1
#endif

#include <dbapi/driver/ftds64/ncbi_ftds_rename_sybdb_ver64.h>
#include <dbapi/driver/ftds64/freetds/rename_freetds64.h>

#if defined(HAVE_GETHOSTBYADDR_R)
#  if   HAVE_GETHOSTBYADDR_R == 5
#    define HAVE_FUNC_GETHOSTBYADDR_R_5 1
#  elif HAVE_GETHOSTBYADDR_R == 7
#    define HAVE_FUNC_GETHOSTBYADDR_R_7 1
#  elif HAVE_GETHOSTBYADDR_R == 8
#    define HAVE_FUNC_GETHOSTBYADDR_R_8 1
#  else
#    error "Unexpected number of arguments detected for gethostbyaddr_r()"
#  endif
#endif

#if defined(HAVE_GETHOSTBYNAME_R)
#  if   HAVE_GETHOSTBYNAME_R == 3
#     define HAVE_FUNC_GETHOSTBYNAME_R_3 1
#  elif HAVE_GETHOSTBYNAME_R == 5
#     define HAVE_FUNC_GETHOSTBYNAME_R_5 1
#  elif HAVE_GETHOSTBYNAME_R == 6
#     define HAVE_FUNC_GETHOSTBYNAME_R_6 1
#  else
#    error "Unexpected number of arguments detected for gethostbyname_r()"
#  endif
#endif


#ifdef NCBI_HAVE_GETPWUID_R
#  if NCBI_HAVE_GETPWUID_R == 4
#    define HAVE_FUNC_GETPWUID_R_4 1
#    define HAVE_FUNC_GETPWUID_R_4_PW 1
#  elif NCBI_HAVE_GETPWUID_R == 5
#    define HAVE_FUNC_GETPWUID_R_5 1
#  else
#    error "Unexpected number of arguments detected for getpwuid_r()"
#  endif
#endif

#if defined(HAVE_GETSERVBYNAME_R)
#  if HAVE_GETSERVBYNAME_R == 4
#    define HAVE_FUNC_GETSERVBYNAME_R_4 1
#  elif HAVE_GETSERVBYNAME_R == 5
#    define HAVE_FUNC_GETSERVBYNAME_R_5 1
#  elif HAVE_GETSERVBYNAME_R == 6
#    define HAVE_FUNC_GETSERVBYNAME_R_6 1
#  else
#    error "Unexpected number of arguments detected for getservbyname_r()"
#  endif
#endif

#if defined(HAVE_LIBICONV)
#  define HAVE_ICONV 1
#endif

#if SIZEOF_LONG == 8  ||  SIZEOF_LONG_LONG == 8  ||  SIZEOF___INT64 == 8
#  define HAVE_INT64 1
#endif

#ifndef HAVE_SOCKLEN_T
typedef int socklen_t;
#endif

#if defined(HAVE_LIBGNUTLS)
#  define HAVE_GNUTLS 1
#endif

#if defined(HAVE_LIBOPENSSL)
#  define HAVE_OPENSSL 1
#endif

#if defined(HAVE_ATTRIBUTE_DESTRUCTOR)
#  define TDS_ATTRIBUTE_DESTRUCTOR 1
#endif

#if defined(HAVE_PTHREAD_MUTEX)
#  define TDS_HAVE_PTHREAD_MUTEX 1
#endif

#ifdef NCBI_SQLCOLATTRIBUTE_SQLLEN
#  define TDS_SQLCOLATTRIBUTE_SQLLEN 1
#endif

#if defined(NCBI_COMPILER_MSVC)
#  define snprintf _snprintf
#endif

#ifdef NCBI_COMPILER_MSVC
#  define HAVE_SSPI 1
#elif HAVE_LIBKRB5
#  define ENABLE_KRB5 1
#endif

#endif  /* DBAPI_DRIVER_FTDS64_FREETDS___CONFIG__H */
